/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public class Code93Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.CODE_93) {
            throw new IllegalArgumentException("Can only encode CODE_93, but got ".concat(String.valueOf((Object)barcodeFormat)));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got ".concat(String.valueOf(n4)));
        }
        int[] nArray = new int[9];
        int n5 = (string.length() + 2 + 2) * 9 + 1;
        Code93Writer.a(Code93Reader.a[47], nArray);
        boolean[] blArray = new boolean[n5];
        int n6 = Code93Writer.a(blArray, 0, nArray);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string.charAt(n3));
            Code93Writer.a(Code93Reader.a[n2], nArray);
            n6 += Code93Writer.a(blArray, n6, nArray);
        }
        n3 = Code93Writer.a(string, 20);
        Code93Writer.a(Code93Reader.a[n3], nArray);
        n6 += Code93Writer.a(blArray, n6, nArray);
        n2 = Code93Writer.a(string + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(n3), 15);
        Code93Writer.a(Code93Reader.a[n2], nArray);
        n6 += Code93Writer.a(blArray, n6, nArray);
        Code93Writer.a(Code93Reader.a[47], nArray);
        n6 += Code93Writer.a(blArray, n6, nArray);
        blArray[n6] = true;
        return blArray;
    }

    private static void a(int n2, int[] nArray) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n3 = n2 & 1 << 8 - i2;
            nArray[i2] = n3 == 0 ? 0 : 1;
        }
    }

    @Deprecated
    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean bl2) {
        return Code93Writer.a(blArray, n2, nArray);
    }

    private static int a(boolean[] blArray, int n2, int[] nArray) {
        for (int n3 : nArray) {
            blArray[n2++] = n3 != 0;
        }
        return 9;
    }

    private static int a(String string, int n2) {
        int n3 = 1;
        int n4 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            int n5 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string.charAt(i2));
            n4 += n5 * n3;
            if (++n3 <= n2) continue;
            n3 = 1;
        }
        return n4 % 47;
    }
}

