/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Map;

public final class EAN8Writer
extends UPCEANWriter {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.EAN_8) {
            throw new IllegalArgumentException("Can only encode EAN_8, but got ".concat(String.valueOf((Object)barcodeFormat)));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public final boolean[] encode(String string) {
        int n2;
        int n3;
        int n4 = string.length();
        switch (n4) {
            case 7: {
                try {
                    n4 = UPCEANReader.a(string);
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException(formatException);
                }
                string = string + n4;
                break;
            }
            case 8: {
                try {
                    if (!UPCEANReader.a(string)) {
                        throw new IllegalArgumentException("Contents do not pass checksum");
                    }
                    break;
                }
                catch (FormatException formatException) {
                    throw new IllegalArgumentException("Illegal contents");
                }
            }
            default: {
                throw new IllegalArgumentException("Requested contents should be 8 digits long, but got ".concat(String.valueOf(n4)));
            }
        }
        boolean[] blArray = new boolean[67];
        int n5 = 0 + EAN8Writer.appendPattern(blArray, 0, UPCEANReader.b, true);
        for (n3 = 0; n3 <= 3; ++n3) {
            n2 = Character.digit(string.charAt(n3), 10);
            n5 += EAN8Writer.appendPattern(blArray, n5, UPCEANReader.a[n2], false);
        }
        n5 += EAN8Writer.appendPattern(blArray, n5, UPCEANReader.c, false);
        for (n3 = 4; n3 <= 7; ++n3) {
            n2 = Character.digit(string.charAt(n3), 10);
            n5 += EAN8Writer.appendPattern(blArray, n5, UPCEANReader.a[n2], true);
        }
        EAN8Writer.appendPattern(blArray, n5, UPCEANReader.b, true);
        return blArray;
    }
}

