/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class ITFWriter
extends OneDimensionalCodeWriter {
    private static final int[] a = new int[]{1, 1, 1, 1};
    private static final int[] b = new int[]{3, 1, 1};

    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (barcodeFormat != BarcodeFormat.ITF) {
            throw new IllegalArgumentException("Can only encode ITF, but got ".concat(String.valueOf((Object)barcodeFormat)));
        }
        return super.encode(string, barcodeFormat, n2, n3, map);
    }

    @Override
    public final boolean[] encode(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            throw new IllegalArgumentException("The length of the input should be even");
        }
        if (n2 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got ".concat(String.valueOf(n2)));
        }
        boolean[] blArray = new boolean[9 + n2 * 9];
        int n3 = ITFWriter.appendPattern(blArray, 0, a, true);
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n4 = Character.digit(string.charAt(i2), 10);
            int n5 = Character.digit(string.charAt(i2 + 1), 10);
            int[] nArray = new int[10];
            for (int i3 = 0; i3 < 5; ++i3) {
                nArray[2 * i3] = ITFReader.a[n4][i3];
                nArray[2 * i3 + 1] = ITFReader.a[n5][i3];
            }
            n3 += ITFWriter.appendPattern(blArray, n3, nArray, true);
        }
        ITFWriter.appendPattern(blArray, n3, b, true);
        return blArray;
    }
}

