/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import com.google.zxing.pdf417.decoder.PDF417ScanningDecoder;
import com.google.zxing.pdf417.detector.Detector;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Map;

public final class PDF417Reader
implements Reader,
MultipleBarcodeReader {
    @Override
    public final Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap resultArray, Map<DecodeHintType, ?> map) {
        if ((resultArray = PDF417Reader.a((BinaryBitmap)resultArray, map, false)) == null || resultArray.length == 0 || resultArray[0] == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        return resultArray[0];
    }

    @Override
    public final Result[] decodeMultiple(BinaryBitmap binaryBitmap) {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public final Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) {
        try {
            return PDF417Reader.a(binaryBitmap, map, true);
        }
        catch (ChecksumException | FormatException readerException) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static Result[] a(BinaryBitmap object, Map<DecodeHintType, ?> object2, boolean bl2) {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        object = Detector.detect((BinaryBitmap)object, object2, bl2);
        for (ResultPoint[] object3 : ((PDF417DetectorResult)object).getPoints()) {
            Object object4 = PDF417ScanningDecoder.decode(((PDF417DetectorResult)object).getBits(), object3[4], object3[5], object3[6], object3[7], PDF417Reader.b(object3), PDF417Reader.a(object3));
            Result result = new Result(((DecoderResult)object4).getText(), ((DecoderResult)object4).getRawBytes(), object3, BarcodeFormat.PDF_417);
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ((DecoderResult)object4).getECLevel());
            object4 = (PDF417ResultMetadata)((DecoderResult)object4).getOther();
            if (object4 != null) {
                result.putMetadata(ResultMetadataType.PDF417_EXTRA_METADATA, object4);
            }
            arrayList.add(result);
        }
        ArrayList<Result> arrayList2 = arrayList;
        return arrayList2.toArray(new Result[arrayList2.size()]);
    }

    private static int a(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint == null || resultPoint2 == null) {
            return 0;
        }
        return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
    }

    private static int b(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint == null || resultPoint2 == null) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
    }

    private static int a(ResultPoint[] resultPointArray) {
        return Math.max(Math.max(PDF417Reader.a(resultPointArray[0], resultPointArray[4]), PDF417Reader.a(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.max(PDF417Reader.a(resultPointArray[1], resultPointArray[5]), PDF417Reader.a(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    private static int b(ResultPoint[] resultPointArray) {
        return Math.min(Math.min(PDF417Reader.b(resultPointArray[0], resultPointArray[4]), PDF417Reader.b(resultPointArray[6], resultPointArray[2]) * 17 / 18), Math.min(PDF417Reader.b(resultPointArray[1], resultPointArray[5]), PDF417Reader.b(resultPointArray[7], resultPointArray[3]) * 17 / 18));
    }

    @Override
    public final void reset() {
    }
}

