/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.util.Map;

public final class QRCodeWriter
implements Writer {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    @Override
    public final BitMatrix encode(String string, BarcodeFormat enum_, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (enum_ != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got ".concat(String.valueOf(enum_)));
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n2 + 'x' + n3);
        }
        enum_ = ErrorCorrectionLevel.L;
        int n4 = 4;
        if (map != null) {
            if (map.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                enum_ = ErrorCorrectionLevel.valueOf(map.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                n4 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
            }
        }
        return QRCodeWriter.a(Encoder.encode(string, (ErrorCorrectionLevel)enum_, map), n2, n3, n4);
    }

    private static BitMatrix a(QRCode object, int n2, int n3, int n4) {
        if ((object = ((QRCode)object).getMatrix()) == null) {
            throw new IllegalStateException();
        }
        int n5 = ((ByteMatrix)object).getWidth();
        int n6 = ((ByteMatrix)object).getHeight();
        int n7 = n5 + (n4 << 1);
        n4 = n6 + (n4 << 1);
        n2 = Math.max(n2, n7);
        n3 = Math.max(n3, n4);
        n4 = Math.min(n2 / n7, n3 / n4);
        n7 = (n2 - n5 * n4) / 2;
        int n8 = (n3 - n6 * n4) / 2;
        BitMatrix bitMatrix = new BitMatrix(n2, n3);
        n3 = 0;
        while (n3 < n6) {
            int n9 = 0;
            int n10 = n7;
            while (n9 < n5) {
                if (((ByteMatrix)object).get(n9, n3) == 1) {
                    int n11 = n4;
                    bitMatrix.setRegion(n10, n8, n11, n11);
                }
                ++n9;
                n10 += n4;
            }
            ++n3;
            n8 += n4;
        }
        return bitMatrix;
    }
}

