/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.decoder.Version$ECBlocks;
import com.google.zxing.qrcode.encoder.BlockPair;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder$1;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.MatrixUtil;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] a = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};

    private Encoder() {
    }

    public static QRCode encode(String string, ErrorCorrectionLevel errorCorrectionLevel) {
        return Encoder.encode(string, errorCorrectionLevel, null);
    }

    public static QRCode encode(String object, ErrorCorrectionLevel errorCorrectionLevel, Map<EncodeHintType, ?> object2) {
        Object object3;
        Object object4;
        CharacterSetECI characterSetECI;
        Object object5 = "ISO-8859-1";
        boolean bl2 = object2 != null && object2.containsKey((Object)EncodeHintType.CHARACTER_SET);
        if (bl2) {
            object5 = object2.get((Object)EncodeHintType.CHARACTER_SET).toString();
        }
        Mode mode = Encoder.a((String)object, (String)object5);
        BitArray bitArray = new BitArray();
        if (mode == Mode.BYTE && (bl2 || !"ISO-8859-1".equals(object5)) && (characterSetECI = CharacterSetECI.getCharacterSetECIByName((String)object5)) != null) {
            object4 = bitArray;
            object3 = characterSetECI;
            ((BitArray)object4).appendBits(Mode.ECI.getBits(), 4);
            ((BitArray)object4).appendBits(((CharacterSetECI)((Object)object3)).getValue(), 8);
        }
        object4 = bitArray;
        object3 = mode;
        ((BitArray)object4).appendBits(((Mode)((Object)object3)).getBits(), 4);
        BitArray bitArray2 = new BitArray();
        Object object6 = object5;
        Object object7 = bitArray2;
        object4 = mode;
        object3 = object;
        switch (Encoder$1.a[((Enum)object4).ordinal()]) {
            case 1: {
                object5 = object7;
                Object object8 = object3;
                int n2 = object8.length();
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = object8.charAt(n3) - 48;
                    if (n3 + 2 < n2) {
                        int n5 = object8.charAt(n3 + 1) - 48;
                        int n6 = object8.charAt(n3 + 2) - 48;
                        ((BitArray)object5).appendBits(n4 * 100 + n5 * 10 + n6, 10);
                        n3 += 3;
                        continue;
                    }
                    if (n3 + 1 < n2) {
                        int n7 = object8.charAt(n3 + 1) - 48;
                        ((BitArray)object5).appendBits(n4 * 10 + n7, 7);
                        n3 += 2;
                        continue;
                    }
                    ((BitArray)object5).appendBits(n4, 4);
                    ++n3;
                }
                break;
            }
            case 2: {
                object5 = object7;
                Object object9 = object3;
                int n2 = object9.length();
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = Encoder.a(object9.charAt(n8));
                    if (n9 == -1) {
                        throw new WriterException();
                    }
                    if (n8 + 1 < n2) {
                        int n10 = Encoder.a(object9.charAt(n8 + 1));
                        if (n10 == -1) {
                            throw new WriterException();
                        }
                        ((BitArray)object5).appendBits(n9 * 45 + n10, 11);
                        n8 += 2;
                        continue;
                    }
                    ((BitArray)object5).appendBits(n9, 6);
                    ++n8;
                }
                break;
            }
            case 3: {
                Object object10 = object3;
                object4 = object6;
                object3 = object7;
                object5 = object10;
                try {
                    object5 = ((String)object5).getBytes((String)object4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new WriterException(unsupportedEncodingException);
                }
                for (Object object11 : object5) {
                    ((BitArray)object3).appendBits((int)object11, 8);
                }
                break;
            }
            case 4: {
                Object object12 = object3;
                object3 = object7;
                object5 = object12;
                try {
                    object5 = ((String)object5).getBytes("Shift_JIS");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new WriterException(unsupportedEncodingException);
                }
                int n2 = ((Object)object5).length;
                for (int i2 = 0; i2 < n2; i2 += 2) {
                    int n11 = object5[i2] & 0xFF;
                    int n12 = object5[i2 + 1] & 0xFF;
                    n11 = n11 << 8 | n12;
                    n12 = -1;
                    if (n11 >= 33088 && n11 <= 40956) {
                        n12 = n11 - 33088;
                    } else if (n11 >= 57408 && n11 <= 60351) {
                        n12 = n11 - 49472;
                    }
                    if (n12 == -1) {
                        throw new WriterException("Invalid byte sequence");
                    }
                    n11 = (n12 >> 8) * 192 + (n12 & 0xFF);
                    ((BitArray)object3).appendBits(n11, 13);
                }
                break;
            }
            default: {
                throw new WriterException("Invalid mode: ".concat(String.valueOf(object4)));
            }
        }
        if (object2 != null && object2.containsKey((Object)EncodeHintType.QR_VERSION)) {
            if (!Encoder.a(Encoder.a(mode, bitArray, bitArray2, (Version)(object2 = Version.getVersionForNumber(Integer.parseInt(object2.get((Object)EncodeHintType.QR_VERSION).toString())))), (Version)object2, errorCorrectionLevel)) {
                throw new WriterException("Data too big for requested version");
            }
        } else {
            object6 = bitArray2;
            object7 = bitArray;
            Mode mode2 = mode;
            ErrorCorrectionLevel errorCorrectionLevel2 = errorCorrectionLevel;
            object5 = Encoder.a(Encoder.a(mode2, (BitArray)object7, (BitArray)object6, Version.getVersionForNumber(1)), errorCorrectionLevel2);
            object2 = Encoder.a(Encoder.a(mode2, (BitArray)object7, (BitArray)object6, (Version)object5), errorCorrectionLevel2);
        }
        object5 = new BitArray();
        ((BitArray)object5).appendBitArray(bitArray);
        object6 = object5;
        object7 = mode;
        Object object13 = object2;
        int n13 = mode == Mode.BYTE ? bitArray2.getSizeInBytes() : ((String)object).length();
        int n14 = ((Mode)((Object)object7)).getCharacterCountBits((Version)object13);
        if (n13 >= 1 << n14) {
            throw new WriterException(n13 + " is bigger than " + ((1 << n14) - 1));
        }
        ((BitArray)object6).appendBits(n13, n14);
        ((BitArray)object5).appendBitArray(bitArray2);
        object = ((Version)object2).getECBlocksForLevel(errorCorrectionLevel);
        int n15 = ((Version)object2).getTotalCodewords() - ((Version$ECBlocks)object).getTotalECCodewords();
        Encoder.a(n15, (BitArray)object5);
        object = Encoder.a((BitArray)object5, ((Version)object2).getTotalCodewords(), n15, ((Version$ECBlocks)object).getNumBlocks());
        object5 = new QRCode();
        ((QRCode)object5).setECLevel(errorCorrectionLevel);
        ((QRCode)object5).setMode(mode);
        ((QRCode)object5).setVersion((Version)object2);
        int n16 = n15 = ((Version)object2).getDimensionForVersion();
        ByteMatrix byteMatrix = new ByteMatrix(n16, n16);
        int n17 = Encoder.a((BitArray)object, errorCorrectionLevel, (Version)object2, byteMatrix);
        ((QRCode)object5).setMaskPattern(n17);
        MatrixUtil.a((BitArray)object, errorCorrectionLevel, (Version)object2, n17, byteMatrix);
        ((QRCode)object5).setMatrix(byteMatrix);
        return object5;
    }

    private static int a(Mode mode, BitArray bitArray, BitArray bitArray2, Version version) {
        return bitArray.getSize() + mode.getCharacterCountBits(version) + bitArray2.getSize();
    }

    private static int a(int n2) {
        if (n2 < 96) {
            return a[n2];
        }
        return -1;
    }

    public static Mode chooseMode(String string) {
        return Encoder.a(string, null);
    }

    private static Mode a(String string, String string2) {
        if ("Shift_JIS".equals(string2) && Encoder.a(string)) {
            return Mode.KANJI;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                bl2 = true;
                continue;
            }
            if (Encoder.a(c2) != -1) {
                bl3 = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl3) {
            return Mode.ALPHANUMERIC;
        }
        if (bl2) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean a(String object) {
        try {
            object = ((String)object).getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int n2 = ((Object)object).length;
        if (n2 % 2 != 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = object[i2] & 0xFF;
            if (n3 >= 129 && n3 <= 159 || n3 >= 224 && n3 <= 235) continue;
            return false;
        }
        return true;
    }

    private static int a(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, ByteMatrix byteMatrix) {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i2 = 0; i2 < 8; ++i2) {
            MatrixUtil.a(bitArray, errorCorrectionLevel, version, i2, byteMatrix);
            ByteMatrix byteMatrix2 = byteMatrix;
            int n4 = MaskUtil.a(byteMatrix2) + MaskUtil.b(byteMatrix2) + MaskUtil.c(byteMatrix2) + MaskUtil.d(byteMatrix2);
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i2;
        }
        return n3;
    }

    private static Version a(int n2, ErrorCorrectionLevel errorCorrectionLevel) {
        for (int i2 = 1; i2 <= 40; ++i2) {
            Version version = Version.getVersionForNumber(i2);
            if (!Encoder.a(n2, version, errorCorrectionLevel)) continue;
            return version;
        }
        throw new WriterException("Data too big");
    }

    private static boolean a(int n2, Version version, ErrorCorrectionLevel errorCorrectionLevel) {
        int n3 = version.getTotalCodewords();
        int n4 = version.getECBlocksForLevel(errorCorrectionLevel).getTotalECCodewords();
        return (n4 = n3 - n4) >= (n2 = (n2 + 7) / 8);
    }

    private static void a(int n2, BitArray bitArray) {
        int n3;
        int n4 = n2 << 3;
        if (bitArray.getSize() > n4) {
            throw new WriterException("data bits cannot fit in the QR Code" + bitArray.getSize() + " > " + n4);
        }
        for (n3 = 0; n3 < 4 && bitArray.getSize() < n4; ++n3) {
            bitArray.appendBit(false);
        }
        n3 = bitArray.getSize() & 7;
        if (n3 > 0) {
            while (n3 < 8) {
                bitArray.appendBit(false);
                ++n3;
            }
        }
        n3 = n2 - bitArray.getSizeInBytes();
        for (n2 = 0; n2 < n3; ++n2) {
            bitArray.appendBits((n2 & 1) == 0 ? 236 : 17, 8);
        }
        if (bitArray.getSize() != n4) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    private static BitArray a(BitArray bitArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray;
        Object object;
        if (bitArray.getSizeInBytes() != n3) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        ArrayList<BlockPair> arrayList = new ArrayList<BlockPair>(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n9;
            int[] nArray = new int[1];
            int[] nArray2 = object = new int[1];
            int[] nArray3 = nArray;
            int n10 = i2;
            int n11 = n4;
            int n12 = n3;
            int n13 = n2;
            if (n10 >= n11) {
                throw new WriterException("Block ID too large");
            }
            int n14 = n13 % n11;
            int n15 = n11 - n14;
            int n16 = n13 / n11;
            int n17 = n16 + 1;
            if ((n16 -= (n12 /= n11)) != (n17 -= (n9 = n12 + 1))) {
                throw new WriterException("EC bytes mismatch");
            }
            if (n11 != n15 + n14) {
                throw new WriterException("RS blocks mismatch");
            }
            if (n13 != (n12 + n16) * n15 + (n9 + n17) * n14) {
                throw new WriterException("Total bytes mismatch");
            }
            if (n10 < n15) {
                nArray3[0] = n12;
                nArray2[0] = n16;
            } else {
                nArray3[0] = n9;
                nArray2[0] = n17;
            }
            n13 = nArray[0];
            byArray = new byte[n13];
            bitArray.toBytes(n6 << 3, byArray, 0, n13);
            object = Encoder.a(byArray, (int)object[0]);
            arrayList.add(new BlockPair(byArray, (byte[])object));
            n7 = Math.max(n7, n13);
            n8 = Math.max(n8, ((int[])object).length);
            n6 += nArray[0];
        }
        if (n3 != n6) {
            throw new WriterException("Data bytes does not match offset");
        }
        BitArray bitArray2 = new BitArray();
        for (n5 = 0; n5 < n7; ++n5) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                byArray = ((BlockPair)object.next()).getDataBytes();
                if (n5 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n5], 8);
            }
        }
        for (n5 = 0; n5 < n8; ++n5) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                byArray = ((BlockPair)object.next()).getErrorCorrectionBytes();
                if (n5 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n5], 8);
            }
        }
        if (n2 != bitArray2.getSizeInBytes()) {
            throw new WriterException("Interleaving error: " + n2 + " and " + bitArray2.getSizeInBytes() + " differ.");
        }
        return bitArray2;
    }

    private static byte[] a(byte[] byArray, int n2) {
        int n3 = byArray.length;
        int[] nArray = new int[n3 + n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(nArray, n2);
        byte[] byArray2 = new byte[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            byArray2[i3] = (byte)nArray[n3 + i3];
        }
        return byArray2;
    }
}

