/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;

public abstract class BaseForeignCollection<T, ID>
implements g<T>,
Serializable {
    private static final long serialVersionUID = -5158840898186237589L;
    protected final transient Dao<T, ID> dao;
    private final transient FieldType foreignFieldType;
    private final transient Object parentId;
    private transient B<T> preparedQuery;
    private final transient String orderColumn;
    private final transient boolean orderAscending;
    private final transient Object parent;

    protected BaseForeignCollection(Dao<T, ID> dao, Object object, Object object2, FieldType fieldType, String string, boolean bl2) {
        this.dao = dao;
        this.foreignFieldType = fieldType;
        this.parentId = object2;
        this.orderColumn = string;
        this.orderAscending = bl2;
        this.parent = object;
    }

    @Override
    public boolean add(T t2) {
        try {
            return this.addElement(t2);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Could not create data element in dao", sQLException);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> object) {
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            try {
                if (!this.addElement(e2)) continue;
                bl2 = true;
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException("Could not create data elements in dao", sQLException);
            }
        }
        return bl2;
    }

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public abstract boolean removeAll(Collection<?> var1);

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl2;
        if (this.dao == null) {
            return false;
        }
        boolean bl3 = false;
        e e2 = this.closeableIterator();
        try {
            while (e2.hasNext()) {
                Object e3 = e2.next();
                if (collection.contains(e3)) continue;
                e2.remove();
                bl3 = true;
            }
            bl2 = bl3;
        }
        catch (Throwable throwable) {
            try {
                e2.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            e2.close();
        }
        catch (SQLException sQLException) {}
        return bl2;
    }

    @Override
    public void clear() {
        if (this.dao == null) {
            return;
        }
        e e2 = this.closeableIterator();
        try {
            while (e2.hasNext()) {
                e2.next();
                e2.remove();
            }
        }
        catch (Throwable throwable) {
            try {
                e2.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            e2.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public int update(T t2) {
        if (this.dao == null) {
            return 0;
        }
        return this.dao.update(t2);
    }

    public int refresh(T t2) {
        if (this.dao == null) {
            return 0;
        }
        return this.dao.refresh(t2);
    }

    protected B<T> getPreparedQuery() {
        if (this.dao == null) {
            return null;
        }
        if (this.preparedQuery == null) {
            SelectArg selectArg = new SelectArg();
            selectArg.setValue(this.parentId);
            QueryBuilder<T, ID> queryBuilder = this.dao.queryBuilder();
            if (this.orderColumn != null) {
                queryBuilder.orderBy(this.orderColumn, this.orderAscending);
            }
            this.preparedQuery = queryBuilder.where().eq(this.foreignFieldType.getColumnName(), selectArg).prepare();
            if (this.preparedQuery instanceof MappedPreparedStmt) {
                ((MappedPreparedStmt)this.preparedQuery).setParentInformation(this.parent, this.parentId);
            }
        }
        return this.preparedQuery;
    }

    private boolean addElement(T t2) {
        if (this.dao == null) {
            return false;
        }
        if (this.parent != null && this.foreignFieldType.getFieldValueIfNotDefault(t2) == null) {
            this.foreignFieldType.assignField(t2, this.parent, true, null);
        }
        this.dao.create(t2);
        return true;
    }
}

