/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager$ClassConnectionSource;
import com.j256.ormlite.dao.DaoManager$TableConfigConnectionSource;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DaoManager {
    private static Map<Class<?>, DatabaseTableConfig<?>> configMap = null;
    private static Map<DaoManager$ClassConnectionSource, Dao<?, ?>> classMap = null;
    private static Map<DaoManager$TableConfigConnectionSource, Dao<?, ?>> tableConfigMap = null;
    private static Logger logger = LoggerFactory.getLogger(DaoManager.class);

    public static synchronized <D extends Dao<T, ?>, T> D createDao(O o2, Class<T> clazz) {
        if (o2 == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        Object object = DaoManager.lookupDao(new DaoManager$ClassConnectionSource(o2, clazz));
        if (object != null) {
            return (D)object;
        }
        object = (Dao)DaoManager.createDaoFromConfig(o2, clazz);
        if (object != null) {
            return (D)object;
        }
        object = clazz.getAnnotation(Q.class);
        if (object == null || object.a() == Void.class || object.a() == BaseDaoImpl.class) {
            object = o2.a().extractDatabaseTableConfig(o2, clazz);
            Dao dao = object == null ? BaseDaoImpl.createDao(o2, clazz) : BaseDaoImpl.createDao(o2, object);
            object = dao;
            logger.debug("created dao for class {} with reflection", clazz);
        } else {
            Class<?> clazz2 = object.a();
            object = new Object[]{o2, clazz};
            Constructor<?> constructor = DaoManager.findConstructor(clazz2, object);
            if (constructor == null && (constructor = DaoManager.findConstructor(clazz2, object = new Object[]{o2})) == null) {
                throw new SQLException("Could not find public constructor with ConnectionSource and optional Class parameters " + clazz2 + ".  Missing static on class?");
            }
            try {
                object = (Dao)constructor.newInstance(object);
                logger.debug("created dao for class {} from constructor", clazz);
            }
            catch (Exception exception) {
                throw LoggerFactory$1.create("Could not call the constructor in class ".concat(String.valueOf(clazz2)), exception);
            }
        }
        DaoManager.registerDao(o2, object);
        return (D)object;
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(O o2, Class<T> clazz) {
        if (o2 == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        return (D)DaoManager.lookupDao(new DaoManager$ClassConnectionSource(o2, clazz));
    }

    public static synchronized <D extends Dao<T, ?>, T> D createDao(O o2, DatabaseTableConfig<T> databaseTableConfig) {
        if (o2 == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        return DaoManager.doCreateDao(o2, databaseTableConfig);
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(O object, DatabaseTableConfig<T> databaseTableConfig) {
        if (object == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        if ((object = DaoManager.lookupDao(new DaoManager$TableConfigConnectionSource((O)object, databaseTableConfig))) == null) {
            return null;
        }
        return (D)object;
    }

    public static synchronized void registerDao(O o2, Dao<?, ?> dao) {
        if (o2 == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        DaoManager.addDaoToClassMap(new DaoManager$ClassConnectionSource(o2, dao.getDataClass()), dao);
    }

    public static synchronized void unregisterDao(O o2, Dao<?, ?> dao) {
        if (o2 == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        DaoManager.removeDaoToClassMap(new DaoManager$ClassConnectionSource(o2, dao.getDataClass()), dao);
    }

    public static synchronized void registerDaoWithTableConfig(O o2, Dao<?, ?> dao) {
        DatabaseTableConfig databaseTableConfig;
        if (o2 == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        if (dao instanceof BaseDaoImpl && (databaseTableConfig = ((BaseDaoImpl)dao).getTableConfig()) != null) {
            DaoManager.addDaoToTableMap(new DaoManager$TableConfigConnectionSource(o2, databaseTableConfig), dao);
            return;
        }
        DaoManager.addDaoToClassMap(new DaoManager$ClassConnectionSource(o2, dao.getDataClass()), dao);
    }

    public static synchronized void clearCache() {
        if (configMap != null) {
            configMap.clear();
            configMap = null;
        }
        DaoManager.clearDaoCache();
    }

    public static synchronized void clearDaoCache() {
        if (classMap != null) {
            classMap.clear();
            classMap = null;
        }
        if (tableConfigMap != null) {
            tableConfigMap.clear();
            tableConfigMap = null;
        }
    }

    public static synchronized void addCachedDatabaseConfigs(Collection<DatabaseTableConfig<?>> object) {
        HashMap<Object, Object> hashMap = configMap == null ? new HashMap() : new HashMap(configMap);
        object = object.iterator();
        while (object.hasNext()) {
            DatabaseTableConfig databaseTableConfig = (DatabaseTableConfig)object.next();
            hashMap.put(databaseTableConfig.getDataClass(), databaseTableConfig);
            logger.info("Loaded configuration for {}", databaseTableConfig.getDataClass());
        }
        configMap = hashMap;
    }

    private static void addDaoToClassMap(DaoManager$ClassConnectionSource daoManager$ClassConnectionSource, Dao<?, ?> dao) {
        if (classMap == null) {
            classMap = new HashMap();
        }
        classMap.put(daoManager$ClassConnectionSource, dao);
    }

    private static void removeDaoToClassMap(DaoManager$ClassConnectionSource daoManager$ClassConnectionSource, Dao<?, ?> dao) {
        if (classMap != null) {
            classMap.remove(daoManager$ClassConnectionSource);
        }
    }

    private static void addDaoToTableMap(DaoManager$TableConfigConnectionSource daoManager$TableConfigConnectionSource, Dao<?, ?> dao) {
        if (tableConfigMap == null) {
            tableConfigMap = new HashMap();
        }
        tableConfigMap.put(daoManager$TableConfigConnectionSource, dao);
    }

    private static <T> Dao<?, ?> lookupDao(DaoManager$ClassConnectionSource object) {
        if (classMap == null) {
            classMap = new HashMap();
        }
        if ((object = classMap.get(object)) == null) {
            return null;
        }
        return object;
    }

    private static <T> Dao<?, ?> lookupDao(DaoManager$TableConfigConnectionSource object) {
        if (tableConfigMap == null) {
            tableConfigMap = new HashMap();
        }
        if ((object = tableConfigMap.get(object)) == null) {
            return null;
        }
        return object;
    }

    private static Constructor<?> findConstructor(Class<?> constructorArray, Object[] objectArray) {
        for (Constructor<?> constructor : constructorArray.getConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            boolean bl2 = true;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (classArray[i2].isAssignableFrom(objectArray[i2].getClass())) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return constructor;
        }
        return null;
    }

    private static <D, T> D createDaoFromConfig(O o2, Class<T> object) {
        if (configMap == null) {
            return null;
        }
        if ((object = configMap.get(object)) == null) {
            return null;
        }
        return DaoManager.doCreateDao(o2, object);
    }

    private static <D extends Dao<T, ?>, T> D doCreateDao(O objectArray, DatabaseTableConfig<T> constructor) {
        DaoManager$TableConfigConnectionSource daoManager$TableConfigConnectionSource = new DaoManager$TableConfigConnectionSource((O)objectArray, (DatabaseTableConfig<?>)((Object)constructor));
        Object object = DaoManager.lookupDao(daoManager$TableConfigConnectionSource);
        if (object != null) {
            return (D)object;
        }
        Class<T> clazz = ((DatabaseTableConfig)((Object)constructor)).getDataClass();
        DaoManager$ClassConnectionSource daoManager$ClassConnectionSource = new DaoManager$ClassConnectionSource((O)objectArray, clazz);
        object = DaoManager.lookupDao(daoManager$ClassConnectionSource);
        if (object != null) {
            DaoManager.addDaoToTableMap(daoManager$TableConfigConnectionSource, object);
            return (D)object;
        }
        object = ((DatabaseTableConfig)((Object)constructor)).getDataClass().getAnnotation(Q.class);
        if (object == null || object.a() == Void.class || object.a() == BaseDaoImpl.class) {
            object = BaseDaoImpl.createDao((O)objectArray, constructor);
        } else {
            Class<?> clazz2 = object.a();
            constructor = DaoManager.findConstructor(clazz2, objectArray = new Object[]{objectArray, constructor});
            if (constructor == null) {
                throw new SQLException("Could not find public constructor with ConnectionSource, DatabaseTableConfig parameters in class ".concat(String.valueOf(clazz2)));
            }
            try {
                object = (Dao<?, ?>)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw LoggerFactory$1.create("Could not call the constructor in class ".concat(String.valueOf(clazz2)), exception);
            }
        }
        DaoManager.addDaoToTableMap(daoManager$TableConfigConnectionSource, object);
        logger.debug("created dao for class {} from table config", clazz);
        if (DaoManager.lookupDao(daoManager$ClassConnectionSource) == null) {
            DaoManager.addDaoToClassMap(daoManager$ClassConnectionSource, object);
        }
        return (D)object;
    }
}

