/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;

public abstract class BaseDatabaseType
implements m {
    protected static String DEFAULT_SEQUENCE_SUFFIX = "_id_seq";
    protected Driver driver;

    protected abstract String getDriverClassName();

    public void loadDriver() {
        String string = this.getDriverClassName();
        if (string != null) {
            try {
                Class.forName(string);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw LoggerFactory$1.create("Driver class was not found for " + this.a() + " database.  Missing jar with class " + string + ".", classNotFoundException);
            }
        }
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public void appendColumnArg(String object, StringBuilder stringBuilder, FieldType fieldType, List<String> list, List<String> list2, List<String> list3, List<String> list4) {
        this.appendEscapedEntityName(stringBuilder, fieldType.getColumnName());
        stringBuilder.append(' ');
        p p2 = fieldType.getDataPersister();
        int n2 = fieldType.getWidth();
        if (n2 == 0) {
            n2 = p2.getDefaultWidth();
        }
        switch (p2.getSqlType()) {
            case STRING: {
                this.appendStringType(stringBuilder, fieldType, n2);
                break;
            }
            case LONG_STRING: {
                this.appendLongStringType(stringBuilder, fieldType, n2);
                break;
            }
            case BOOLEAN: {
                this.appendBooleanType(stringBuilder, fieldType, n2);
                break;
            }
            case DATE: {
                this.appendDateType(stringBuilder, fieldType, n2);
                break;
            }
            case CHAR: {
                this.appendCharType(stringBuilder, fieldType, n2);
                break;
            }
            case BYTE: {
                this.appendByteType(stringBuilder, fieldType, n2);
                break;
            }
            case BYTE_ARRAY: {
                this.appendByteArrayType(stringBuilder, fieldType, n2);
                break;
            }
            case SHORT: {
                this.appendShortType(stringBuilder, fieldType, n2);
                break;
            }
            case INTEGER: {
                this.appendIntegerType(stringBuilder, fieldType, n2);
                break;
            }
            case LONG: {
                this.appendLongType(stringBuilder, fieldType, n2);
                break;
            }
            case FLOAT: {
                this.appendFloatType(stringBuilder, fieldType, n2);
                break;
            }
            case DOUBLE: {
                this.appendDoubleType(stringBuilder, fieldType, n2);
                break;
            }
            case SERIALIZABLE: {
                this.appendSerializableType(stringBuilder, fieldType, n2);
                break;
            }
            case BIG_DECIMAL: {
                this.appendBigDecimalNumericType(stringBuilder, fieldType, n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SQL-type " + (Object)((Object)p2.getSqlType()));
            }
        }
        stringBuilder.append(' ');
        if (fieldType.isGeneratedIdSequence() && !fieldType.isSelfGeneratedId()) {
            this.configureGeneratedIdSequence(stringBuilder, fieldType, list2, list, list4);
        } else if (fieldType.isGeneratedId() && !fieldType.isSelfGeneratedId()) {
            this.configureGeneratedId((String)object, stringBuilder, fieldType, list2, list3, list, list4);
        } else if (fieldType.isId()) {
            this.configureId(stringBuilder, fieldType, list2, list, list4);
        }
        if (!fieldType.isGeneratedId()) {
            object = fieldType.getDefaultValue();
            if (object != null) {
                stringBuilder.append("DEFAULT ");
                this.appendDefaultValue(stringBuilder, fieldType, object);
                stringBuilder.append(' ');
            }
            if (fieldType.isCanBeNull()) {
                this.appendCanBeNull(stringBuilder, fieldType);
            } else {
                stringBuilder.append("NOT NULL ");
            }
            if (fieldType.isUnique()) {
                this.addSingleUnique(stringBuilder, fieldType, list, list3);
            }
        }
    }

    protected void appendStringType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        if (this.isVarcharFieldWidthSupported()) {
            stringBuilder.append("VARCHAR(").append(n2).append(")");
            return;
        }
        stringBuilder.append("VARCHAR");
    }

    protected void appendLongStringType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("TEXT");
    }

    protected void appendDateType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("TIMESTAMP");
    }

    protected void appendBooleanType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("BOOLEAN");
    }

    protected void appendCharType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("CHAR");
    }

    protected void appendByteType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("TINYINT");
    }

    protected void appendShortType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("SMALLINT");
    }

    private void appendIntegerType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("INTEGER");
    }

    protected void appendLongType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("BIGINT");
    }

    private void appendFloatType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("FLOAT");
    }

    private void appendDoubleType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("DOUBLE PRECISION");
    }

    protected void appendByteArrayType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("BLOB");
    }

    protected void appendSerializableType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("BLOB");
    }

    protected void appendBigDecimalNumericType(StringBuilder stringBuilder, FieldType fieldType, int n2) {
        stringBuilder.append("NUMERIC");
    }

    private void appendDefaultValue(StringBuilder stringBuilder, FieldType fieldType, Object object) {
        if (fieldType.isEscapedDefaultValue()) {
            this.appendEscapedWord(stringBuilder, object.toString());
            return;
        }
        stringBuilder.append(object);
    }

    protected void configureGeneratedIdSequence(StringBuilder stringBuilder, FieldType fieldType, List<String> list, List<String> list2, List<String> list3) {
        throw new SQLException("GeneratedIdSequence is not supported by database " + this.a() + " for field " + fieldType);
    }

    protected void configureGeneratedId(String string, StringBuilder stringBuilder, FieldType fieldType, List<String> list, List<String> list2, List<String> list3, List<String> list4) {
        throw new IllegalStateException("GeneratedId is not supported by database " + this.a() + " for field " + fieldType);
    }

    protected void configureId(StringBuilder stringBuilder, FieldType fieldType, List<String> list, List<String> list2, List<String> list3) {
    }

    @Override
    public void addPrimaryKeySql(FieldType[] fieldTypeArray, List<String> list, List<String> object, List<String> list2, List<String> list3) {
        object = null;
        for (FieldType fieldType : fieldTypeArray) {
            if (fieldType.isGeneratedId() && !this.generatedIdSqlAtEnd() && !fieldType.isSelfGeneratedId() || !fieldType.isId()) continue;
            if (object == null) {
                object = new StringBuilder(48);
                ((StringBuilder)object).append("PRIMARY KEY (");
            } else {
                ((StringBuilder)object).append(',');
            }
            this.appendEscapedEntityName((StringBuilder)object, fieldType.getColumnName());
        }
        if (object != null) {
            ((StringBuilder)object).append(") ");
            list.add(((StringBuilder)object).toString());
        }
    }

    protected boolean generatedIdSqlAtEnd() {
        return true;
    }

    @Override
    public void addUniqueComboSql(FieldType[] fieldTypeArray, List<String> list, List<String> object, List<String> list2, List<String> list3) {
        object = null;
        for (FieldType fieldType : fieldTypeArray) {
            if (!fieldType.isUniqueCombo()) continue;
            if (object == null) {
                object = new StringBuilder(48);
                ((StringBuilder)object).append("UNIQUE (");
            } else {
                ((StringBuilder)object).append(',');
            }
            this.appendEscapedEntityName((StringBuilder)object, fieldType.getColumnName());
        }
        if (object != null) {
            ((StringBuilder)object).append(") ");
            list.add(((StringBuilder)object).toString());
        }
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> list, List<String> list2) {
    }

    @Override
    public void appendEscapedWord(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\'').append(string).append('\'');
    }

    @Override
    public void appendEscapedEntityName(StringBuilder stringBuilder, String string) {
        stringBuilder.append('`').append(string).append('`');
    }

    @Override
    public String generateIdSequenceName(String string, FieldType fieldType) {
        string = string + DEFAULT_SEQUENCE_SUFFIX;
        if (this.isEntityNamesMustBeUpCase()) {
            return string.toUpperCase();
        }
        return string;
    }

    public String getCommentLinePrefix() {
        return "-- ";
    }

    @Override
    public q getFieldConverter(p p2) {
        return p2;
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return false;
    }

    public boolean isVarcharFieldWidthSupported() {
        return true;
    }

    @Override
    public boolean isLimitSqlSupported() {
        return true;
    }

    @Override
    public boolean isOffsetSqlSupported() {
        return true;
    }

    @Override
    public boolean isOffsetLimitArgument() {
        return false;
    }

    @Override
    public boolean isLimitAfterSelect() {
        return false;
    }

    @Override
    public void appendLimitValue(StringBuilder stringBuilder, long l2, Long l3) {
        stringBuilder.append("LIMIT ").append(l2).append(' ');
    }

    @Override
    public void appendOffsetValue(StringBuilder stringBuilder, long l2) {
        stringBuilder.append("OFFSET ").append(l2).append(' ');
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder stringBuilder, String string) {
    }

    @Override
    public void appendCreateTableSuffix(StringBuilder stringBuilder) {
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return true;
    }

    @Override
    public boolean isCreateTableReturnsNegative() {
        return false;
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return false;
    }

    @Override
    public boolean isNestedSavePointsSupported() {
        return true;
    }

    public String getPingStatement() {
        return "SELECT 1";
    }

    @Override
    public boolean isBatchUseTransaction() {
        return false;
    }

    @Override
    public boolean isTruncateSupported() {
        return false;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return false;
    }

    @Override
    public boolean isCreateIndexIfNotExistsSupported() {
        return this.isCreateIfNotExistsSupported();
    }

    @Override
    public boolean isSelectSequenceBeforeInsert() {
        return false;
    }

    public boolean isAllowGeneratedIdInsertSupported() {
        return true;
    }

    @Override
    public <T> DatabaseTableConfig<T> extractDatabaseTableConfig(O o2, Class<T> clazz) {
        return null;
    }

    private void appendCanBeNull(StringBuilder stringBuilder, FieldType fieldType) {
    }

    private void addSingleUnique(StringBuilder stringBuilder, FieldType fieldType, List<String> list, List<String> list2) {
        stringBuilder = new StringBuilder();
        stringBuilder.append(" UNIQUE (");
        this.appendEscapedEntityName(stringBuilder, fieldType.getColumnName());
        stringBuilder.append(")");
        list.add(stringBuilder.toString());
    }
}

