/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.math.BigDecimal;

public class BigDecimalStringType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 255;
    private static final BigDecimalStringType singleTon = new BigDecimalStringType();

    public static BigDecimalStringType getSingleton() {
        return singleTon;
    }

    private BigDecimalStringType() {
        super(SqlType.STRING, new Class[]{BigDecimal.class});
    }

    protected BigDecimalStringType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        try {
            return new BigDecimal(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LoggerFactory$1.create("Problems with field " + fieldType + " parsing default BigDecimal string '" + string + "'", illegalArgumentException);
        }
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, io io2, int n2) {
        return io2.a();
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object object, int n2) {
        try {
            return new BigDecimal((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LoggerFactory$1.create("Problems with column " + n2 + " parsing BigDecimal string '" + object + "'", illegalArgumentException);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object object) {
        return ((BigDecimal)object).toString();
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }
}

