/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDateType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.util.Date;

public class DateLongType
extends BaseDateType {
    private static final DateLongType singleTon = new DateLongType();

    public static DateLongType getSingleton() {
        return singleTon;
    }

    private DateLongType() {
        super(SqlType.LONG, new Class[0]);
    }

    protected DateLongType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw LoggerFactory$1.create("Problems with field " + fieldType + " parsing default date-long value: " + string, numberFormatException);
        }
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, io io2, int n2) {
        return io2.a();
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object object, int n2) {
        return new Date((Long)object);
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object object) {
        return ((Date)object).getTime();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String string, int n2) {
        return this.sqlArgToJava(fieldType, Long.parseLong(string), n2);
    }

    @Override
    public Class<?> getPrimaryClass() {
        return Date.class;
    }
}

