/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class DateTimeType
extends BaseDataType {
    private static final DateTimeType singleTon = new DateTimeType();
    private static Class<?> dateTimeClass = null;
    private static Method getMillisMethod = null;
    private static Constructor<?> millisConstructor = null;
    private static final String[] associatedClassNames = new String[]{"org.joda.time.DateTime"};

    private DateTimeType() {
        super(SqlType.LONG, new Class[0]);
    }

    protected DateTimeType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    public static DateTimeType getSingleton() {
        return singleTon;
    }

    @Override
    public String[] getAssociatedClassNames() {
        return associatedClassNames;
    }

    @Override
    public Object javaToSqlArg(FieldType object, Object object2) {
        try {
            object = this.getMillisMethod();
            if (object2 == null) {
                return null;
            }
            return ((Method)object).invoke(object2, new Object[0]);
        }
        catch (Exception exception) {
            throw LoggerFactory$1.create("Could not use reflection to get millis from Joda DateTime: ".concat(String.valueOf(object2)), exception);
        }
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        return Long.parseLong(string);
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, io io2, int n2) {
        return io2.a();
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object object, int n2) {
        try {
            return this.getConstructor().newInstance((Long)object);
        }
        catch (Exception exception) {
            throw LoggerFactory$1.create("Could not use reflection to construct a Joda DateTime", exception);
        }
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }

    @Override
    public Class<?> getPrimaryClass() {
        try {
            return this.getDateTimeClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Method getMillisMethod() {
        if (getMillisMethod == null) {
            getMillisMethod = this.getDateTimeClass().getMethod("getMillis", new Class[0]);
        }
        return getMillisMethod;
    }

    private Constructor<?> getConstructor() {
        if (millisConstructor == null) {
            millisConstructor = this.getDateTimeClass().getConstructor(Long.TYPE);
        }
        return millisConstructor;
    }

    private Class<?> getDateTimeClass() {
        if (dateTimeClass == null) {
            dateTimeClass = Class.forName("org.joda.time.DateTime");
        }
        return dateTimeClass;
    }
}

