/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;

public class IntegerObjectType
extends BaseDataType {
    private static final IntegerObjectType singleTon = new IntegerObjectType();

    public static IntegerObjectType getSingleton() {
        return singleTon;
    }

    private IntegerObjectType() {
        super(SqlType.INTEGER, new Class[]{Integer.class});
    }

    protected IntegerObjectType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        return Integer.parseInt(string);
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, io io2, int n2) {
        return io2.e();
    }

    @Override
    public Object convertIdNumber(Number number) {
        return number.intValue();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public boolean isValidGeneratedType() {
        return true;
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object object) {
        if (object == null) {
            return 1;
        }
        return (Integer)object + 1;
    }
}

