/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class StringBytesType
extends BaseDataType {
    private static final String DEFAULT_STRING_BYTES_CHARSET_NAME = "Unicode";
    private static final StringBytesType singleTon = new StringBytesType();

    public static StringBytesType getSingleton() {
        return singleTon;
    }

    private StringBytesType() {
        super(SqlType.BYTE_ARRAY, new Class[0]);
    }

    protected StringBytesType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        throw new SQLException("String-bytes type cannot have default values");
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, io io2, int n2) {
        return io2.a();
    }

    @Override
    public Object sqlArgToJava(FieldType object, Object object2, int n2) {
        object2 = (byte[])object2;
        object = this.getCharsetName((FieldType)object);
        try {
            return new String((byte[])object2, (String)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw LoggerFactory$1.create("Could not convert string with charset name: ".concat(String.valueOf(object)), unsupportedEncodingException);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType object, Object object2) {
        object2 = (String)object2;
        object = this.getCharsetName((FieldType)object);
        try {
            return ((String)object2).getBytes((String)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw LoggerFactory$1.create("Could not convert string with charset name: ".concat(String.valueOf(object)), unsupportedEncodingException);
        }
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }

    @Override
    public boolean isArgumentHolderRequired() {
        return true;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String string, int n2) {
        throw new SQLException("String-bytes type cannot be converted from string to Java");
    }

    @Override
    public Class<?> getPrimaryClass() {
        return String.class;
    }

    private String getCharsetName(FieldType fieldType) {
        if (fieldType == null || fieldType.getFormat() == null) {
            return DEFAULT_STRING_BYTES_CHARSET_NAME;
        }
        return fieldType.getFormat();
    }
}

