/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.misc;

import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;

public class VersionUtils {
    private static final String CORE_VERSION = "VERSION__4.48-SNAPSHOT__";
    private static Logger logger;
    private static boolean thrownOnErrors;
    private static String coreVersion;

    private VersionUtils() {
    }

    public static final void checkCoreVersusJdbcVersions(String string) {
        VersionUtils.logVersionWarnings("core", coreVersion, "jdbc", string);
    }

    public static final void checkCoreVersusAndroidVersions(String string) {
        VersionUtils.logVersionWarnings("core", coreVersion, "android", string);
    }

    public static String getCoreVersion() {
        return coreVersion;
    }

    static void setThrownOnErrors(boolean bl2) {
        thrownOnErrors = bl2;
    }

    private static void logVersionWarnings(String string, String string2, String string3, String string4) {
        if (string2 == null) {
            if (string4 != null) {
                VersionUtils.warning(null, "Unknown version", " for {}, version for {} is '{}'", new Object[]{string, string3, string4});
                return;
            }
        } else {
            if (string4 == null) {
                VersionUtils.warning(null, "Unknown version", " for {}, version for {} is '{}'", new Object[]{string3, string, string2});
                return;
            }
            if (!string2.equals(string4)) {
                VersionUtils.warning(null, "Mismatched versions", ": {} is '{}', while {} is '{}'", new Object[]{string, string2, string3, string4});
            }
        }
    }

    private static void warning(Throwable throwable, String string, String string2, Object[] objectArray) {
        VersionUtils.getLogger().warn(throwable, string + string2, objectArray);
        if (thrownOnErrors) {
            throw new IllegalStateException("See error log for details:".concat(String.valueOf(string)));
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerFactory.getLogger(VersionUtils.class);
        }
        return logger;
    }

    static {
        thrownOnErrors = false;
        coreVersion = CORE_VERSION;
    }
}

