/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.QueryBuilder$JoinInfo;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.StatementBuilder$StatementType;
import com.j256.ormlite.stmt.StatementBuilder$WhereOperation;
import com.j256.ormlite.stmt.query.OrderBy;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QueryBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private final FieldType idField;
    private FieldType[] resultFieldTypes;
    private boolean distinct;
    private boolean selectIdColumn = true;
    private List<String> selectColumnList;
    private List<String> selectRawList;
    private List<OrderBy> orderByList;
    private String orderByRaw;
    private w[] orderByArgs;
    private List<String> groupByList;
    private String groupByRaw;
    private boolean isInnerQuery;
    private boolean isCountOfQuery;
    private String having;
    private Long limit;
    private Long offset;
    private List<QueryBuilder$JoinInfo> joinList;

    public QueryBuilder(m m2, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(m2, tableInfo, dao, StatementBuilder$StatementType.SELECT);
        this.idField = tableInfo.getIdField();
    }

    void enableInnerQuery() {
        this.isInnerQuery = true;
    }

    int getSelectColumnCount() {
        if (this.isCountOfQuery) {
            return 1;
        }
        if (this.selectRawList != null && !this.selectRawList.isEmpty()) {
            return this.selectRawList.size();
        }
        if (this.selectColumnList == null) {
            return 0;
        }
        return this.selectColumnList.size();
    }

    List<String> getSelectColumns() {
        if (this.isCountOfQuery) {
            return Collections.singletonList("COUNT(*)");
        }
        if (this.selectRawList != null && !this.selectRawList.isEmpty()) {
            return this.selectRawList;
        }
        if (this.selectColumnList == null) {
            return Collections.emptyList();
        }
        return this.selectColumnList;
    }

    public B<T> prepare() {
        QueryBuilder queryBuilder = this;
        return super.prepareStatement(queryBuilder.limit);
    }

    public QueryBuilder<T, ID> selectColumns(String ... stringArray) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        for (String string : stringArray) {
            this.addSelectColumnToList(string);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectColumns(Iterable<String> object) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.addSelectColumnToList(string);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectRaw(String ... stringArray) {
        if (this.selectRawList == null) {
            this.selectRawList = new ArrayList<String>();
        }
        for (String string : stringArray) {
            this.selectRawList.add(string);
        }
        return this;
    }

    public QueryBuilder<T, ID> groupBy(String string) {
        if (this.verifyColumnName(string).isForeignCollection()) {
            throw new IllegalArgumentException("Can't groupBy foreign colletion field: ".concat(String.valueOf(string)));
        }
        if (this.groupByList == null) {
            this.groupByList = new ArrayList<String>();
        }
        this.groupByList.add(string);
        this.selectIdColumn = false;
        return this;
    }

    public QueryBuilder<T, ID> groupByRaw(String string) {
        this.groupByRaw = string;
        return this;
    }

    public QueryBuilder<T, ID> orderBy(String string, boolean bl2) {
        if (this.verifyColumnName(string).isForeignCollection()) {
            throw new IllegalArgumentException("Can't orderBy foreign colletion field: ".concat(String.valueOf(string)));
        }
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>();
        }
        this.orderByList.add(new OrderBy(string, bl2));
        return this;
    }

    public QueryBuilder<T, ID> orderByRaw(String string) {
        return this.orderByRaw(string, null);
    }

    public QueryBuilder<T, ID> orderByRaw(String string, w ... wArray) {
        this.orderByRaw = string;
        this.orderByArgs = wArray;
        return this;
    }

    public QueryBuilder<T, ID> distinct() {
        this.distinct = true;
        this.selectIdColumn = false;
        return this;
    }

    @Deprecated
    public QueryBuilder<T, ID> limit(int n2) {
        return this.limit(Long.valueOf(n2));
    }

    public QueryBuilder<T, ID> limit(Long l2) {
        this.limit = l2;
        return this;
    }

    @Deprecated
    public QueryBuilder<T, ID> offset(int n2) {
        return this.offset(Long.valueOf(n2));
    }

    public QueryBuilder<T, ID> offset(Long l2) {
        if (this.databaseType.isOffsetSqlSupported()) {
            this.offset = l2;
            return this;
        }
        throw new SQLException("Offset is not supported by this database");
    }

    public QueryBuilder<T, ID> setCountOf(boolean bl2) {
        this.isCountOfQuery = bl2;
        return this;
    }

    public QueryBuilder<T, ID> having(String string) {
        this.having = string;
        return this;
    }

    public QueryBuilder<T, ID> join(QueryBuilder<?, ?> queryBuilder) {
        this.addJoinInfo("INNER", queryBuilder, StatementBuilder$WhereOperation.AND);
        return this;
    }

    public QueryBuilder<T, ID> joinOr(QueryBuilder<?, ?> queryBuilder) {
        this.addJoinInfo("INNER", queryBuilder, StatementBuilder$WhereOperation.OR);
        return this;
    }

    public QueryBuilder<T, ID> leftJoin(QueryBuilder<?, ?> queryBuilder) {
        this.addJoinInfo("LEFT", queryBuilder, StatementBuilder$WhereOperation.AND);
        return this;
    }

    public QueryBuilder<T, ID> leftJoinOr(QueryBuilder<?, ?> queryBuilder) {
        this.addJoinInfo("LEFT", queryBuilder, StatementBuilder$WhereOperation.OR);
        return this;
    }

    public List<T> query() {
        return this.dao.query(this.prepare());
    }

    public h<String[]> queryRaw() {
        return this.dao.queryRaw(this.prepareStatementString(), new String[0]);
    }

    public T queryForFirst() {
        return this.dao.queryForFirst(this.prepare());
    }

    public String[] queryRawFirst() {
        return this.dao.queryRaw(this.prepareStatementString(), new String[0]).getFirstResult();
    }

    public e<T> iterator() {
        return this.dao.iterator(this.prepare());
    }

    public long countOf() {
        this.setCountOf(true);
        return this.dao.countOf(this.prepare());
    }

    @Override
    @Deprecated
    public void clear() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.distinct = false;
        this.selectIdColumn = true;
        this.selectColumnList = null;
        this.selectRawList = null;
        this.orderByList = null;
        this.orderByRaw = null;
        this.groupByList = null;
        this.groupByRaw = null;
        this.isInnerQuery = false;
        this.isCountOfQuery = false;
        this.having = null;
        this.limit = null;
        this.offset = null;
        if (this.joinList != null) {
            this.joinList.clear();
            this.joinList = null;
        }
        this.addTableName = false;
    }

    @Override
    protected void appendStatementStart(StringBuilder stringBuilder, List<w> list) {
        if (this.joinList == null) {
            this.setAddTableName(false);
        } else {
            this.setAddTableName(true);
        }
        stringBuilder.append("SELECT ");
        if (this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(stringBuilder);
        }
        if (this.distinct) {
            stringBuilder.append("DISTINCT ");
        }
        if (this.isCountOfQuery) {
            this.type = StatementBuilder$StatementType.SELECT_LONG;
            stringBuilder.append("COUNT(*) ");
        } else if (this.selectRawList != null && !this.selectRawList.isEmpty()) {
            this.type = StatementBuilder$StatementType.SELECT_RAW;
            this.appendSelectRaw(stringBuilder);
        } else {
            this.type = StatementBuilder$StatementType.SELECT;
            this.appendColumns(stringBuilder);
        }
        stringBuilder.append("FROM ");
        this.databaseType.appendEscapedEntityName(stringBuilder, this.tableName);
        stringBuilder.append(' ');
        if (this.joinList != null) {
            this.appendJoinSql(stringBuilder);
        }
    }

    @Override
    protected FieldType[] getResultFieldTypes() {
        return this.resultFieldTypes;
    }

    @Override
    protected boolean appendWhereStatement(StringBuilder stringBuilder, List<w> list, StatementBuilder$WhereOperation statementBuilder$WhereOperation) {
        boolean bl2;
        boolean bl3 = bl2 = statementBuilder$WhereOperation == StatementBuilder$WhereOperation.FIRST;
        if (this.where != null) {
            bl2 = super.appendWhereStatement(stringBuilder, list, statementBuilder$WhereOperation);
        }
        if (this.joinList != null) {
            for (QueryBuilder$JoinInfo queryBuilder$JoinInfo : this.joinList) {
                statementBuilder$WhereOperation = bl2 ? StatementBuilder$WhereOperation.FIRST : queryBuilder$JoinInfo.operation;
                bl2 = queryBuilder$JoinInfo.queryBuilder.appendWhereStatement(stringBuilder, list, statementBuilder$WhereOperation);
            }
        }
        return bl2;
    }

    @Override
    protected void appendStatementEnd(StringBuilder stringBuilder, List<w> list) {
        this.appendGroupBys(stringBuilder);
        this.appendHaving(stringBuilder);
        this.appendOrderBys(stringBuilder, list);
        if (!this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(stringBuilder);
        }
        this.appendOffset(stringBuilder);
        this.setAddTableName(false);
    }

    @Override
    protected boolean shouldPrependTableNameToColumns() {
        return this.joinList != null;
    }

    private void setAddTableName(boolean bl2) {
        this.addTableName = bl2;
        if (this.joinList != null) {
            Iterator<QueryBuilder$JoinInfo> iterator = this.joinList.iterator();
            while (iterator.hasNext()) {
                super.setAddTableName(bl2);
            }
        }
    }

    private void addJoinInfo(String object, QueryBuilder<?, ?> queryBuilder, StatementBuilder$WhereOperation statementBuilder$WhereOperation) {
        object = new QueryBuilder$JoinInfo(this, (String)object, queryBuilder, statementBuilder$WhereOperation);
        this.matchJoinedFields((QueryBuilder$JoinInfo)object, queryBuilder);
        if (this.joinList == null) {
            this.joinList = new ArrayList<QueryBuilder$JoinInfo>();
        }
        this.joinList.add((QueryBuilder$JoinInfo)object);
    }

    private void matchJoinedFields(QueryBuilder$JoinInfo queryBuilder$JoinInfo, QueryBuilder<?, ?> queryBuilder) {
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            FieldType fieldType2 = fieldType.getForeignIdField();
            if (!fieldType.isForeign() || !fieldType2.equals(queryBuilder.tableInfo.getIdField())) continue;
            queryBuilder$JoinInfo.localField = fieldType;
            queryBuilder$JoinInfo.remoteField = fieldType2;
            return;
        }
        for (FieldType fieldType : queryBuilder.tableInfo.getFieldTypes()) {
            if (!fieldType.isForeign() || !fieldType.getForeignIdField().equals(this.idField)) continue;
            queryBuilder$JoinInfo.localField = this.idField;
            queryBuilder$JoinInfo.remoteField = fieldType;
            return;
        }
        throw new SQLException("Could not find a foreign " + this.tableInfo.getDataClass() + " field in " + queryBuilder.tableInfo.getDataClass() + " or vice versa");
    }

    private void addSelectColumnToList(String string) {
        this.verifyColumnName(string);
        this.selectColumnList.add(string);
    }

    private void appendJoinSql(StringBuilder stringBuilder) {
        for (QueryBuilder$JoinInfo queryBuilder$JoinInfo : this.joinList) {
            stringBuilder.append(queryBuilder$JoinInfo.type).append(" JOIN ");
            this.databaseType.appendEscapedEntityName(stringBuilder, queryBuilder$JoinInfo.queryBuilder.tableName);
            stringBuilder.append(" ON ");
            this.databaseType.appendEscapedEntityName(stringBuilder, this.tableName);
            stringBuilder.append('.');
            this.databaseType.appendEscapedEntityName(stringBuilder, queryBuilder$JoinInfo.localField.getColumnName());
            stringBuilder.append(" = ");
            this.databaseType.appendEscapedEntityName(stringBuilder, queryBuilder$JoinInfo.queryBuilder.tableName);
            stringBuilder.append('.');
            this.databaseType.appendEscapedEntityName(stringBuilder, queryBuilder$JoinInfo.remoteField.getColumnName());
            stringBuilder.append(' ');
            if (queryBuilder$JoinInfo.queryBuilder.joinList == null) continue;
            super.appendJoinSql(stringBuilder);
        }
    }

    private void appendSelectRaw(StringBuilder stringBuilder) {
        boolean bl2 = true;
        for (String string : this.selectRawList) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(' ');
    }

    private void appendColumns(StringBuilder stringBuilder) {
        if (this.selectColumnList == null) {
            if (this.addTableName) {
                this.databaseType.appendEscapedEntityName(stringBuilder, this.tableName);
                stringBuilder.append('.');
            }
            stringBuilder.append("* ");
            this.resultFieldTypes = this.tableInfo.getFieldTypes();
            return;
        }
        boolean bl2 = true;
        boolean bl3 = this.isInnerQuery;
        ArrayList<FieldType> arrayList = new ArrayList<FieldType>(this.selectColumnList.size() + 1);
        for (String string : this.selectColumnList) {
            FieldType object = this.tableInfo.getFieldTypeByColumnName(string);
            if (object.isForeignCollection()) {
                arrayList.add(object);
                continue;
            }
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
            }
            this.appendFieldColumnName(stringBuilder, object, arrayList);
            if (object != this.idField) continue;
            bl3 = true;
        }
        if (!bl3 && this.selectIdColumn) {
            if (!bl2) {
                stringBuilder.append(',');
            }
            this.appendFieldColumnName(stringBuilder, this.idField, arrayList);
        }
        stringBuilder.append(' ');
        ArrayList<FieldType> arrayList2 = arrayList;
        this.resultFieldTypes = arrayList2.toArray(new FieldType[arrayList2.size()]);
    }

    private void appendFieldColumnName(StringBuilder stringBuilder, FieldType fieldType, List<FieldType> list) {
        this.appendColumnName(stringBuilder, fieldType.getColumnName());
        if (list != null) {
            list.add(fieldType);
        }
    }

    private void appendLimit(StringBuilder stringBuilder) {
        if (this.limit != null && this.databaseType.isLimitSqlSupported()) {
            this.databaseType.appendLimitValue(stringBuilder, this.limit, this.offset);
        }
    }

    private void appendOffset(StringBuilder stringBuilder) {
        if (this.offset == null) {
            return;
        }
        if (this.databaseType.isOffsetLimitArgument()) {
            if (this.limit == null) {
                throw new SQLException("If the offset is specified, limit must also be specified with this database");
            }
        } else {
            this.databaseType.appendOffsetValue(stringBuilder, this.offset);
        }
    }

    private void appendGroupBys(StringBuilder stringBuilder) {
        boolean bl2 = true;
        if (this.hasGroupStuff()) {
            this.appendGroupBys(stringBuilder, true);
            bl2 = false;
        }
        if (this.joinList != null) {
            for (QueryBuilder$JoinInfo queryBuilder$JoinInfo : this.joinList) {
                if (queryBuilder$JoinInfo.queryBuilder == null || !super.hasGroupStuff()) continue;
                super.appendGroupBys(stringBuilder, bl2);
            }
        }
    }

    private boolean hasGroupStuff() {
        return this.groupByList != null && !this.groupByList.isEmpty() || this.groupByRaw != null;
    }

    private void appendGroupBys(StringBuilder stringBuilder, boolean bl2) {
        if (bl2) {
            stringBuilder.append("GROUP BY ");
        }
        if (this.groupByRaw != null) {
            if (!bl2) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.groupByRaw);
        } else {
            for (String string : this.groupByList) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(',');
                }
                this.appendColumnName(stringBuilder, string);
            }
        }
        stringBuilder.append(' ');
    }

    private void appendOrderBys(StringBuilder stringBuilder, List<w> list) {
        boolean bl2 = true;
        if (this.hasOrderStuff()) {
            this.appendOrderBys(stringBuilder, true, list);
            bl2 = false;
        }
        if (this.joinList != null) {
            for (QueryBuilder$JoinInfo queryBuilder$JoinInfo : this.joinList) {
                if (queryBuilder$JoinInfo.queryBuilder == null || !super.hasOrderStuff()) continue;
                super.appendOrderBys(stringBuilder, bl2, list);
            }
        }
    }

    private boolean hasOrderStuff() {
        return this.orderByList != null && !this.orderByList.isEmpty() || this.orderByRaw != null;
    }

    private void appendOrderBys(StringBuilder stringBuilder, boolean n2, List<w> list) {
        if (n2 != 0) {
            stringBuilder.append("ORDER BY ");
        }
        if (this.orderByRaw != null) {
            if (n2 == 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.orderByRaw);
            if (this.orderByArgs != null) {
                w[] wArray = this.orderByArgs;
                int n3 = this.orderByArgs.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    w w2 = wArray[n2];
                    list.add(w2);
                }
            }
        } else {
            for (OrderBy orderBy : this.orderByList) {
                if (n2 != 0) {
                    n2 = 0;
                } else {
                    stringBuilder.append(',');
                }
                this.appendColumnName(stringBuilder, orderBy.getColumnName());
                if (orderBy.isAscending()) continue;
                stringBuilder.append(" DESC");
            }
        }
        stringBuilder.append(' ');
    }

    private void appendColumnName(StringBuilder stringBuilder, String string) {
        if (this.addTableName) {
            this.databaseType.appendEscapedEntityName(stringBuilder, this.tableName);
            stringBuilder.append('.');
        }
        this.databaseType.appendEscapedEntityName(stringBuilder, string);
    }

    private void appendHaving(StringBuilder stringBuilder) {
        if (this.having != null) {
            stringBuilder.append("HAVING ").append(this.having).append(' ');
        }
    }
}

