/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.StatementBuilder$StatementType;
import com.j256.ormlite.stmt.query.SetValue;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpdateBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private List<I> updateClauseList = null;

    public UpdateBuilder(m m2, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(m2, tableInfo, dao, StatementBuilder$StatementType.UPDATE);
    }

    public D<T> prepare() {
        return super.prepareStatement(null);
    }

    public StatementBuilder<T, ID> updateColumnValue(String string, Object object) {
        FieldType fieldType = this.verifyColumnName(string);
        if (fieldType.isForeignCollection()) {
            throw new SQLException("Can't update foreign colletion field: ".concat(String.valueOf(string)));
        }
        this.addUpdateColumnToList(string, new SetValue(string, fieldType, object));
        return this;
    }

    public StatementBuilder<T, ID> updateColumnExpression(String string, String string2) {
        FieldType fieldType = this.verifyColumnName(string);
        if (fieldType.isForeignCollection()) {
            throw new SQLException("Can't update foreign colletion field: ".concat(String.valueOf(string)));
        }
        this.addUpdateColumnToList(string, new N(string, fieldType, string2));
        return this;
    }

    public void escapeColumnName(StringBuilder stringBuilder, String string) {
        this.databaseType.appendEscapedEntityName(stringBuilder, string);
    }

    public String escapeColumnName(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 4);
        this.databaseType.appendEscapedEntityName(stringBuilder, string);
        return stringBuilder.toString();
    }

    public void escapeValue(StringBuilder stringBuilder, String string) {
        this.databaseType.appendEscapedWord(stringBuilder, string);
    }

    public String escapeValue(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 4);
        this.databaseType.appendEscapedWord(stringBuilder, string);
        return stringBuilder.toString();
    }

    public int update() {
        return this.dao.update(this.prepare());
    }

    @Override
    @Deprecated
    public void clear() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.updateClauseList = null;
    }

    @Override
    protected void appendStatementStart(StringBuilder stringBuilder, List<w> list) {
        if (this.updateClauseList == null || this.updateClauseList.isEmpty()) {
            throw new IllegalArgumentException("UPDATE statements must have at least one SET column");
        }
        stringBuilder.append("UPDATE ");
        this.databaseType.appendEscapedEntityName(stringBuilder, this.tableInfo.getTableName());
        stringBuilder.append(" SET ");
        boolean bl2 = true;
        for (I i2 : this.updateClauseList) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
            }
            i2.appendSql(this.databaseType, null, stringBuilder, list);
        }
    }

    @Override
    protected void appendStatementEnd(StringBuilder stringBuilder, List<w> list) {
    }

    private void addUpdateColumnToList(String string, I i2) {
        if (this.updateClauseList == null) {
            this.updateClauseList = new ArrayList<I>();
        }
        this.updateClauseList.add(i2);
    }
}

