/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Log$Level;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.stmt.mapped.MappedCreate$KeyHolder;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

public class MappedCreate<T, ID>
extends BaseMappedStatement<T, ID> {
    private final String queryNextSequenceStmt;
    private String dataClassName;
    private int versionFieldTypeIndex;

    private MappedCreate(TableInfo<T, ID> tableInfo, String string, FieldType[] fieldTypeArray, String string2, int n2) {
        super(tableInfo, string, fieldTypeArray);
        this.dataClassName = tableInfo.getDataClass().getSimpleName();
        this.queryNextSequenceStmt = string2;
        this.versionFieldTypeIndex = n2;
    }

    public int insert(m m2, DatabaseConnection databaseConnection, T t2, i i2) {
        MappedCreate$KeyHolder mappedCreate$KeyHolder = null;
        if (this.idField != null) {
            boolean bl2 = !this.idField.isAllowGeneratedIdInsert() || this.idField.isObjectsFieldValueDefault(t2);
            if (this.idField.isSelfGeneratedId() && this.idField.isGeneratedId()) {
                if (bl2) {
                    this.idField.assignField(t2, this.idField.generateId(), false, i2);
                }
            } else if (this.idField.isGeneratedIdSequence() && m2.isSelectSequenceBeforeInsert()) {
                if (bl2) {
                    this.assignSequenceId(databaseConnection, t2, i2);
                }
            } else if (this.idField.isGeneratedId() && bl2) {
                mappedCreate$KeyHolder = new MappedCreate$KeyHolder(null);
            }
        }
        try {
            int n2;
            if (this.tableInfo.isForeignAutoCreate()) {
                for (FieldType object2 : this.tableInfo.getFieldTypes()) {
                    Object FV2;
                    if (!object2.isForeignAutoCreate() || (FV2 = object2.extractRawJavaFieldValue(t2)) == null || !object2.getForeignIdField().isObjectsFieldValueDefault(FV2)) continue;
                    object2.createWithForeignDao(FV2);
                }
            }
            Object[] objectArray = this.getFieldObjects(t2);
            Object object = null;
            if (this.versionFieldTypeIndex >= 0 && objectArray[this.versionFieldTypeIndex] == null) {
                FieldType fieldType = this.argFieldTypes[this.versionFieldTypeIndex];
                object = fieldType.moveToNextValue(null);
                objectArray[this.versionFieldTypeIndex] = fieldType.convertJavaFieldToSqlArgValue(object);
            }
            try {
                n2 = databaseConnection.insert(this.statement, objectArray, this.argFieldTypes, mappedCreate$KeyHolder);
            }
            catch (SQLException sQLException) {
                logger.debug("insert data with statement '{}' and {} args, threw exception: {}", (Object)this.statement, (Object)objectArray.length, (Object)sQLException);
                if (objectArray.length > 0) {
                    logger.trace("insert arguments: {}", (Object)objectArray);
                }
                throw sQLException;
            }
            logger.debug("insert data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)objectArray.length, (Object)n2);
            if (objectArray.length > 0) {
                logger.trace("insert arguments: {}", (Object)objectArray);
            }
            if (n2 > 0) {
                if (object != null) {
                    this.argFieldTypes[this.versionFieldTypeIndex].assignField(t2, object, false, null);
                }
                if (mappedCreate$KeyHolder != null) {
                    Number number = mappedCreate$KeyHolder.getKey();
                    if (number == null) {
                        throw new SQLException("generated-id key was not set by the update call");
                    }
                    if (number.longValue() == 0L) {
                        throw new SQLException("generated-id key must not be 0 value");
                    }
                    this.assignIdValue(t2, number, "keyholder", i2);
                }
                if (i2 != null) {
                    MappedCreate mappedCreate = this;
                    if (mappedCreate.foreignCollectionsAreAssigned(mappedCreate.tableInfo.getForeignCollections(), t2)) {
                        Object object2 = this.idField.extractJavaFieldValue(t2);
                        i2.put(this.clazz, object2, t2);
                    }
                }
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Unable to run insert stmt on object " + t2 + ": " + this.statement, sQLException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T, ID> MappedCreate<T, ID> build(m m2, TableInfo<T, ID> tableInfo) {
        void object;
        StringBuilder stringBuilder = new StringBuilder(128);
        MappedCreate.appendTableName(m2, stringBuilder, "INSERT INTO ", tableInfo.getTableName());
        stringBuilder.append('(');
        int n2 = 0;
        int n3 = -1;
        FieldType[] fieldTypeArray = tableInfo.getFieldTypes();
        int n4 = fieldTypeArray.length;
        boolean bl2 = false;
        while (object < n4) {
            FieldType fieldType = fieldTypeArray[object];
            if (MappedCreate.isFieldCreatable(m2, fieldType)) {
                if (fieldType.isVersion()) {
                    n3 = n2;
                }
                ++n2;
            }
            ++object;
        }
        fieldTypeArray = new FieldType[n2];
        n2 = 0;
        n4 = 1;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!MappedCreate.isFieldCreatable(m2, fieldType)) continue;
            if (n4 != 0) {
                n4 = 0;
            } else {
                stringBuilder.append(",");
            }
            MappedCreate.appendFieldColumnName(m2, stringBuilder, fieldType, null);
            fieldTypeArray[n2++] = fieldType;
        }
        stringBuilder.append(") VALUES (");
        n4 = 1;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!MappedCreate.isFieldCreatable(m2, fieldType)) continue;
            if (n4 != 0) {
                n4 = 0;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        FieldType fieldType = tableInfo.getIdField();
        String string = MappedCreate.buildQueryNextSequence(m2, fieldType);
        return new MappedCreate<T, ID>(tableInfo, stringBuilder.toString(), fieldTypeArray, string, n3);
    }

    private boolean foreignCollectionsAreAssigned(FieldType[] fieldTypeArray, Object object) {
        int n2 = fieldTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (fieldTypeArray[i2].extractJavaFieldValue(object) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldCreatable(m m2, FieldType fieldType) {
        if (fieldType.isForeignCollection()) {
            return false;
        }
        if (fieldType.isReadOnly()) {
            return false;
        }
        if (m2.isIdSequenceNeeded() && m2.isSelectSequenceBeforeInsert()) {
            return true;
        }
        return !fieldType.isGeneratedId() || fieldType.isSelfGeneratedId() || fieldType.isAllowGeneratedIdInsert();
    }

    private static String buildQueryNextSequence(m m2, FieldType object) {
        if (object == null) {
            return null;
        }
        if ((object = ((FieldType)object).getGeneratedIdSequence()) == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        m2.appendSelectNextValFromSequence(stringBuilder, (String)object);
        return stringBuilder.toString();
    }

    private void assignSequenceId(DatabaseConnection databaseConnection, T t2, i i2) {
        long l2 = databaseConnection.queryForLong(this.queryNextSequenceStmt);
        logger.debug("queried for sequence {} using stmt: {}", l2, (Object)this.queryNextSequenceStmt);
        if (l2 == 0L) {
            throw new SQLException("Should not have returned 0 for stmt: " + this.queryNextSequenceStmt);
        }
        this.assignIdValue(t2, l2, "sequence", i2);
    }

    private void assignIdValue(T t2, Number number, String string, i i2) {
        this.idField.assignIdValue(t2, number, i2);
        if (logger.isLevelEnabled(Log$Level.DEBUG)) {
            logger.debug("assigned id '{}' from {} to '{}' in {} object", new Object[]{number, string, this.idField.getFieldName(), this.dataClassName});
        }
    }
}

