/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.support;

import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.support.DatabaseConnection;
import java.lang.reflect.Constructor;

public class ReflectionDatabaseConnectionProxyFactory {
    private final Class<? extends DatabaseConnection> proxyClass;
    private final Constructor<? extends DatabaseConnection> constructor;

    public ReflectionDatabaseConnectionProxyFactory(Class<? extends DatabaseConnection> clazz) {
        this.proxyClass = clazz;
        try {
            this.constructor = clazz.getConstructor(DatabaseConnection.class);
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find constructor with DatabaseConnection argument in ".concat(String.valueOf(clazz)));
        }
    }

    public DatabaseConnection createProxy(DatabaseConnection databaseConnection) {
        try {
            return this.constructor.newInstance(databaseConnection);
        }
        catch (Exception exception) {
            throw LoggerFactory$1.create("Could not create a new instance of " + this.proxyClass, exception);
        }
    }
}

