/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.DatabaseFieldConfigLoader;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseTableConfigLoader {
    private static final String CONFIG_FILE_START_MARKER = "# --table-start--";
    private static final String CONFIG_FILE_END_MARKER = "# --table-end--";
    private static final String CONFIG_FILE_FIELDS_START = "# --table-fields-start--";
    private static final String CONFIG_FILE_FIELDS_END = "# --table-fields-end--";
    private static final String FIELD_NAME_DATA_CLASS = "dataClass";
    private static final String FIELD_NAME_TABLE_NAME = "tableName";

    public static List<DatabaseTableConfig<?>> loadDatabaseConfigFromReader(BufferedReader bufferedReader) {
        DatabaseTableConfig databaseTableConfig;
        ArrayList arrayList = new ArrayList();
        while ((databaseTableConfig = DatabaseTableConfigLoader.fromReader(bufferedReader)) != null) {
            arrayList.add(databaseTableConfig);
        }
        return arrayList;
    }

    public static <T> DatabaseTableConfig<T> fromReader(BufferedReader bufferedReader) {
        DatabaseTableConfig databaseTableConfig = new DatabaseTableConfig();
        boolean bl2 = false;
        while (true) {
            String string;
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw LoggerFactory$1.create("Could not read DatabaseTableConfig from stream", iOException);
            }
            if (string == null || string.equals(CONFIG_FILE_END_MARKER)) break;
            if (string.equals(CONFIG_FILE_FIELDS_START)) {
                DatabaseTableConfigLoader.readFields(bufferedReader, databaseTableConfig);
                continue;
            }
            if (string.length() == 0 || string.startsWith("#") || string.equals(CONFIG_FILE_START_MARKER)) continue;
            String[] stringArray = string.split("=", -2);
            if (stringArray.length != 2) {
                throw new SQLException("DatabaseTableConfig reading from stream cannot parse line: ".concat(String.valueOf(string)));
            }
            DatabaseTableConfigLoader.readTableField(databaseTableConfig, stringArray[0], stringArray[1]);
            bl2 = true;
        }
        if (bl2) {
            return databaseTableConfig;
        }
        return null;
    }

    public static <T> void write(BufferedWriter bufferedWriter, DatabaseTableConfig<T> databaseTableConfig) {
        try {
            DatabaseTableConfigLoader.writeConfig(bufferedWriter, databaseTableConfig);
            return;
        }
        catch (IOException iOException) {
            throw LoggerFactory$1.create("Could not write config to writer", iOException);
        }
    }

    private static <T> void writeConfig(BufferedWriter bufferedWriter, DatabaseTableConfig<T> databaseTableConfig) {
        bufferedWriter.append(CONFIG_FILE_START_MARKER);
        bufferedWriter.newLine();
        if (databaseTableConfig.getDataClass() != null) {
            bufferedWriter.append(FIELD_NAME_DATA_CLASS).append('=').append(databaseTableConfig.getDataClass().getName());
            bufferedWriter.newLine();
        }
        if (databaseTableConfig.getTableName() != null) {
            bufferedWriter.append(FIELD_NAME_TABLE_NAME).append('=').append(databaseTableConfig.getTableName());
            bufferedWriter.newLine();
        }
        bufferedWriter.append(CONFIG_FILE_FIELDS_START);
        bufferedWriter.newLine();
        if (databaseTableConfig.getFieldConfigs() != null) {
            for (DatabaseFieldConfig databaseFieldConfig : databaseTableConfig.getFieldConfigs()) {
                DatabaseFieldConfigLoader.write(bufferedWriter, databaseFieldConfig, databaseTableConfig.getTableName());
            }
        }
        bufferedWriter.append(CONFIG_FILE_FIELDS_END);
        bufferedWriter.newLine();
        bufferedWriter.append(CONFIG_FILE_END_MARKER);
        bufferedWriter.newLine();
    }

    private static <T> void readTableField(DatabaseTableConfig<T> databaseTableConfig, String object, String string) {
        if (((String)object).equals(FIELD_NAME_DATA_CLASS)) {
            try {
                object = Class.forName(string);
                databaseTableConfig.setDataClass((Class<T>)object);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Unknown class specified for dataClass: ".concat(String.valueOf(string)));
            }
        }
        if (((String)object).equals(FIELD_NAME_TABLE_NAME)) {
            databaseTableConfig.setTableName(string);
        }
    }

    private static <T> void readFields(BufferedReader bufferedReader, DatabaseTableConfig<T> databaseTableConfig) {
        ArrayList<DatabaseFieldConfig> arrayList = new ArrayList<DatabaseFieldConfig>();
        while (true) {
            Object object;
            try {
                object = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw LoggerFactory$1.create("Could not read next field from config file", iOException);
            }
            if (object == null || ((String)object).equals(CONFIG_FILE_FIELDS_END) || (object = DatabaseFieldConfigLoader.fromReader(bufferedReader)) == null) break;
            arrayList.add((DatabaseFieldConfig)object);
        }
        databaseTableConfig.setFieldConfigs(arrayList);
    }
}

