/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class TableInfo<T, ID> {
    private static final FieldType[] NO_FOREIGN_COLLECTIONS = new FieldType[0];
    private final BaseDaoImpl<T, ID> baseDaoImpl;
    private final Class<T> dataClass;
    private final String tableName;
    private final FieldType[] fieldTypes;
    private final FieldType[] foreignCollections;
    private final FieldType idField;
    private final Constructor<T> constructor;
    private final boolean foreignAutoCreate;
    private Map<String, FieldType> fieldNameMap;

    public TableInfo(O o2, BaseDaoImpl<T, ID> baseDaoImpl, Class<T> clazz) {
        this(o2.a(), baseDaoImpl, DatabaseTableConfig.fromClass(o2, clazz));
    }

    public TableInfo(m object, BaseDaoImpl<T, ID> baseDaoImpl, DatabaseTableConfig<T> databaseTableConfig) {
        FieldType fieldType;
        int n2;
        this.baseDaoImpl = baseDaoImpl;
        this.dataClass = databaseTableConfig.getDataClass();
        this.tableName = databaseTableConfig.getTableName();
        this.fieldTypes = databaseTableConfig.getFieldTypes((m)object);
        object = null;
        boolean bl2 = false;
        int n3 = 0;
        FieldType[] fieldTypeArray = this.fieldTypes;
        int n4 = this.fieldTypes.length;
        for (n2 = 0; n2 < n4; ++n2) {
            fieldType = fieldTypeArray[n2];
            if (fieldType.isId() || fieldType.isGeneratedId() || fieldType.isGeneratedIdSequence()) {
                if (object != null) {
                    throw new SQLException("More than 1 idField configured for class " + this.dataClass + " (" + object + "," + fieldType + ")");
                }
                object = fieldType;
            }
            if (fieldType.isForeignAutoCreate()) {
                bl2 = true;
            }
            if (!fieldType.isForeignCollection()) continue;
            ++n3;
        }
        this.idField = object;
        this.constructor = databaseTableConfig.getConstructor();
        this.foreignAutoCreate = bl2;
        if (n3 == 0) {
            this.foreignCollections = NO_FOREIGN_COLLECTIONS;
            return;
        }
        this.foreignCollections = new FieldType[n3];
        n3 = 0;
        fieldTypeArray = this.fieldTypes;
        n4 = this.fieldTypes.length;
        for (n2 = 0; n2 < n4; ++n2) {
            fieldType = fieldTypeArray[n2];
            if (!fieldType.isForeignCollection()) continue;
            this.foreignCollections[n3] = fieldType;
            ++n3;
        }
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public FieldType getFieldTypeByColumnName(String string) {
        FieldType fieldType;
        int n2;
        int n3;
        FieldType[] fieldTypeArray;
        Object object;
        if (this.fieldNameMap == null) {
            object = new HashMap();
            fieldTypeArray = this.fieldTypes;
            n3 = this.fieldTypes.length;
            for (n2 = 0; n2 < n3; ++n2) {
                fieldType = fieldTypeArray[n2];
                object.put(fieldType.getColumnName(), fieldType);
            }
            this.fieldNameMap = object;
        }
        if ((object = this.fieldNameMap.get(string)) != null) {
            return object;
        }
        fieldTypeArray = this.fieldTypes;
        n3 = this.fieldTypes.length;
        for (n2 = 0; n2 < n3; ++n2) {
            fieldType = fieldTypeArray[n2];
            if (!fieldType.getFieldName().equals(string)) continue;
            throw new IllegalArgumentException("You should use columnName '" + fieldType.getColumnName() + "' for table " + this.tableName + " instead of fieldName '" + fieldType.getFieldName() + "'");
        }
        throw new IllegalArgumentException("Unknown column name '" + string + "' in table " + this.tableName);
    }

    public FieldType getIdField() {
        return this.idField;
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public String objectToString(T t2) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(t2.getClass().getSimpleName());
        FieldType[] fieldTypeArray = this.fieldTypes;
        int n2 = this.fieldTypes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldType fieldType = fieldTypeArray[i2];
            stringBuilder.append(' ').append(fieldType.getColumnName()).append("=");
            try {
                stringBuilder.append(fieldType.extractJavaFieldValue(t2));
                continue;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not generate toString of field ".concat(String.valueOf(fieldType)), exception);
            }
        }
        return stringBuilder.toString();
    }

    public T createObject() {
        try {
            R<T> r2 = null;
            if (this.baseDaoImpl != null) {
                r2 = this.baseDaoImpl.getObjectFactory();
            }
            if (r2 == null) {
                r2 = this.constructor.newInstance(new Object[0]);
            } else {
                this.baseDaoImpl.getDataClass();
                r2 = r2.a();
            }
            TableInfo.wireNewInstance(this.baseDaoImpl, r2);
            return (T)r2;
        }
        catch (Exception exception) {
            throw LoggerFactory$1.create("Could not create object for " + this.constructor.getDeclaringClass(), exception);
        }
    }

    public boolean isUpdatable() {
        return this.idField != null && this.fieldTypes.length > 1;
    }

    public boolean isForeignAutoCreate() {
        return this.foreignAutoCreate;
    }

    public FieldType[] getForeignCollections() {
        return this.foreignCollections;
    }

    public boolean hasColumnName(String string) {
        FieldType[] fieldTypeArray = this.fieldTypes;
        int n2 = this.fieldTypes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!fieldTypeArray[i2].getColumnName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static <T, ID> void wireNewInstance(BaseDaoImpl<T, ID> baseDaoImpl, T t2) {
        if (t2 instanceof BaseDaoEnabled) {
            ((BaseDaoEnabled)t2).setDao(baseDaoImpl);
        }
    }
}

