/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard;

import de.t68.utils.keyboard.KeyboardKey;
import de.t68.utils.keyboard.SpecialKey;
import java.io.InputStream;
import java.util.AbstractSequentialList;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class KeyboardLayout
extends LinkedList<LinkedList<LinkedList<KeyboardKey>>> {
    public static final String ATTR_CODE = "code";
    public static final String ELEMENT_COUNTRY = "Country";
    public static final String ELEMENT_COUNTRIES = "Countries";
    public static final String XML_ROOT = "KeyboardConfiguration";
    public static final String Element_LanguageInfo = "LanguageInfo";
    public static final String Attr_Name = "Name";
    public static final String Attr_NativeName = "NativeName";
    public static final String Attr_Font = "Font";
    public static final String Attr_FixedWidthFont = "FixedWidthFont";
    public static final String Attr_LocaleString = "LocaleString";
    public static final String Element_Keyboard = "Keyboard";
    public static final String Element_Line = "Line";
    public static final String Show = "Show";
    public static final String in = "Input";
    public static final String IME = "ImeMode";
    public static final String length = "length";
    protected String name;
    protected String nativeName;
    protected String fontName;
    protected String fixedWidthFontName;
    protected List<String> localeString = new LinkedList<String>();
    protected int currentKeyboard = 0;
    protected List<String> imeList = null;
    protected List<String> keyboardID = null;
    protected List<String> org = null;
    protected List<String> trans = null;

    public KeyboardLayout(InputStream inputStream) {
        inputStream = new SAXBuilder().build(inputStream);
        this.loadData(inputStream.getRootElement());
    }

    protected KeyboardLayout() {
    }

    protected void loadData(Element object) {
        if (object == null) {
            throw new IllegalArgumentException("cannot load data, data ist null");
        }
        object = object.getChild(Element_LanguageInfo);
        this.name = object.getAttributeValue(Attr_Name);
        this.nativeName = object.getAttributeValue(Attr_Name);
        this.fontName = object.getAttributeValue(Attr_Font);
        this.fixedWidthFontName = object.getAttributeValue(Attr_FixedWidthFont);
        this.localeString.add(object.getAttributeValue(Attr_LocaleString));
        Object object22 = object.getChild(ELEMENT_COUNTRIES);
        if (object22 != null) {
            object22 = object22.getChildren(ELEMENT_COUNTRY);
            String[] stringArray = this.localeString.get(0).split("-");
            if (object22 != null && !object22.isEmpty() && stringArray != null && stringArray.length > 0) {
                object22 = object22.iterator();
                while (object22.hasNext()) {
                    Object object3 = (Element)object22.next();
                    this.localeString.add((String)stringArray[0] + "-" + object3.getAttributeValue(ATTR_CODE));
                }
            }
        }
        this.org = new LinkedList<String>();
        this.trans = new LinkedList<String>();
        object22 = object.getChild(Show);
        if (object22 != null) {
            for (Object object22 : object22.getChildren(in)) {
                this.org.add(object22.getAttribute("org").getValue());
                this.trans.add(object22.getAttribute("translate").getValue());
            }
        }
        this.imeList = new LinkedList<String>();
        for (Object object22 : object.getChildren(IME)) {
            if (object22 == null) continue;
            this.imeList.add(object22.getAttributeValue(IME));
        }
        int n2 = 0;
        this.keyboardID = new LinkedList<String>();
        this.currentKeyboard = -1;
        for (Object object3 : object.getChildren(Element_Keyboard)) {
            object = null;
            if (object3.getAttribute("ID") != null) {
                object = object3.getAttribute("ID").getValue();
                this.keyboardID.add((String)object);
            }
            ++this.currentKeyboard;
            this.add(new LinkedList());
            object3 = object3.getChildren(Element_Line).iterator();
            while (object3.hasNext()) {
                Element element = (Element)object3.next();
                LinkedList<KeyboardKey> linkedList = new LinkedList<KeyboardKey>();
                KeyboardLayout keyboardLayout = this;
                ((LinkedList)keyboardLayout.get(keyboardLayout.currentKeyboard)).add(linkedList);
                for (Element element2 : element.getChildren("Key")) {
                    String string = element2.getAttributeValue("special");
                    if (string == null || string.length() == 0) {
                        linkedList.add(new KeyboardKey(this.fontName, element2));
                        continue;
                    }
                    SpecialKey specialKey = (SpecialKey)SpecialKey.getKeyboardKey(this.fontName, string);
                    if (specialKey != null) {
                        if (specialKey.a == "IME" && object != null) {
                            specialKey.a = this.imeList.get(n2);
                            n2 = n2 < this.imeList.size() - 1 ? ++n2 : 0;
                        }
                        for (int i2 = 0; i2 < this.org.size(); ++i2) {
                            if (!string.equals(this.org.get(i2))) continue;
                            specialKey.a = this.trans.get(i2);
                            i2 = this.org.size();
                        }
                        Attribute attribute = element2.getAttribute(length);
                        if (attribute != null) {
                            specialKey.keyWidth = Integer.parseInt(attribute.getValue());
                        }
                        linkedList.add(specialKey);
                        continue;
                    }
                    linkedList.add(SpecialKey.getKeyboardKey(this.fontName, string));
                }
            }
        }
        this.currentKeyboard = 0;
    }

    @Override
    public String toString() {
        return this.nativeName + " - " + this.name;
    }

    public List<String> getLocaleString() {
        return this.localeString;
    }

    public Element getAsElement() {
        Object object2;
        int n2;
        Element element;
        Element element2 = new Element(XML_ROOT);
        Element element3 = new Element(Element_LanguageInfo);
        element2.addContent((Content)element3);
        element3.setAttribute(Attr_Name, this.name);
        element3.setAttribute(Attr_NativeName, this.nativeName);
        element3.setAttribute(Attr_Font, this.fontName);
        element3.setAttribute(Attr_FixedWidthFont, this.fixedWidthFontName);
        element3.setAttribute(Attr_LocaleString, this.localeString.isEmpty() ? "international" : this.localeString.get(0));
        if (this.localeString.size() > 1) {
            element = new Element(ELEMENT_COUNTRIES);
            for (n2 = 1; n2 < this.localeString.size(); ++n2) {
                String[] stringArray = this.localeString.get(n2).split("-");
                if (stringArray == null || stringArray.length != 2) continue;
                object2 = new Element(ELEMENT_COUNTRY);
                object2.setAttribute(ATTR_CODE, stringArray[1]);
                element.addContent((Content)object2);
            }
            if (element.getChildren().isEmpty()) {
                element3.addContent((Content)element);
            }
        }
        if (this.org.size() > 0) {
            Element element4 = new Element(Show);
            element3.setContent((Content)element4);
            for (int i2 = 0; i2 < this.org.size(); ++i2) {
                object2 = new Element(in);
                element4.addContent((Content)object2);
                object2.setAttribute(new Attribute("org", this.org.get(i2)));
                object2.setAttribute(new Attribute("translate", this.trans.get(i2)));
            }
        }
        if (this.imeList.size() > 0) {
            for (n2 = 0; n2 < this.imeList.size(); ++n2) {
                Element element5 = new Element(IME);
                element5.setAttribute(new Attribute(IME, this.imeList.get(n2)));
                element3.addContent((Content)element5);
            }
        }
        for (n2 = 0; n2 < this.size(); ++n2) {
            element = new Element(Element_Keyboard);
            element3.addContent((Content)element);
            for (Object object2 : (LinkedList)this.get(n2)) {
                Element element6 = new Element(Element_Line);
                element.addContent((Content)element6);
                object2 = ((AbstractSequentialList)object2).iterator();
                while (object2.hasNext()) {
                    KeyboardKey keyboardKey = (KeyboardKey)object2.next();
                    element6.addContent((Content)keyboardKey.getAsElement());
                }
            }
        }
        return element2;
    }

    public int getNumberByKeyboardID(String string) {
        for (int i2 = 0; i2 < this.keyboardID.size(); ++i2) {
            if (!this.keyboardID.get(i2).endsWith(string)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public Object clone() {
        KeyboardLayout keyboardLayout = (KeyboardLayout)super.clone();
        ((KeyboardLayout)super.clone()).imeList = new LinkedList<String>();
        keyboardLayout.keyboardID = new LinkedList<String>();
        keyboardLayout.org = new LinkedList<String>();
        keyboardLayout.trans = new LinkedList<String>();
        for (String string : this.imeList) {
            keyboardLayout.imeList.add(new String(string));
        }
        for (String string : this.keyboardID) {
            keyboardLayout.keyboardID.add(new String(string));
        }
        for (String string : this.org) {
            keyboardLayout.org.add(new String(string));
        }
        for (String string : this.trans) {
            keyboardLayout.trans.add(new String(string));
        }
        return keyboardLayout;
    }
}

