/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard;

import de.t68.utils.keyboard.KeyboardKey;
import de.t68.utils.keyboard.KeyboardLayout;
import de.t68.utils.keyboard.KeyboardModifier;
import de.t68.utils.keyboard.LanguageMap;
import de.t68.utils.keyboard.SpecialKey;
import de.t68.utils.keyboard.VKeyboard$KeyboardKeyAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class VKeyboard
extends JPanel {
    KeyboardModifier modifier = KeyboardModifier.normal;
    protected boolean capsLock = false;
    KeyboardLayout keyboardLayout;
    protected int keyFontSize = 18;
    JPanel keyPanel = new JPanel();
    JTextComponent textField = new JTextField(40);
    ButtonGroup group = null;
    private ButtonModel shiftModel = null;
    private ButtonModel altModel;
    private ButtonModel altgrModel;
    public static boolean focusNextComponentAtEnter = true;

    public void setTextField(JTextField jTextField) {
        this.textField = jTextField;
    }

    public JPanel getKeyPanel() {
        return this.keyPanel;
    }

    public VKeyboard(BorderLayout borderLayout) {
        super(borderLayout);
    }

    public VKeyboard(KeyboardLayout keyboardLayout) {
        this(keyboardLayout, 18);
    }

    public VKeyboard(KeyboardLayout keyboardLayout, int n2) {
        super(new BorderLayout());
        this.keyFontSize = n2;
        this.textField.setFont(this.getFont().deriveFont(24.0f));
        VKeyboard vKeyboard = this;
        vKeyboard.add((Component)vKeyboard.keyPanel, "Center");
        this.setKeyboardLayout(keyboardLayout);
    }

    public VKeyboard(KeyboardLayout keyboardLayout, int n2, JTextComponent jTextComponent) {
        this(keyboardLayout, n2);
        VKeyboard vKeyboard = this;
        vKeyboard.remove(vKeyboard.textField);
        this.textField = jTextComponent;
    }

    public VKeyboard(KeyboardLayout keyboardLayout, JTextComponent jTextComponent) {
        this(keyboardLayout, 18, jTextComponent);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setKeyboardLayout(KeyboardLayout keyboardLayout) {
        this.keyboardLayout = keyboardLayout;
        this.applyCurrentKeyboardLayout();
    }

    public void switchOffModifier() {
        if (this.shiftModel != null) {
            this.shiftModel.setSelected(false);
        }
        if (this.altModel != null) {
            this.altModel.setSelected(false);
        }
        if (this.altgrModel != null) {
            this.altgrModel.setSelected(false);
        }
    }

    public void applyCurrentKeyboardLayout() {
        AbstractButton abstractButton;
        this.keyPanel.removeAll();
        this.keyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        for (Object object : (LinkedList)this.keyboardLayout.get(this.keyboardLayout.currentKeyboard)) {
            gridBagConstraints.gridx = 0;
            Iterator iterator = ((AbstractSequentialList)object).iterator();
            while (iterator.hasNext()) {
                object = (KeyboardKey)iterator.next();
                gridBagConstraints.gridwidth = ((KeyboardKey)object).getKeyWidth();
                ((KeyboardKey)object).setKeyFontSize(this.keyFontSize);
                abstractButton = ((KeyboardKey)object).getComponent(new VKeyboard$KeyboardKeyAdapter(this, (KeyboardKey)object), this);
                if (abstractButton.getText() != "" && this.keyboardLayout.getNumberByKeyboardID(abstractButton.getText()) >= 0) {
                    this.addButtonToGroup(abstractButton);
                }
                abstractButton.setFocusable(false);
                this.keyPanel.add((Component)abstractButton, gridBagConstraints);
                gridBagConstraints.gridx += ((KeyboardKey)object).getKeyWidth();
            }
            ++gridBagConstraints.gridy;
        }
        this.setModifier(KeyboardModifier.normal);
        if (this.keyboardLayout.keyboardID.size() > 0) {
            Component[] componentArray = this.keyPanel.getComponents();
            int n2 = componentArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                abstractButton = (AbstractButton)componentArray[i2];
                if (abstractButton == null || !abstractButton.getText().equals(this.keyboardLayout.keyboardID.get(this.keyboardLayout.currentKeyboard))) continue;
                abstractButton.setSelected(true);
            }
        }
        this.keyPanel.revalidate();
        this.keyPanel.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public void cleanUp() {
        Iterator iterator = ((LinkedList)this.keyboardLayout.get(this.keyboardLayout.currentKeyboard)).iterator();
        while (iterator.hasNext()) {
            for (KeyboardKey keyboardKey : (LinkedList)iterator.next()) {
                void var6_18;
                void var5_17;
                void var4_9;
                void var7_30;
                void var6_20;
                if (keyboardKey.keyboardButton == null) continue;
                KeyListener[] keyListenerArray = keyboardKey.keyboardButton.getKeyListeners();
                int n2 = keyListenerArray.length;
                boolean bl2 = false;
                while (var6_20 < n2) {
                    KeyListener keyListener = keyListenerArray[var6_20];
                    keyboardKey.keyboardButton.removeKeyListener(keyListener);
                    ++var6_20;
                }
                ActionListener[] actionListenerArray = keyboardKey.keyboardButton.getActionListeners();
                int n3 = actionListenerArray.length;
                boolean bl3 = false;
                while (var7_30 < n3) {
                    ActionListener actionListener = actionListenerArray[var7_30];
                    keyboardKey.keyboardButton.removeActionListener(actionListener);
                    ++var7_30;
                }
                ItemListener[] itemListenerArray = keyboardKey.keyboardButton.getItemListeners();
                int n4 = itemListenerArray.length;
                boolean bl4 = false;
                while (var4_9 < n4) {
                    ItemListener itemListener = itemListenerArray[var4_9];
                    keyboardKey.keyboardButton.removeItemListener(itemListener);
                    ++var4_9;
                }
                ChangeListener[] changeListenerArray = keyboardKey.keyboardButton.getChangeListeners();
                int n5 = changeListenerArray.length;
                boolean bl5 = false;
                while (var5_17 < n5) {
                    ChangeListener changeListener = changeListenerArray[var5_17];
                    keyboardKey.keyboardButton.removeChangeListener(changeListener);
                    ++var5_17;
                }
                ComponentListener[] object3 = keyboardKey.keyboardButton.getComponentListeners();
                int n6 = object3.length;
                boolean bl6 = false;
                while (var6_18 < n6) {
                    ComponentListener componentListener = object3[var6_18];
                    keyboardKey.keyboardButton.removeComponentListener(componentListener);
                    ++var6_18;
                }
                keyboardKey.keyboardButton = null;
            }
        }
    }

    public static void main(String[] object) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = new JFrame("Keyboard-Test");
        LanguageMap languageMap = LanguageMap.getInstance();
        VKeyboard vKeyboard = new VKeyboard(languageMap.getKeyboardLayoutForLocale("ja", "JP"), 18);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)vKeyboard, "Center");
        JComboBox jComboBox = new JComboBox(new Vector(languageMap.values()));
        jComboBox.setSelectedItem(languageMap.getKeyboardLayoutForCurrentLocale());
        jComboBox.addActionListener(new U(vKeyboard, jComboBox, (JFrame)object));
        jPanel.add(jComboBox, "South");
        ((JFrame)object).setDefaultCloseOperation(3);
        ((JFrame)object).getContentPane().add(jPanel);
        ((Window)object).pack();
        ((Window)object).setLocationByPlatform(true);
        ((Window)object).setVisible(true);
    }

    public void addButtonToGroup(AbstractButton abstractButton) {
        if (this.group == null) {
            this.group = new ButtonGroup();
            this.group.add(abstractButton);
            abstractButton.setSelected(true);
            return;
        }
        this.group.add(abstractButton);
    }

    public KeyboardModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(KeyboardModifier keyboardModifier) {
        if (this.modifier.equals((Object)keyboardModifier)) {
            return;
        }
        this.modifier = keyboardModifier;
        Iterator iterator = ((LinkedList)this.keyboardLayout.get(this.keyboardLayout.currentKeyboard)).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((LinkedList)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                ((KeyboardKey)iterator2.next()).setKeyboardModifier(keyboardModifier);
            }
        }
    }

    public boolean isCapsLock() {
        return this.capsLock;
    }

    public void setCapsLock(boolean bl2) {
        this.capsLock = bl2;
        VKeyboard vKeyboard = this;
        vKeyboard.setModifier(vKeyboard.isCapsLock() ? KeyboardModifier.shift : KeyboardModifier.normal);
    }

    public int getKeyFontSize() {
        return this.keyFontSize;
    }

    public void setKeyFontSize(int n2) {
        this.keyFontSize = n2;
    }

    public ButtonModel getShiftModel() {
        return this.shiftModel;
    }

    public void setShiftModel(ButtonModel buttonModel) {
        this.shiftModel = buttonModel;
    }

    public ButtonModel getAltModel() {
        return this.altModel;
    }

    public void setAltModel(ButtonModel buttonModel) {
        this.altModel = buttonModel;
    }

    public ButtonModel getAltgrModel() {
        return this.altgrModel;
    }

    public void setAltgrModel(ButtonModel buttonModel) {
        this.altgrModel = buttonModel;
    }

    public void selectKeyboardLayout(SpecialKey specialKey) {
        int n2 = this.keyboardLayout.getNumberByKeyboardID(specialKey.a);
        if (this.keyboardLayout.currentKeyboard != n2) {
            this.keyboardLayout.currentKeyboard = n2;
            this.applyCurrentKeyboardLayout();
        }
    }

    public boolean isFocusNextComponentAtEnter() {
        return focusNextComponentAtEnter;
    }

    public void setFocusNextComponentAtEnter(boolean bl2) {
        focusNextComponentAtEnter = bl2;
    }
}

