/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public abstract class SpecialKeyIcon
extends ImageIcon {
    protected int width;
    protected int height;
    protected BufferedImage image;

    public SpecialKeyIcon() {
    }

    public SpecialKeyIcon(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    @Override
    public Image getImage() {
        if (this.image == null) {
            BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 3);
            this.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        }
        return this.image;
    }

    protected abstract void paint(Graphics2D var1);

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public final synchronized void paintIcon(Component object, Graphics graphics, int n2, int n3) {
        if (this.image == null) {
            this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            object = this.image.createGraphics();
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)object).scale(this.calcScaleX(), this.calcScaleY());
            this.paint((Graphics2D)object);
            ((Graphics)object).dispose();
        }
        if (graphics != null) {
            graphics.drawImage(this.image, n2, n3, null);
        }
    }

    protected double calcScaleX() {
        double d2 = (double)this.width / (double)this.getOrigWidth();
        double d3 = (double)this.height / (double)this.getOrigHeight();
        return Math.min(d2, d3);
    }

    protected double calcScaleY() {
        double d2 = (double)this.width / (double)this.getOrigWidth();
        double d3 = (double)this.height / (double)this.getOrigHeight();
        return Math.min(d2, d3);
    }

    public int getOrigWidth() {
        return 32;
    }

    public int getOrigHeight() {
        return 32;
    }

    public int getOrigX() {
        return 0;
    }

    public int getOrigY() {
        return 0;
    }
}

