/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;

public class EventTest {
    protected JScrollPane eventLogPane = null;
    protected JTextPane eventLogTexts = null;
    protected JTextField textField = null;
    protected DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss-SSS");

    public static void main(String[] stringArray) {
        new EventTest().start();
    }

    private void start() {
        JFrame jFrame = new JFrame("EventTest frame");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this.getTextField(), "North");
        jFrame.getContentPane().add((Component)this.getEventLogPane(), "Center");
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    public JComponent getEventLogPane() {
        if (this.eventLogPane == null) {
            this.eventLogPane = new JScrollPane(this.getEventLogTexts());
        }
        return this.eventLogPane;
    }

    public JTextPane getEventLogTexts() {
        if (this.eventLogTexts == null) {
            this.eventLogTexts = new JTextPane();
            this.eventLogTexts.setPreferredSize(new Dimension(400, 250));
        }
        return this.eventLogTexts;
    }

    public JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField(40);
            this.textField.addKeyListener(new ac(this));
        }
        return this.textField;
    }

    protected String timeStamp() {
        return this.dateFormat.format(new Date());
    }

    public void showText(String string) {
        try {
            int n2 = this.getEventLogTexts().getDocument().getEndPosition().getOffset();
            this.getEventLogTexts().getDocument().insertString(n2, "\n" + this.timeStamp() + string, null);
            return;
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
            return;
        }
    }
}

