/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.filetransfer;

import eu.memshare.export.main.MemshareClient;
import eu.memshare.export.utils.Utils;
import eu.memshare.filetransfer.FileTransferJob;
import eu.memshare.filetransfer.FileTransferJob$CommandType;
import eu.memshare.filetransfer.FileTransferStatusListener$Messages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FileTransferClient
implements Runnable {
    private static FileTransferClient instance = null;
    private String ipServer;
    private int port = 33332;
    private int maxTimeout = 30000;
    private Vector<FileTransferJob> jobs = new Vector();
    private ExecutorService executor = Executors.newCachedThreadPool();

    private FileTransferClient() {
        this.ipServer = MemshareClient.getIpServer();
        Thread thread = new Thread(this);
        thread.setName("FileTransferClient");
        thread.start();
    }

    public static synchronized FileTransferClient getInstance() {
        if (instance == null) {
            instance = new FileTransferClient();
        }
        return instance;
    }

    public synchronized void addJob(FileTransferJob fileTransferJob) {
        this.jobs.add(fileTransferJob);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.jobs.size() > 0) {
                        FileTransferJob fileTransferJob = this.jobs.remove(0);
                        switch (fileTransferJob.a) {
                            case UPLOAD_TO_SERVER: {
                                this.executor.submit(new ah(this, fileTransferJob));
                                break;
                            }
                            case DOWNLOAD_FROM_SERVER: {
                                this.executor.submit(new ai(this, fileTransferJob));
                            }
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void downloadFromServer(FileTransferJob fileTransferJob) {
        Socket socket = new Socket(this.ipServer, this.port);
        socket.setSoLinger(false, 0);
        socket.setSoTimeout(this.maxTimeout);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        objectOutputStream.writeObject((Object)FileTransferJob$CommandType.DOWNLOAD_FROM_SERVER);
        objectOutputStream.writeObject(fileTransferJob.b);
        objectOutputStream.writeObject(fileTransferJob.c);
        objectOutputStream.flush();
        FileOutputStream fileOutputStream = new FileOutputStream(fileTransferJob.a);
        byte[] byArray = new byte[524288];
        long l2 = 0L;
        FileTransferStatusListener$Messages fileTransferStatusListener$Messages = null;
        long l3 = objectInputStream.readLong();
        if (l3 > 0L) {
            boolean bl2 = false;
            while (l2 < l3) {
                try {
                    int n2 = objectInputStream.read(byArray, 0, 524288);
                    if (n2 <= 0) break;
                    fileOutputStream.write(byArray, 0, n2);
                    fileOutputStream.flush();
                    objectOutputStream.writeObject(l2 += (long)n2);
                    objectOutputStream.flush();
                    fileTransferJob.a.bytesReceived(l2, l3);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    fileTransferStatusListener$Messages = FileTransferStatusListener$Messages.Timeout;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                fileTransferJob.a.completed();
            }
        } else {
            fileTransferJob.a.error(FileTransferStatusListener$Messages.FileNotFound.toString());
        }
        if (fileTransferStatusListener$Messages == null) {
            fileTransferStatusListener$Messages = !Utils.getSha1Checksum(new File(fileTransferJob.a)).equals(fileTransferJob.c) ? FileTransferStatusListener$Messages.Checksum_differs : FileTransferStatusListener$Messages.Transfer_completed;
        }
        objectOutputStream.writeObject((Object)fileTransferStatusListener$Messages);
        objectOutputStream.flush();
        fileOutputStream.close();
        objectOutputStream.close();
        objectInputStream.close();
        socket.close();
    }

    private void uploadFileToServer(FileTransferJob fileTransferJob) {
        Object object = new File(fileTransferJob.a);
        Socket socket = new Socket(this.ipServer, this.port);
        socket.setSoLinger(false, 0);
        socket.setSoTimeout(this.maxTimeout);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        Object object2 = Utils.getSha1Checksum((File)object);
        objectOutputStream.writeObject((Object)FileTransferJob$CommandType.UPLOAD_TO_SERVER);
        objectOutputStream.writeObject(fileTransferJob.b);
        objectOutputStream.writeObject(object2);
        objectOutputStream.writeLong(((File)object).length());
        objectOutputStream.flush();
        object2 = new BufferedInputStream(new FileInputStream((File)object));
        Object object3 = new byte[0x100000];
        Object object4 = new LinkedList<Object>();
        object3 = new aj((BufferedInputStream)object2, (byte[])object3, objectOutputStream);
        object4.add(object3);
        object = new ak(this, objectInputStream, fileTransferJob, (File)object);
        object4.add(object);
        try {
            object = this.executor.invokeAll(object4);
            object3 = null;
            object = object.iterator();
            while (object.hasNext()) {
                object4 = (Future)object.next();
                if (object4 == null) continue;
                try {
                    object3 = (FileTransferStatusListener$Messages)((Object)object4.get());
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
            if (object3 != null) {
                switch (al.b[object3.ordinal()]) {
                    case 1: {
                        fileTransferJob.a.completed();
                        break;
                    }
                    default: {
                        fileTransferJob.a.error(object3.toString());
                        break;
                    }
                }
            } else {
                fileTransferJob.a.interrupted();
            }
        }
        catch (InterruptedException interruptedException) {
            fileTransferJob.a.interrupted();
        }
        ((BufferedInputStream)object2).close();
        objectOutputStream.close();
        objectInputStream.close();
        socket.close();
    }

    private Object getBytesTransmitted(ObjectInputStream objectInputStream) {
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            socketTimeoutException.printStackTrace();
        }
        return object;
    }

    public static /* synthetic */ void a(FileTransferClient fileTransferClient, FileTransferJob fileTransferJob) {
        fileTransferClient.uploadFileToServer(fileTransferJob);
    }

    public static /* synthetic */ void b(FileTransferClient fileTransferClient, FileTransferJob fileTransferJob) {
        fileTransferClient.downloadFromServer(fileTransferJob);
    }

    public static /* synthetic */ Object a(FileTransferClient fileTransferClient, ObjectInputStream objectInputStream) {
        return fileTransferClient.getBytesTransmitted(objectInputStream);
    }
}

