/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.asteriskjava.config.Category;
import org.asteriskjava.config.ConfigElement;
import org.asteriskjava.config.ConfigFile;
import org.asteriskjava.config.ConfigVariable;

public class ConfigFileImpl
implements ConfigFile {
    private final String filename;
    protected final Map<String, Category> categories;

    public ConfigFileImpl(String string, Map<String, Category> map) {
        this.filename = string;
        this.categories = map;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getCategories() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        Map<String, Category> map = this.categories;
        synchronized (map) {
            for (Category category : this.categories.values()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ConfigElement configElement : category.getElements()) {
                    if (!(configElement instanceof ConfigVariable)) continue;
                    configElement = (ConfigVariable)configElement;
                    arrayList.add(((ConfigVariable)configElement).getName() + "=" + ((ConfigVariable)configElement).getValue());
                }
                treeMap.put(category.getName(), arrayList);
            }
        }
        return treeMap;
    }

    @Override
    public String getValue(String iterator, String string) {
        if ((iterator = this.getCategory((String)((Object)iterator))) == null) {
            return null;
        }
        for (ConfigElement configElement : ((Category)((Object)iterator)).getElements()) {
            if (!(configElement instanceof ConfigVariable) || !((ConfigVariable)(configElement = (ConfigVariable)configElement)).getName().equals(string)) continue;
            return ((ConfigVariable)configElement).getValue();
        }
        return null;
    }

    @Override
    public List<String> getValues(String iterator, String string) {
        iterator = this.getCategory((String)((Object)iterator));
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iterator == null) {
            return arrayList;
        }
        for (ConfigElement configElement : ((Category)((Object)iterator)).getElements()) {
            if (!(configElement instanceof ConfigVariable) || !((ConfigVariable)(configElement = (ConfigVariable)configElement)).getName().equals(string)) continue;
            arrayList.add(((ConfigVariable)configElement).getValue());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Category getCategory(String string) {
        Map<String, Category> map = this.categories;
        synchronized (map) {
            return this.categories.get(string);
        }
    }
}

