/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.asteriskjava.fastagi.SpeechRecognitionResult$SpeechResult;
import org.asteriskjava.fastagi.reply.AgiReply;

public class SpeechRecognitionResult
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final AgiReply agiReply;

    public SpeechRecognitionResult(AgiReply agiReply) {
        this.agiReply = agiReply;
    }

    public boolean isDtmf() {
        return "digit".equals(this.agiReply.getExtra());
    }

    public boolean isSpeech() {
        return "speech".equals(this.agiReply.getExtra());
    }

    public boolean isTimeout() {
        return "timeout".equals(this.agiReply.getExtra());
    }

    public char getDigit() {
        String string = this.agiReply.getAttribute("digit");
        if (string == null || string.length() == 0) {
            return '\u0000';
        }
        return string.charAt(0);
    }

    public int getEndpos() {
        return Integer.valueOf(this.agiReply.getAttribute("endpos"));
    }

    public int getScore() {
        String string = this.agiReply.getAttribute("score0");
        if (string == null) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public String getText() {
        return this.agiReply.getAttribute("text0");
    }

    public String getGrammar() {
        return this.agiReply.getAttribute("grammar0");
    }

    public int getNumberOfResults() {
        String string = this.agiReply.getAttribute("results");
        if (string == null) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    public List<SpeechRecognitionResult$SpeechResult> getAllResults() {
        int n2 = this.getNumberOfResults();
        ArrayList<SpeechRecognitionResult$SpeechResult> arrayList = new ArrayList<SpeechRecognitionResult$SpeechResult>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            SpeechRecognitionResult$SpeechResult speechRecognitionResult$SpeechResult = new SpeechRecognitionResult$SpeechResult(Integer.valueOf(this.agiReply.getAttribute("score".concat(String.valueOf(i2)))), this.agiReply.getAttribute("text".concat(String.valueOf(i2))), this.agiReply.getAttribute("grammar".concat(String.valueOf(i2))), null);
            arrayList.add(speechRecognitionResult$SpeechResult);
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SpeechRecognitionResult[");
        if (this.isDtmf()) {
            stringBuilder.append("dtmf=true,");
            stringBuilder.append("digit=").append(this.getDigit()).append(",");
        }
        if (this.isSpeech()) {
            stringBuilder.append("speech=true,");
            stringBuilder.append("score=").append(this.getScore()).append(",");
            stringBuilder.append("text='").append(this.getText()).append("',");
            stringBuilder.append("grammar='").append(this.getGrammar()).append("',");
        }
        if (this.isTimeout()) {
            stringBuilder.append("timeout=true,");
        }
        if (this.getNumberOfResults() > 1) {
            stringBuilder.append("numberOfResults=").append(this.getNumberOfResults()).append(",");
            stringBuilder.append("allResults=").append(this.getAllResults()).append(",");
        }
        stringBuilder.append("endpos=").append(this.getEndpos()).append("]");
        return stringBuilder.toString();
    }
}

