/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.NamedAgiScript;
import org.asteriskjava.fastagi.command.VerboseCommand;
import org.asteriskjava.fastagi.internal.AgiChannelFactory;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AgiConnectionHandler
implements Runnable {
    private static final String AJ_AGISTATUS_VARIABLE = "AJ_AGISTATUS";
    private static final String AJ_AGISTATUS_NOT_FOUND = "NOT_FOUND";
    private static final String AJ_AGISTATUS_SUCCESS = "SUCCESS";
    private static final String AJ_AGISTATUS_FAILED = "FAILED";
    private static final ThreadLocal<AgiChannel> channel = new ThreadLocal();
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean ignoreMissingScripts = false;
    private AgiScript script = null;
    private AgiChannelFactory agiChannelFactory;
    public static final ConcurrentMap<AgiConnectionHandler, AgiChannel> AGI_CONNECTION_HANDLERS = new ConcurrentHashMap<AgiConnectionHandler, AgiChannel>(32);
    private final MappingStrategy mappingStrategy;

    protected AgiConnectionHandler(MappingStrategy mappingStrategy, AgiChannelFactory agiChannelFactory) {
        if (mappingStrategy == null) {
            throw new IllegalArgumentException("MappingStrategy must not be null");
        }
        if (agiChannelFactory == null) {
            throw new IllegalArgumentException("AgiChannelFactory must not be null");
        }
        this.agiChannelFactory = agiChannelFactory;
        this.mappingStrategy = mappingStrategy;
    }

    protected boolean isIgnoreMissingScripts() {
        return this.ignoreMissingScripts;
    }

    protected void setIgnoreMissingScripts(boolean bl2) {
        this.ignoreMissingScripts = bl2;
    }

    protected AgiScript getScript() {
        return this.script;
    }

    protected abstract AgiReader createReader();

    protected abstract AgiWriter createWriter();

    public abstract void release();

    @Override
    public void run() {
        AgiChannel agiChannel = null;
        try {
            Object object = this.createReader();
            AgiWriter agiWriter = this.createWriter();
            AgiRequest agiRequest = object.readRequest();
            agiChannel = this.agiChannelFactory.createAgiChannel(agiRequest, agiWriter, (AgiReader)object);
            channel.set(agiChannel);
            if (this.mappingStrategy != null) {
                this.script = this.mappingStrategy.determineScript(agiRequest, agiChannel);
            }
            if (this.script == null && !this.ignoreMissingScripts) {
                object = "No script configured for URL '" + agiRequest.getRequestURL() + "' (script '" + agiRequest.getScript() + "')";
                this.logger.error(object);
                this.setStatusVariable(agiChannel, AJ_AGISTATUS_NOT_FOUND);
                this.logToAsterisk(agiChannel, (String)object);
            } else if (this.script != null) {
                AGI_CONNECTION_HANDLERS.put(this, agiChannel);
                AgiConnectionHandler agiConnectionHandler = this;
                agiConnectionHandler.runScript(agiConnectionHandler.script, agiRequest, agiChannel);
            }
            return;
        }
        catch (AgiException agiException) {
            this.setStatusVariable(agiChannel, AJ_AGISTATUS_FAILED);
            this.logger.error("AgiException while handling request", agiException);
            return;
        }
        catch (Exception exception) {
            this.setStatusVariable(agiChannel, AJ_AGISTATUS_FAILED);
            this.logger.error("Unexpected Exception while handling request", exception);
            return;
        }
        finally {
            AGI_CONNECTION_HANDLERS.remove(this);
            channel.set(null);
            this.release();
        }
    }

    private void runScript(AgiScript agiScript, AgiRequest agiRequest, AgiChannel agiChannel) {
        String string = Thread.currentThread().getName();
        this.logger.info("Begin AgiScript " + this.getScriptName(agiScript) + " on " + string);
        try {
            agiScript.service(agiRequest, agiChannel);
            this.setStatusVariable(agiChannel, AJ_AGISTATUS_SUCCESS);
        }
        catch (AgiException agiException) {
            this.logger.error("AgiException running AgiScript " + this.getScriptName(agiScript) + " on " + string, agiException);
            this.setStatusVariable(agiChannel, AJ_AGISTATUS_FAILED);
        }
        catch (Exception exception) {
            this.logger.error("Exception running AgiScript " + this.getScriptName(agiScript) + " on " + string, exception);
            this.setStatusVariable(agiChannel, AJ_AGISTATUS_FAILED);
        }
        this.logger.info("End AgiScript " + this.getScriptName(agiScript) + " on " + string);
    }

    protected String getScriptName(AgiScript agiScript) {
        if (agiScript == null) {
            return null;
        }
        if (agiScript instanceof NamedAgiScript) {
            return ((NamedAgiScript)agiScript).getName();
        }
        return agiScript.getClass().getName();
    }

    private void setStatusVariable(AgiChannel agiChannel, String string) {
        if (agiChannel == null) {
            return;
        }
        try {
            agiChannel.setVariable(AJ_AGISTATUS_VARIABLE, string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void logToAsterisk(AgiChannel agiChannel, String string) {
        if (agiChannel == null) {
            return;
        }
        try {
            agiChannel.sendCommand(new VerboseCommand(string, 1));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static AgiChannel getChannel() {
        return channel.get();
    }
}

