/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.live.AgentState;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.internal.AsteriskAgentImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.manager.action.AgentsAction;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgentManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final Map<String, AsteriskAgentImpl> agents;
    private final Map<String, AsteriskAgentImpl> ringingAgents;

    AgentManager(AsteriskServerImpl asteriskServerImpl) {
        this.server = asteriskServerImpl;
        this.agents = new HashMap<String, AsteriskAgentImpl>();
        this.ringingAgents = new HashMap<String, AsteriskAgentImpl>();
    }

    void initialize() {
        for (ManagerEvent managerEvent : this.server.sendEventGeneratingAction(new AgentsAction()).getEvents()) {
            if (!(managerEvent instanceof AgentsEvent)) continue;
            this.logger.info(managerEvent);
            this.handleAgentsEvent((AgentsEvent)managerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            this.agents.clear();
            return;
        }
    }

    void handleAgentsEvent(AgentsEvent object) {
        object = new AsteriskAgentImpl(this.server, ((AgentsEvent)object).getName(), "Agent/" + ((AgentsEvent)object).getAgent(), AgentState.valueOf(((AgentsEvent)object).getStatus()));
        this.logger.info("Adding agent " + ((AsteriskAgentImpl)object).getName() + "(" + ((AsteriskAgentImpl)object).getAgentId() + ")");
        this.addAgent((AsteriskAgentImpl)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAgent(AsteriskAgentImpl asteriskAgentImpl) {
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            this.agents.put(asteriskAgentImpl.getAgentId(), asteriskAgentImpl);
        }
        this.server.fireNewAgent(asteriskAgentImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskAgentImpl getAgentByAgentId(String string) {
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            return this.agents.get(string);
        }
    }

    void handleAgentCalledEvent(AgentCalledEvent agentCalledEvent) {
        AsteriskAgentImpl asteriskAgentImpl = this.getAgentByAgentId(agentCalledEvent.getAgentCalled());
        if (asteriskAgentImpl == null) {
            this.logger.error("Ignored AgentCalledEvent for unknown agent " + agentCalledEvent.getAgentCalled());
            return;
        }
        this.updateRingingAgents(agentCalledEvent.getChannelCalling(), asteriskAgentImpl);
        this.updateAgentState(asteriskAgentImpl, AgentState.AGENT_RINGING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgentState(AsteriskAgentImpl asteriskAgentImpl, AgentState agentState) {
        this.logger.info("Set state of agent " + asteriskAgentImpl.getAgentId() + " to " + (Object)((Object)agentState));
        AsteriskAgentImpl asteriskAgentImpl2 = asteriskAgentImpl;
        synchronized (asteriskAgentImpl2) {
            asteriskAgentImpl.updateState(agentState);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRingingAgents(String string, AsteriskAgentImpl asteriskAgentImpl) {
        Map<String, AsteriskAgentImpl> map = this.ringingAgents;
        synchronized (map) {
            if (this.ringingAgents.containsKey(string)) {
                AgentManager agentManager = this;
                agentManager.updateAgentState(agentManager.ringingAgents.get(string), AgentState.AGENT_IDLE);
            }
            this.ringingAgents.put(string, asteriskAgentImpl);
            return;
        }
    }

    void handleAgentConnectEvent(AgentConnectEvent agentConnectEvent) {
        AsteriskAgentImpl asteriskAgentImpl = this.getAgentByAgentId(agentConnectEvent.getChannel());
        if (asteriskAgentImpl == null) {
            this.logger.error("Ignored AgentConnectEvent for unknown agent " + agentConnectEvent.getChannel());
            return;
        }
        asteriskAgentImpl.updateState(AgentState.AGENT_ONCALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAgentLoginEvent(AgentLoginEvent agentLoginEvent) {
        Object object = this.getAgentByAgentId("Agent/" + agentLoginEvent.getAgent());
        if (object == null) {
            object = this.agents;
            synchronized (object) {
                this.logger.error("Ignored AgentLoginEvent for unknown agent " + agentLoginEvent.getAgent() + ". Agents: " + this.agents.values().toString());
                return;
            }
        }
        ((AsteriskAgentImpl)object).updateState(AgentState.AGENT_IDLE);
    }

    void handleAgentLogoffEvent(AgentLogoffEvent agentLogoffEvent) {
        AsteriskAgentImpl asteriskAgentImpl = this.getAgentByAgentId("Agent/" + agentLogoffEvent.getAgent());
        if (asteriskAgentImpl == null) {
            this.logger.error("Ignored AgentLogoffEvent for unknown agent " + agentLogoffEvent.getAgent() + ". Agents: " + this.agents.values().toString());
            return;
        }
        asteriskAgentImpl.updateState(AgentState.AGENT_LOGGEDOFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAgentCallbackLoginEvent(AgentCallbackLoginEvent agentCallbackLoginEvent) {
        Object object = this.getAgentByAgentId("Agent/" + agentCallbackLoginEvent.getAgent());
        if (object == null) {
            object = this.agents;
            synchronized (object) {
                this.logger.error("Ignored AgentCallbackLoginEvent for unknown agent " + agentCallbackLoginEvent.getAgent() + ". Agents: " + this.agents.values().toString());
                return;
            }
        }
        ((AsteriskAgentImpl)object).updateState(AgentState.AGENT_IDLE);
    }

    void handleAgentCallbackLogoffEvent(AgentCallbackLogoffEvent agentCallbackLogoffEvent) {
        AsteriskAgentImpl asteriskAgentImpl = this.getAgentByAgentId("Agent/" + agentCallbackLogoffEvent.getAgent());
        if (asteriskAgentImpl == null) {
            this.logger.error("Ignored AgentCallbackLogoffEvent for unknown agent " + agentCallbackLogoffEvent.getAgent() + ". Agents: " + this.agents.values().toString());
            return;
        }
        asteriskAgentImpl.updateState(AgentState.AGENT_LOGGEDOFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskAgent> getAgents() {
        ArrayList<AsteriskAgent> arrayList;
        Map<String, AsteriskAgentImpl> map = this.agents;
        synchronized (map) {
            arrayList = new ArrayList<AsteriskAgent>(this.agents.values());
        }
        return arrayList;
    }

    void handleAgentCompleteEvent(AgentCompleteEvent agentCompleteEvent) {
        AsteriskAgentImpl asteriskAgentImpl = this.getAgentByAgentId(agentCompleteEvent.getChannel());
        if (asteriskAgentImpl == null) {
            this.logger.error("Ignored AgentCompleteEvent for unknown agent " + agentCompleteEvent.getChannel());
            return;
        }
        asteriskAgentImpl.updateState(AgentState.AGENT_IDLE);
    }
}

