/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.CallerId;
import org.asteriskjava.live.ChannelState;
import org.asteriskjava.live.Extension;
import org.asteriskjava.live.HangupCause;
import org.asteriskjava.live.NoSuchChannelException;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.CallDetailRecordImpl;
import org.asteriskjava.live.internal.ChannelManager$1;
import org.asteriskjava.manager.action.StatusAction;
import org.asteriskjava.manager.event.AbstractChannelEvent;
import org.asteriskjava.manager.event.AbstractMonitorEvent;
import org.asteriskjava.manager.event.AbstractParkedCallEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DtmfEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MonitorStartEvent;
import org.asteriskjava.manager.event.MonitorStopEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.StatusEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.VarSetEvent;
import org.asteriskjava.util.DaemonThreadFactory;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class ChannelManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final long REMOVAL_THRESHOLD = 900000L;
    private static final long SLEEP_TIME_BEFORE_GET_VAR = 50L;
    private final AsteriskServerImpl server;
    final LinkedHashMap<String, AsteriskChannelImpl> channels = new LinkedHashMap();
    ScheduledThreadPoolExecutor traceScheduledExecutorService;

    ChannelManager(AsteriskServerImpl asteriskServerImpl) {
        this.server = asteriskServerImpl;
    }

    void initialize() {
        this.initialize(null);
    }

    void initialize(List<String> object) {
        this.disconnected();
        this.traceScheduledExecutorService = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());
        StatusAction serializable2 = new StatusAction();
        serializable2.setVariables((List<String>)((Object)object));
        for (ManagerEvent managerEvent : this.server.sendEventGeneratingAction(serializable2).getEvents()) {
            if (!(managerEvent instanceof StatusEvent)) continue;
            this.handleStatusEvent((StatusEvent)managerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        if (this.traceScheduledExecutorService != null) {
            this.traceScheduledExecutorService.shutdown();
        }
        LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            this.channels.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskChannel> getChannels() {
        ArrayList<AsteriskChannel> arrayList;
        LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            arrayList = new ArrayList<AsteriskChannel>(this.channels.size() + 2);
            for (AsteriskChannel asteriskChannel : this.channels.values()) {
                if (asteriskChannel.getState() == ChannelState.HUNGUP) continue;
                arrayList.add(asteriskChannel);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChannel(AsteriskChannelImpl asteriskChannelImpl) {
        LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            this.channels.put(asteriskChannelImpl.getId(), asteriskChannelImpl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldChannels() {
        LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            Iterator<AsteriskChannelImpl> iterator = this.channels.values().iterator();
            while (iterator.hasNext()) {
                AsteriskChannel asteriskChannel = iterator.next();
                Date date = asteriskChannel.getDateOfRemoval();
                if (asteriskChannel.getState() != ChannelState.HUNGUP || date == null || DateUtil.getDate().getTime() - date.getTime() < 900000L) continue;
                iterator.remove();
            }
            return;
        }
    }

    private AsteriskChannelImpl addNewChannel(String object, String string, Date object2, String string2, String string3, ChannelState channelState, String string4) {
        object = new AsteriskChannelImpl(this.server, string, (String)object, (Date)object2);
        ((AsteriskChannelImpl)object).setCallerId(new CallerId(string3, string2));
        ((AsteriskChannelImpl)object).setAccount(string4);
        ((AsteriskChannelImpl)object).stateChanged((Date)object2, channelState);
        this.logger.info("Adding channel " + ((AsteriskChannelImpl)object).getName() + "(" + ((AsteriskChannelImpl)object).getId() + ")");
        long l2 = System.currentTimeMillis() + 50L;
        while (System.currentTimeMillis() < l2) {
            try {
                ((AsteriskChannelImpl)object).getVariable("AJ_TRACE_ID");
            }
            catch (NoSuchChannelException noSuchChannelException) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        object2 = this.getTraceId((AsteriskChannel)object);
        ((AsteriskChannelImpl)object).setTraceId((String)object2);
        this.addChannel((AsteriskChannelImpl)object);
        this.traceScheduledExecutorService.schedule(new ChannelManager$1(this, (AsteriskChannelImpl)object, string), 50L, TimeUnit.MILLISECONDS);
        this.server.fireNewAsteriskChannel((AsteriskChannel)object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleStatusEvent(StatusEvent statusEvent) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2 = false;
        Object object4 = statusEvent.getVariables();
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(statusEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            object3 = statusEvent.getSeconds() != null ? new Date(DateUtil.getDate().getTime() - (long)statusEvent.getSeconds().intValue() * 1000L) : DateUtil.getDate();
            asteriskChannelImpl = new AsteriskChannelImpl(this.server, statusEvent.getChannel(), statusEvent.getUniqueId(), (Date)object3);
            bl2 = true;
            if (object4 != null) {
                object2 = object4.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    asteriskChannelImpl.updateVariable((String)object, (String)object4.get(object));
                }
            }
        }
        object4 = statusEvent.getContext() == null && statusEvent.getExtension() == null && statusEvent.getPriority() == null ? null : new Extension(statusEvent.getContext(), statusEvent.getExtension(), statusEvent.getPriority());
        object3 = asteriskChannelImpl;
        synchronized (object3) {
            asteriskChannelImpl.setCallerId(new CallerId(statusEvent.getCallerIdName(), statusEvent.getCallerIdNum()));
            asteriskChannelImpl.setAccount(statusEvent.getAccountCode());
            if (statusEvent.getChannelState() != null) {
                asteriskChannelImpl.stateChanged(statusEvent.getDateReceived(), ChannelState.valueOf(statusEvent.getChannelState()));
            }
            asteriskChannelImpl.extensionVisited(statusEvent.getDateReceived(), (Extension)object4);
            if (statusEvent.getBridgedChannel() != null && (object2 = this.getChannelImplByName(statusEvent.getBridgedChannel())) != null) {
                asteriskChannelImpl.channelLinked(statusEvent.getDateReceived(), (AsteriskChannel)object2);
                object = object2;
                synchronized (object) {
                    ((AsteriskChannelImpl)object2).channelLinked(statusEvent.getDateReceived(), asteriskChannelImpl);
                }
            }
        }
        if (bl2) {
            this.logger.info("Adding new channel " + asteriskChannelImpl.getName());
            this.addChannel(asteriskChannelImpl);
            this.server.fireNewAsteriskChannel(asteriskChannelImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskChannelImpl getChannelImplByName(String string) {
        Date date = null;
        AsteriskChannelImpl asteriskChannelImpl = null;
        if (string == null) {
            return null;
        }
        LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            for (AsteriskChannelImpl asteriskChannelImpl2 : this.channels.values()) {
                if (!string.equals(asteriskChannelImpl2.getName()) || date != null && !asteriskChannelImpl2.getDateOfCreation().after(date) && (!asteriskChannelImpl2.getDateOfCreation().equals(date) || asteriskChannelImpl2.getState() == ChannelState.HUNGUP)) continue;
                asteriskChannelImpl = asteriskChannelImpl2;
                date = asteriskChannelImpl.getDateOfCreation();
            }
        }
        return asteriskChannelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskChannelImpl getChannelImplByNameAndActive(String string) {
        AsteriskChannelImpl asteriskChannelImpl = null;
        if (string == null) {
            return null;
        }
        LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            for (AsteriskChannelImpl asteriskChannelImpl2 : this.channels.values()) {
                if (!string.equals(asteriskChannelImpl2.getName()) || asteriskChannelImpl2.getState() == ChannelState.HUNGUP) continue;
                asteriskChannelImpl = asteriskChannelImpl2;
            }
        }
        return asteriskChannelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskChannelImpl getChannelImplById(String string) {
        if (string == null) {
            return null;
        }
        LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
        synchronized (linkedHashMap) {
            return this.channels.get(string);
        }
    }

    AsteriskChannelImpl getOtherSideOfLocalChannel(AsteriskChannel object) {
        block7: {
            block6: {
                if (object == null) {
                    return null;
                }
                if ((object = object.getName()) == null || !((String)object).startsWith("Local/")) break block6;
                Object object2 = object;
                if (((String)object2).charAt(((String)object2).length() - 2) == ',') break block7;
                Object object3 = object;
                if (((String)object3).charAt(((String)object3).length() - 2) == ';') break block7;
            }
            return null;
        }
        Object object4 = object;
        char c2 = ((String)object4).charAt(((String)object4).length() - 1);
        if (c2 == '1') {
            return this.getChannelImplByName(((String)object).substring(0, ((String)object).length() - 1) + "2");
        }
        if (c2 == '2') {
            return this.getChannelImplByName(((String)object).substring(0, ((String)object).length() - 1) + "1");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewChannelEvent(NewChannelEvent newChannelEvent) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(newChannelEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            if (newChannelEvent.getChannel() == null) {
                this.logger.info("Ignored NewChannelEvent with empty channel name (uniqueId=" + newChannelEvent.getUniqueId() + ")");
                return;
            }
            this.addNewChannel(newChannelEvent.getUniqueId(), newChannelEvent.getChannel(), newChannelEvent.getDateReceived(), newChannelEvent.getCallerIdNum(), newChannelEvent.getCallerIdName(), ChannelState.valueOf(newChannelEvent.getChannelState()), newChannelEvent.getAccountCode());
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.nameChanged(newChannelEvent.getDateReceived(), newChannelEvent.getChannel());
            asteriskChannelImpl.setCallerId(new CallerId(newChannelEvent.getCallerIdName(), newChannelEvent.getCallerIdNum()));
            asteriskChannelImpl.stateChanged(newChannelEvent.getDateReceived(), ChannelState.valueOf(newChannelEvent.getChannelState()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewExtenEvent(NewExtenEvent newExtenEvent) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(newExtenEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            this.logger.warn("handleNewExtenEvent: Ignored NewExtenEvent for unknown channel " + newExtenEvent.getChannel());
            return;
        }
        Extension extension = new Extension(newExtenEvent.getContext(), newExtenEvent.getExtension(), newExtenEvent.getPriority(), newExtenEvent.getApplication(), newExtenEvent.getAppData());
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.extensionVisited(newExtenEvent.getDateReceived(), extension);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idChanged(AsteriskChannelImpl asteriskChannelImpl, AbstractChannelEvent abstractChannelEvent) {
        if (asteriskChannelImpl != null) {
            String string = asteriskChannelImpl.getId();
            String string2 = abstractChannelEvent.getUniqueId();
            if (string != null && string.equals(string2)) {
                return;
            }
            this.logger.info("Changing unique_id for '" + asteriskChannelImpl.getName() + "' from " + string + " to " + string2 + " < " + abstractChannelEvent);
            LinkedHashMap<String, AsteriskChannelImpl> linkedHashMap = this.channels;
            synchronized (linkedHashMap) {
                this.channels.remove(string);
                this.channels.put(string2, asteriskChannelImpl);
                asteriskChannelImpl.idChanged(abstractChannelEvent.getDateReceived(), string2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewStateEvent(NewStateEvent newStateEvent) {
        Object object;
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(newStateEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            asteriskChannelImpl = this.getChannelImplByNameAndActive(newStateEvent.getChannel());
            this.idChanged(asteriskChannelImpl, newStateEvent);
            if (asteriskChannelImpl == null) {
                this.logger.info("Creating new channel due to NewStateEvent '" + newStateEvent.getChannel() + "' unique id " + newStateEvent.getUniqueId());
                asteriskChannelImpl = this.addNewChannel(newStateEvent.getUniqueId(), newStateEvent.getChannel(), newStateEvent.getDateReceived(), newStateEvent.getCallerIdNum(), newStateEvent.getCallerIdName(), ChannelState.valueOf(newStateEvent.getChannelState()), null);
            }
        }
        if (newStateEvent.getCallerIdNum() != null || newStateEvent.getCallerIdName() != null) {
            object = "";
            String string = "";
            CallerId callerId = asteriskChannelImpl.getCallerId();
            if (callerId != null) {
                object = callerId.getNumber();
                string = callerId.getName();
            }
            if (newStateEvent.getCallerIdNum() != null) {
                object = newStateEvent.getCallerIdNum();
            }
            if (newStateEvent.getCallerIdName() != null) {
                string = newStateEvent.getCallerIdName();
            }
            object = new CallerId(string, (String)object);
            this.logger.debug("Updating CallerId (following NewStateEvent) to: " + ((CallerId)object).toString());
            asteriskChannelImpl.setCallerId((CallerId)object);
            if (newStateEvent.getChannel() != null && !newStateEvent.getChannel().equals(asteriskChannelImpl.getName())) {
                this.logger.info("Renaming channel (following NewStateEvent) '" + asteriskChannelImpl.getName() + "' to '" + newStateEvent.getChannel() + "'");
                object = asteriskChannelImpl;
                synchronized (object) {
                    asteriskChannelImpl.nameChanged(newStateEvent.getDateReceived(), newStateEvent.getChannel());
                }
            }
        }
        if (newStateEvent.getChannelState() != null) {
            object = asteriskChannelImpl;
            synchronized (object) {
                asteriskChannelImpl.stateChanged(newStateEvent.getDateReceived(), ChannelState.valueOf(newStateEvent.getChannelState()));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNewCallerIdEvent(NewCallerIdEvent newCallerIdEvent) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(newCallerIdEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            asteriskChannelImpl = this.getChannelImplByNameAndActive(newCallerIdEvent.getChannel());
            this.idChanged(asteriskChannelImpl, newCallerIdEvent);
            if (asteriskChannelImpl == null) {
                asteriskChannelImpl = this.addNewChannel(newCallerIdEvent.getUniqueId(), newCallerIdEvent.getChannel(), newCallerIdEvent.getDateReceived(), newCallerIdEvent.getCallerIdNum(), newCallerIdEvent.getCallerIdName(), ChannelState.DOWN, null);
            }
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.setCallerId(new CallerId(newCallerIdEvent.getCallerIdName(), newCallerIdEvent.getCallerIdNum()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleHangupEvent(HangupEvent hangupEvent) {
        HangupCause hangupCause = null;
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(hangupEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            this.logger.warn("handleHangupEvent: Ignored HangupEvent for unknown channel " + hangupEvent.getChannel());
            return;
        }
        if (hangupEvent.getCause() != null) {
            hangupCause = HangupCause.getByCode(hangupEvent.getCause());
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.hungup(hangupEvent.getDateReceived(), hangupCause, hangupEvent.getCauseTxt());
        }
        this.logger.info("Removing channel " + asteriskChannelImpl.getName() + " due to hangup (" + (Object)((Object)hangupCause) + ")");
        this.removeOldChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDialEvent(DialEvent dialEvent) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(dialEvent.getUniqueId());
        AsteriskChannelImpl asteriskChannelImpl2 = this.getChannelImplById(dialEvent.getDestUniqueId());
        if (asteriskChannelImpl == null) {
            this.logger.warn("handleDialEvent: Ignored DialEvent for unknown source channel " + dialEvent.getChannel() + " with unique id " + dialEvent.getUniqueId());
            return;
        }
        if (asteriskChannelImpl2 == null) {
            if ("End".equalsIgnoreCase(dialEvent.getSubEvent())) {
                asteriskChannelImpl.updateVariable("AJ_DIAL_STATUS", dialEvent.getDialStatus());
                this.logger.info("handleDialEvent: Ignored DialEvent for unknown dst channel " + dialEvent.getDestination() + " with unique_id " + dialEvent.getDestUniqueId());
                return;
            }
            this.logger.warn("handleDialEvent: Ignored DialEvent for unknown dst channel " + dialEvent.getDestination() + " with unique_id " + dialEvent.getDestUniqueId());
            return;
        }
        this.logger.info(asteriskChannelImpl.getName() + " dialed " + asteriskChannelImpl2.getName());
        this.getTraceId(asteriskChannelImpl);
        this.getTraceId(asteriskChannelImpl2);
        AsteriskChannelImpl asteriskChannelImpl3 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl3) {
            asteriskChannelImpl.channelDialed(dialEvent.getDateReceived(), asteriskChannelImpl2);
        }
        asteriskChannelImpl3 = asteriskChannelImpl2;
        synchronized (asteriskChannelImpl3) {
            asteriskChannelImpl2.channelDialing(dialEvent.getDateReceived(), asteriskChannelImpl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBridgeEvent(BridgeEvent bridgeEvent) {
        AsteriskChannelImpl asteriskChannelImpl;
        AsteriskChannelImpl asteriskChannelImpl2 = this.getChannelImplById(bridgeEvent.getUniqueId1());
        AsteriskChannelImpl asteriskChannelImpl3 = this.getChannelImplById(bridgeEvent.getUniqueId2());
        if (asteriskChannelImpl2 == null) {
            this.logger.warn("handleBridgeEvent: Ignored BridgeEvent for unknown channel " + bridgeEvent.getChannel1());
            return;
        }
        if (asteriskChannelImpl3 == null) {
            this.logger.warn("handleBridgeEvent: Ignored BridgeEvent for unknown channel " + bridgeEvent.getChannel2());
            return;
        }
        if (bridgeEvent.isLink()) {
            this.logger.info("Linking channels " + asteriskChannelImpl2.getName() + " and " + asteriskChannelImpl3.getName());
            asteriskChannelImpl = asteriskChannelImpl2;
            synchronized (asteriskChannelImpl) {
                asteriskChannelImpl2.channelLinked(bridgeEvent.getDateReceived(), asteriskChannelImpl3);
            }
            asteriskChannelImpl = asteriskChannelImpl3;
            synchronized (asteriskChannelImpl) {
                asteriskChannelImpl3.channelLinked(bridgeEvent.getDateReceived(), asteriskChannelImpl2);
            }
        }
        if (bridgeEvent.isUnlink()) {
            this.logger.info("Unlinking channels " + asteriskChannelImpl2.getName() + " and " + asteriskChannelImpl3.getName());
            asteriskChannelImpl = asteriskChannelImpl2;
            synchronized (asteriskChannelImpl) {
                asteriskChannelImpl2.channelUnlinked(bridgeEvent.getDateReceived());
            }
            asteriskChannelImpl = asteriskChannelImpl3;
            synchronized (asteriskChannelImpl) {
                asteriskChannelImpl3.channelUnlinked(bridgeEvent.getDateReceived());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRenameEvent(RenameEvent renameEvent) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(renameEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            this.logger.warn("handleRenameEvent: Ignored RenameEvent for unknown channel with uniqueId " + renameEvent.getUniqueId());
            return;
        }
        this.logger.info("Renaming channel '" + asteriskChannelImpl.getName() + "' to '" + renameEvent.getNewname() + "', uniqueId is " + renameEvent.getUniqueId());
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.nameChanged(renameEvent.getDateReceived(), renameEvent.getNewname());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCdrEvent(CdrEvent cdrEvent) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(cdrEvent.getUniqueId());
        Object object = this.getChannelImplByName(cdrEvent.getDestinationChannel());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored CdrEvent for unknown channel with uniqueId " + cdrEvent.getUniqueId());
            return;
        }
        object = new CallDetailRecordImpl(asteriskChannelImpl, (AsteriskChannelImpl)object, cdrEvent);
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.callDetailRecordReceived(cdrEvent.getDateReceived(), (CallDetailRecordImpl)object);
            return;
        }
    }

    private String getTraceId(AsteriskChannel object) {
        try {
            object = object.getVariable("AJ_TRACE_ID");
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleParkedCallEvent(ParkedCallEvent serializable) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplByNameAndActive(serializable.getChannel());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored ParkedCallEvent for unknown channel " + serializable.getChannel());
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            serializable = new Extension(null, serializable.getExten(), 1);
            asteriskChannelImpl.setParkedAt((Extension)serializable);
            this.logger.info("Channel " + asteriskChannelImpl.getName() + " is parked at " + asteriskChannelImpl.getParkedAt().getExtension());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleParkedCallGiveUpEvent(ParkedCallGiveUpEvent serializable) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplByNameAndActive(((AbstractParkedCallEvent)serializable).getChannel());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored ParkedCallGiveUpEvent for unknown channel " + ((AbstractParkedCallEvent)serializable).getChannel());
            return;
        }
        serializable = asteriskChannelImpl.getParkedAt();
        if (serializable == null) {
            this.logger.info("Ignored ParkedCallGiveUpEvent as the channel was not parked");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.setParkedAt(null);
        }
        this.logger.info("Channel " + asteriskChannelImpl.getName() + " is unparked (GiveUp) from " + ((Extension)serializable).getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleParkedCallTimeOutEvent(ParkedCallTimeOutEvent serializable) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplByNameAndActive(((AbstractParkedCallEvent)serializable).getChannel());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored ParkedCallTimeOutEvent for unknown channel " + ((AbstractParkedCallEvent)serializable).getChannel());
            return;
        }
        serializable = asteriskChannelImpl.getParkedAt();
        if (serializable == null) {
            this.logger.info("Ignored ParkedCallTimeOutEvent as the channel was not parked");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.setParkedAt(null);
        }
        this.logger.info("Channel " + asteriskChannelImpl.getName() + " is unparked (Timeout) from " + ((Extension)serializable).getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnparkedCallEvent(UnparkedCallEvent serializable) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplByNameAndActive(((AbstractParkedCallEvent)serializable).getChannel());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored UnparkedCallEvent for unknown channel " + ((AbstractParkedCallEvent)serializable).getChannel());
            return;
        }
        serializable = asteriskChannelImpl.getParkedAt();
        if (serializable == null) {
            this.logger.info("Ignored UnparkedCallEvent as the channel was not parked");
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.setParkedAt(null);
        }
        this.logger.info("Channel " + asteriskChannelImpl.getName() + " is unparked (moved away) from " + ((Extension)serializable).getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleVarSetEvent(VarSetEvent varSetEvent) {
        if (varSetEvent.getUniqueId() == null) {
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(varSetEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored VarSetEvent for unknown channel with uniqueId " + varSetEvent.getUniqueId());
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            asteriskChannelImpl.updateVariable(varSetEvent.getVariable(), varSetEvent.getValue());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDtmfEvent(DtmfEvent dtmfEvent) {
        if (dtmfEvent.isBegin().booleanValue()) {
            return;
        }
        if (dtmfEvent.getUniqueId() == null) {
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplById(dtmfEvent.getUniqueId());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored DtmfEvent for unknown channel with uniqueId " + dtmfEvent.getUniqueId());
            return;
        }
        Character c2 = dtmfEvent.getDigit() == null || dtmfEvent.getDigit().length() <= 0 ? null : Character.valueOf(dtmfEvent.getDigit().charAt(0));
        AsteriskChannelImpl asteriskChannelImpl2 = asteriskChannelImpl;
        synchronized (asteriskChannelImpl2) {
            if (dtmfEvent.isReceived()) {
                asteriskChannelImpl.dtmfReceived(c2);
            }
            if (dtmfEvent.isSent()) {
                asteriskChannelImpl.dtmfSent(c2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorStartEvent(MonitorStartEvent object) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplByNameAndActive(((AbstractMonitorEvent)object).getChannel());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored MonitorStartEvent for unknown channel " + ((AbstractMonitorEvent)object).getChannel());
            return;
        }
        if (asteriskChannelImpl.isMonitored()) {
            this.logger.info("Ignored MonitorStartEvent as the channel was already monitored");
            return;
        }
        object = asteriskChannelImpl;
        synchronized (object) {
            asteriskChannelImpl.setMonitored(true);
        }
        this.logger.info("Channel " + asteriskChannelImpl.getName() + " is monitored");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMonitorStopEvent(MonitorStopEvent object) {
        AsteriskChannelImpl asteriskChannelImpl = this.getChannelImplByNameAndActive(((AbstractMonitorEvent)object).getChannel());
        if (asteriskChannelImpl == null) {
            this.logger.info("Ignored MonitorStopEvent for unknown channel " + ((AbstractMonitorEvent)object).getChannel());
            return;
        }
        if (!asteriskChannelImpl.isMonitored()) {
            this.logger.info("Ignored MonitorStopEvent as the channel was not monitored");
            return;
        }
        object = asteriskChannelImpl;
        synchronized (object) {
            asteriskChannelImpl.setMonitored(false);
        }
        this.logger.info("Channel " + asteriskChannelImpl.getName() + " is not monitored");
    }

    static /* synthetic */ String access$000(ChannelManager channelManager, AsteriskChannel asteriskChannel) {
        return channelManager.getTraceId(asteriskChannel);
    }

    static /* synthetic */ AsteriskServerImpl access$100(ChannelManager channelManager) {
        return channelManager.server;
    }

    static /* synthetic */ Log access$200(ChannelManager channelManager) {
        return channelManager.logger;
    }
}

