/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.PingAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class PingThread
extends Thread {
    private static final long DEFAULT_INTERVAL = 20000L;
    private static final long DEFAULT_TIMEOUT = 0L;
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private long interval = 20000L;
    private long timeout = 0L;
    private volatile boolean die = false;
    private final Set<ManagerConnection> connections = new HashSet<ManagerConnection>();

    public PingThread() {
        long l2 = idCounter.getAndIncrement();
        this.setName("Asterisk-Java Ping-".concat(String.valueOf(l2)));
        this.setDaemon(true);
    }

    public PingThread(ManagerConnection managerConnection) {
        this();
        this.connections.add(managerConnection);
    }

    public void setInterval(long l2) {
        this.interval = l2;
    }

    public void setTimeout(long l2) {
        this.timeout = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ManagerConnection managerConnection) {
        Set<ManagerConnection> set = this.connections;
        synchronized (set) {
            this.connections.add(managerConnection);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ManagerConnection managerConnection) {
        Set<ManagerConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(managerConnection);
            return;
        }
    }

    public void die() {
        this.die = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.die) {
            try {
                PingThread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.die) break;
            Set<ManagerConnection> set = this.connections;
            synchronized (set) {
                for (ManagerConnection managerConnection : this.connections) {
                    if (managerConnection.getState() != ManagerConnectionState.CONNECTED) continue;
                    this.ping(managerConnection);
                }
            }
        }
    }

    protected void ping(ManagerConnection managerConnection) {
        try {
            if (this.timeout <= 0L) {
                managerConnection.sendAction((ManagerAction)new PingAction(), null);
                return;
            }
            ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)new PingAction(), this.timeout);
            this.logger.debug("Ping response '" + managerResponse + "' for " + managerConnection.toString());
            return;
        }
        catch (Exception exception) {
            this.logger.warn("Exception on sending Ping to " + managerConnection.toString(), exception);
            return;
        }
    }
}

