/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

abstract class AbstractBuilder {
    protected final Log logger = LogFactory.getLog(this.getClass());

    AbstractBuilder() {
    }

    protected void setAttributes(Object object, Map<String, Object> object2, Set<String> set) {
        Map<String, Method> map = ReflectionUtil.getSetters(object.getClass());
        for (Map.Entry entry : object2.entrySet()) {
            Method method;
            if (set != null && set.contains(entry.getKey())) continue;
            Object object3 = ReflectionUtil.stripIllegalCharacters((String)entry.getKey());
            if ("source".equals(object3)) {
                object3 = "src";
            }
            if ("class".equals(object3)) {
                object3 = "classname";
            }
            if ((method = map.get(object3)) == null && !((String)object3).endsWith("s") && (method = map.get((String)object3 + "s")) != null && !method.getParameterTypes()[0].isAssignableFrom(Map.class)) {
                method = null;
            }
            if (method == null && !(object instanceof UserEvent)) {
                this.logger.warn("Unable to set property '" + (String)entry.getKey() + "' to '" + entry.getValue() + "' on " + object.getClass().getName() + ": no setter. Please report at http://jira.reucon.org/browse/AJ");
            }
            if (method == null) continue;
            Class<Object> clazz = method.getParameterTypes()[0];
            if (clazz == Boolean.class) {
                object3 = AstUtil.isTrue(entry.getValue());
            } else if (clazz.isAssignableFrom(String.class)) {
                object3 = entry.getValue();
                if (AstUtil.isNull(object3)) {
                    object3 = null;
                }
            } else if (clazz.isAssignableFrom(Map.class)) {
                if (entry.getValue() instanceof List) {
                    Map<String, String> map2 = object3 = (List)entry.getValue();
                    object3 = this.buildMap(map2.toArray(new String[map2.size()]));
                } else {
                    object3 = entry.getValue() instanceof String ? this.buildMap((String)entry.getValue()) : null;
                }
            } else {
                try {
                    object3 = clazz.getConstructor(String.class).newInstance(entry.getValue());
                }
                catch (Exception exception) {
                    this.logger.error(exception.getMessage());
                    this.logger.error("Unable to convert value '" + entry.getValue() + "' of property '" + (String)entry.getKey() + "' on " + object.getClass().getName() + " to required type " + clazz, exception);
                    continue;
                }
            }
            try {
                method.invoke(object, object3);
            }
            catch (Exception exception) {
                this.logger.error("Unable to set property '" + (String)entry.getKey() + "' to '" + entry.getValue() + "' on " + object.getClass().getName(), exception);
            }
        }
    }

    private Map<String, String> buildMap(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : stringArray) {
            int n2 = string.indexOf(61);
            if (n2 > 0) {
                String string2 = string.substring(0, n2);
                string = string.substring(n2 + 1, string.length());
                linkedHashMap.put(string2, string);
                continue;
            }
            this.logger.warn("Malformed line '" + string + "' for a map property");
        }
        return linkedHashMap;
    }
}

