/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ExpectedResponse;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.SendActionCallback;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ChallengeAction;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.LoginAction;
import org.asteriskjava.manager.action.LogoffAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.ManagerConnectionImpl$1;
import org.asteriskjava.manager.internal.ManagerConnectionImpl$DefaultSendActionCallback;
import org.asteriskjava.manager.internal.ManagerConnectionImpl$ProtocolIdentifierWrapper;
import org.asteriskjava.manager.internal.ManagerConnectionImpl$ResponseEventHandler;
import org.asteriskjava.manager.internal.ManagerConnectionImpl$ResponseHandlerResult;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ManagerReaderImpl;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.internal.ManagerWriter;
import org.asteriskjava.manager.internal.ManagerWriterImpl;
import org.asteriskjava.manager.internal.ResponseEventsImpl;
import org.asteriskjava.manager.response.ChallengeResponse;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.SocketConnectionFacadeImpl;

public class ManagerConnectionImpl
implements ManagerConnection,
Dispatcher {
    private static final int RECONNECTION_INTERVAL_1 = 50;
    private static final int RECONNECTION_INTERVAL_2 = 5000;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 5038;
    private static final int RECONNECTION_VERSION_INTERVAL = 500;
    private static final int MAX_VERSION_ATTEMPTS = 4;
    private static final Pattern SHOW_VERSION_PATTERN = Pattern.compile("^(core )?show version.*");
    private static final Pattern VERSION_PATTERN_1_6 = Pattern.compile("^\\s*Asterisk (SVN-branch-)?1\\.6[-. ].*");
    private static final Pattern VERSION_PATTERN_1_8 = Pattern.compile("^\\s*Asterisk (SVN-branch-)?1\\.8[-. ].*");
    private static final Pattern VERSION_PATTERN_10 = Pattern.compile("^\\s*Asterisk (SVN-branch-)?10[-. ].*");
    private static final Pattern VERSION_PATTERN_11 = Pattern.compile("^\\s*Asterisk (SVN-branch-)?11[-. ].*");
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final long id;
    private AtomicLong actionIdCounter = new AtomicLong(0L);
    private String hostname = "localhost";
    private int port = 5038;
    private boolean ssl = false;
    protected String username;
    protected String password;
    private long defaultResponseTimeout = 2000L;
    private long defaultEventTimeout = 5000L;
    private int socketTimeout = 0;
    private int socketReadTimeout = 0;
    private boolean keepAliveAfterAuthenticationFailure = true;
    private SocketConnectionFacade socket;
    private Thread readerThread;
    private final AtomicLong readerThreadCounter = new AtomicLong(0L);
    private final AtomicLong reconnectThreadCounter = new AtomicLong(0L);
    private ManagerReader reader;
    private ManagerWriter writer;
    private final ManagerConnectionImpl$ProtocolIdentifierWrapper protocolIdentifier;
    private AsteriskVersion version;
    private final Map<String, SendActionCallback> responseListeners;
    private final Map<String, ManagerEventListener> responseEventListeners;
    private final List<ManagerEventListener> eventListeners;
    protected ManagerConnectionState state = ManagerConnectionState.INITIAL;
    private String eventMask;

    public ManagerConnectionImpl() {
        this.id = idCounter.getAndIncrement();
        this.responseListeners = new HashMap<String, SendActionCallback>();
        this.responseEventListeners = new HashMap<String, ManagerEventListener>();
        this.eventListeners = new ArrayList<ManagerEventListener>();
        this.protocolIdentifier = new ManagerConnectionImpl$ProtocolIdentifierWrapper(null);
    }

    protected ManagerReader createReader(Dispatcher dispatcher, Object object) {
        return new ManagerReaderImpl(dispatcher, object);
    }

    protected ManagerWriter createWriter() {
        return new ManagerWriterImpl();
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setPort(int n2) {
        if (n2 <= 0) {
            this.port = 5038;
            return;
        }
        this.port = n2;
    }

    public void setSsl(boolean bl2) {
        this.ssl = bl2;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setDefaultResponseTimeout(long l2) {
        this.defaultResponseTimeout = l2;
    }

    public void setDefaultEventTimeout(long l2) {
        this.defaultEventTimeout = l2;
    }

    public void setKeepAliveAfterAuthenticationFailure(boolean bl2) {
        this.keepAliveAfterAuthenticationFailure = bl2;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public AsteriskVersion getVersion() {
        return this.version;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.socket.getRemotePort();
    }

    @Override
    public void registerUserEventClass(Class<? extends ManagerEvent> clazz) {
        if (this.reader == null) {
            ManagerConnectionImpl managerConnectionImpl = this;
            this.reader = this.createReader(managerConnectionImpl, managerConnectionImpl);
        }
        this.reader.registerEventClass(clazz);
    }

    @Override
    public void setSocketTimeout(int n2) {
        this.socketTimeout = n2;
    }

    @Override
    public void setSocketReadTimeout(int n2) {
        this.socketReadTimeout = n2;
    }

    @Override
    public synchronized void login() {
        this.login(null);
    }

    @Override
    public synchronized void login(String string) {
        if (this.state != ManagerConnectionState.INITIAL && this.state != ManagerConnectionState.DISCONNECTED) {
            throw new IllegalStateException("Login may only be perfomed when in state INITIAL or DISCONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.CONNECTING;
        this.eventMask = string;
        try {
            ManagerConnectionImpl managerConnectionImpl = this;
            managerConnectionImpl.doLogin(managerConnectionImpl.defaultResponseTimeout, string);
            if (this.state != ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.DISCONNECTED;
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.state != ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.DISCONNECTED;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doLogin(long l2, String string) {
        if (this.socket == null) {
            this.connect();
        }
        Object object = this.protocolIdentifier;
        synchronized (object) {
            if (this.protocolIdentifier.value == null) {
                try {
                    this.protocolIdentifier.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.protocolIdentifier.value == null) {
                this.disconnect();
                if (this.reader != null && this.reader.getTerminationException() != null) {
                    throw this.reader.getTerminationException();
                }
                throw new TimeoutException("Timeout waiting for protocol identifier");
            }
        }
        Object object2 = new ChallengeAction("MD5");
        try {
            object2 = this.sendAction((ManagerAction)object2);
        }
        catch (Exception exception) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send challenge action", exception);
        }
        if (!(object2 instanceof ChallengeResponse)) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to get challenge from Asterisk. ChallengeAction returned: " + ((ManagerResponse)object2).getMessage());
        }
        object2 = ((ChallengeResponse)object2).getChallenge();
        try {
            object = MessageDigest.getInstance("MD5");
            if (object2 != null) {
                ((MessageDigest)object).update(((String)object2).getBytes());
            }
            if (this.password != null) {
                ((MessageDigest)object).update(this.password.getBytes());
            }
            object2 = ManagerUtil.toHexString(((MessageDigest)object).digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to create login key using MD5 Message Digest", noSuchAlgorithmException);
        }
        object2 = new LoginAction(this.username, "MD5", (String)object2, string);
        try {
            object2 = this.sendAction((ManagerAction)object2);
        }
        catch (Exception exception) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send login action", exception);
        }
        if (object2 instanceof ManagerError) {
            this.disconnect();
            throw new AuthenticationFailedException(((ManagerResponse)object2).getMessage());
        }
        this.logger.info("Successfully logged in");
        this.version = this.determineVersion();
        this.state = ManagerConnectionState.CONNECTED;
        this.writer.setTargetVersion(this.version);
        this.logger.info("Determined Asterisk version: " + this.version);
        object = new ConnectEvent(this);
        ((ConnectEvent)object).setProtocolIdentifier(this.getProtocolIdentifier());
        ((ManagerEvent)object).setDateReceived(DateUtil.getDate());
        this.fireEvent((ManagerEvent)object);
    }

    protected AsteriskVersion determineVersion() {
        Object object;
        int n2 = 0;
        while (n2++ < 4 && (object = this.sendAction((ManagerAction)new CommandAction("show version files pbx.c"), this.defaultResponseTimeout << 1)) instanceof CommandResponse) {
            if ((object = ((CommandResponse)object).getResult()) == null || object.size() <= 0) continue;
            if ((object = (String)object.get(0)) != null && ((String)object).startsWith("File")) {
                object = this.getRawVersion();
                if (object != null && ((String)object).startsWith("Asterisk 1.4")) {
                    return AsteriskVersion.ASTERISK_1_4;
                }
                return AsteriskVersion.ASTERISK_1_2;
            }
            if (object == null || !((String)object).contains("No such command")) break;
            object = this.sendAction((ManagerAction)new CommandAction("core show version"), this.defaultResponseTimeout << 1);
            if (object != null && object instanceof CommandResponse && (object = ((CommandResponse)object).getResult()) != null && object.size() > 0 && (object = object.get(0)) != null) {
                if (VERSION_PATTERN_1_6.matcher((CharSequence)object).matches()) {
                    return AsteriskVersion.ASTERISK_1_6;
                }
                if (VERSION_PATTERN_1_8.matcher((CharSequence)object).matches()) {
                    return AsteriskVersion.ASTERISK_1_8;
                }
                if (VERSION_PATTERN_10.matcher((CharSequence)object).matches()) {
                    return AsteriskVersion.ASTERISK_10;
                }
                if (VERSION_PATTERN_11.matcher((CharSequence)object).matches()) {
                    return AsteriskVersion.ASTERISK_11;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return AsteriskVersion.ASTERISK_1_6;
    }

    protected String getRawVersion() {
        Object object;
        try {
            object = this.sendAction((ManagerAction)new CommandAction("show version"), this.defaultResponseTimeout << 1);
        }
        catch (Exception exception) {
            return null;
        }
        if (object instanceof CommandResponse && (object = ((CommandResponse)object).getResult()) != null && object.size() > 0) {
            return (String)object.get(0);
        }
        return null;
    }

    protected synchronized void connect() {
        this.logger.info("Connecting to " + this.hostname + ":" + this.port);
        if (this.reader == null) {
            this.logger.debug("Creating reader for " + this.hostname + ":" + this.port);
            ManagerConnectionImpl managerConnectionImpl = this;
            this.reader = this.createReader(managerConnectionImpl, managerConnectionImpl);
        }
        if (this.writer == null) {
            this.logger.debug("Creating writer");
            this.writer = this.createWriter();
        }
        this.logger.debug("Creating socket");
        this.socket = this.createSocket();
        this.logger.debug("Passing socket to reader");
        this.reader.setSocket(this.socket);
        if (this.readerThread == null || !this.readerThread.isAlive() || this.reader.isDead()) {
            this.logger.debug("Creating and starting reader thread");
            this.readerThread = new Thread(this.reader);
            this.readerThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reader-" + this.readerThreadCounter.getAndIncrement());
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }
        this.logger.debug("Passing socket to writer");
        this.writer.setSocket(this.socket);
    }

    protected SocketConnectionFacade createSocket() {
        return new SocketConnectionFacadeImpl(this.hostname, this.port, this.ssl, this.socketTimeout, this.socketReadTimeout);
    }

    @Override
    public synchronized void logoff() {
        if (this.state != ManagerConnectionState.CONNECTED && this.state != ManagerConnectionState.RECONNECTING) {
            throw new IllegalStateException("Logoff may only be perfomed when in state CONNECTED or RECONNECTING, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.DISCONNECTING;
        if (this.socket != null) {
            try {
                this.sendAction(new LogoffAction());
            }
            catch (Exception exception) {
                this.logger.warn("Unable to send LogOff action", exception);
            }
        }
        this.cleanup();
        this.state = ManagerConnectionState.DISCONNECTED;
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            this.logger.info("Closing socket.");
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.logger.warn("Unable to close socket: " + iOException.getMessage());
            }
            this.socket = null;
        }
        this.protocolIdentifier.value = null;
    }

    @Override
    public ManagerResponse sendAction(ManagerAction managerAction) {
        return this.sendAction(managerAction, this.defaultResponseTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagerResponse sendAction(ManagerAction managerAction, long l2) {
        ManagerConnectionImpl$ResponseHandlerResult managerConnectionImpl$ResponseHandlerResult = new ManagerConnectionImpl$ResponseHandlerResult();
        ManagerConnectionImpl$DefaultSendActionCallback managerConnectionImpl$DefaultSendActionCallback = new ManagerConnectionImpl$DefaultSendActionCallback(managerConnectionImpl$ResponseHandlerResult);
        ManagerConnectionImpl$ResponseHandlerResult managerConnectionImpl$ResponseHandlerResult2 = managerConnectionImpl$ResponseHandlerResult;
        synchronized (managerConnectionImpl$ResponseHandlerResult2) {
            this.sendAction(managerAction, managerConnectionImpl$DefaultSendActionCallback);
            if (managerAction instanceof UserEventAction) {
                return null;
            }
            if (managerConnectionImpl$ResponseHandlerResult.getResponse() == null) {
                try {
                    managerConnectionImpl$ResponseHandlerResult.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.warn("Interrupted while waiting for result");
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (managerConnectionImpl$ResponseHandlerResult.getResponse() == null) {
            throw new TimeoutException("Timeout waiting for response to " + managerAction.getAction() + (managerAction.getActionId() == null ? "" : " (actionId: " + managerAction.getActionId() + ")"));
        }
        return managerConnectionImpl$ResponseHandlerResult.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAction(ManagerAction managerAction, SendActionCallback sendActionCallback) {
        Object object;
        if (managerAction == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (!((this.state == ManagerConnectionState.CONNECTING || this.state == ManagerConnectionState.RECONNECTING) && (managerAction instanceof ChallengeAction || managerAction instanceof LoginAction || this.isShowVersionCommandAction(managerAction)) || this.state == ManagerConnectionState.DISCONNECTING && managerAction instanceof LogoffAction || this.state == ManagerConnectionState.CONNECTED)) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send " + managerAction.getAction() + " action: socket not connected.");
        }
        String string = this.createInternalActionId();
        if (sendActionCallback != null) {
            object = this.responseListeners;
            synchronized (object) {
                this.responseListeners.put(string, sendActionCallback);
            }
        }
        if ((object = this.getExpectedResponseClass(managerAction.getClass())) != null) {
            this.reader.expectResponseClass(string, (Class<? extends ManagerResponse>)object);
        }
        this.writer.sendAction(managerAction, string);
    }

    boolean isShowVersionCommandAction(ManagerAction managerAction) {
        if (!(managerAction instanceof CommandAction)) {
            return false;
        }
        return SHOW_VERSION_PATTERN.matcher(((CommandAction)managerAction).getCommand()).matches();
    }

    private Class<? extends ManagerResponse> getExpectedResponseClass(Class<? extends ManagerAction> object) {
        if ((object = ((Class)object).getAnnotation(ExpectedResponse.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction eventGeneratingAction) {
        return this.sendEventGeneratingAction(eventGeneratingAction, this.defaultEventTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction eventGeneratingAction, long l2) {
        Map<String, Object> map;
        if (eventGeneratingAction == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (eventGeneratingAction.getActionCompleteEventClass() == null) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass for " + eventGeneratingAction.getClass().getName() + " is null.");
        }
        if (!ResponseEvent.class.isAssignableFrom(eventGeneratingAction.getActionCompleteEventClass())) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass (" + eventGeneratingAction.getActionCompleteEventClass().getName() + ") for " + eventGeneratingAction.getClass().getName() + " is not a ResponseEvent.");
        }
        if (this.state != ManagerConnectionState.CONNECTED) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED but connection is in state " + (Object)((Object)this.state));
        }
        ResponseEventsImpl responseEventsImpl = new ResponseEventsImpl();
        ManagerConnectionImpl$ResponseEventHandler managerConnectionImpl$ResponseEventHandler = new ManagerConnectionImpl$ResponseEventHandler(responseEventsImpl, eventGeneratingAction.getActionCompleteEventClass());
        String string = this.createInternalActionId();
        try {
            map = this.responseListeners;
            synchronized (map) {
                this.responseListeners.put(string, managerConnectionImpl$ResponseEventHandler);
            }
            map = this.responseEventListeners;
            synchronized (map) {
                this.responseEventListeners.put(string, managerConnectionImpl$ResponseEventHandler);
            }
            map = responseEventsImpl;
            synchronized (map) {
                this.writer.sendAction(eventGeneratingAction, string);
                if (responseEventsImpl.getResponse() == null || !responseEventsImpl.isComplete()) {
                    try {
                        responseEventsImpl.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.warn("Interrupted while waiting for response events.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (responseEventsImpl.getResponse() == null || !responseEventsImpl.isComplete()) {
                throw new EventTimeoutException("Timeout waiting for response or response events to " + eventGeneratingAction.getAction() + (eventGeneratingAction.getActionId() == null ? "" : " (actionId: " + eventGeneratingAction.getActionId() + ")"), responseEventsImpl);
            }
        }
        finally {
            map = this.responseEventListeners;
            synchronized (map) {
                this.responseEventListeners.remove(string);
            }
            map = this.responseListeners;
            synchronized (map) {
                this.responseListeners.remove(string);
            }
        }
        return responseEventsImpl;
    }

    private String createInternalActionId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hashCode());
        stringBuffer.append("_");
        stringBuffer.append(this.actionIdCounter.getAndIncrement());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(ManagerEventListener managerEventListener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (!this.eventListeners.contains(managerEventListener)) {
                this.eventListeners.add(managerEventListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(ManagerEventListener managerEventListener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (this.eventListeners.contains(managerEventListener)) {
                this.eventListeners.remove(managerEventListener);
            }
            return;
        }
    }

    @Override
    public String getProtocolIdentifier() {
        return this.protocolIdentifier.value;
    }

    @Override
    public ManagerConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchResponse(ManagerResponse managerResponse) {
        if (managerResponse == null) {
            this.logger.error("Unable to dispatch null response. This should never happen. Please file a bug.");
            return;
        }
        Object object = managerResponse.getActionId();
        String string = null;
        SendActionCallback sendActionCallback = null;
        if (object != null) {
            string = ManagerUtil.getInternalActionId((String)object);
            managerResponse.setActionId(ManagerUtil.stripInternalActionId((String)object));
        }
        this.logger.debug("Dispatching response with internalActionId '" + string + "':\n" + managerResponse);
        if (string != null) {
            object = this.responseListeners;
            synchronized (object) {
                sendActionCallback = this.responseListeners.get(string);
                if (sendActionCallback != null) {
                    this.responseListeners.remove(string);
                } else {
                    this.logger.debug("No response listener registered for internalActionId '" + string + "'");
                }
            }
        } else {
            this.logger.error("Unable to retrieve internalActionId from response: actionId '" + (String)object + "':\n" + managerResponse);
        }
        if (sendActionCallback != null) {
            try {
                sendActionCallback.onResponse(managerResponse);
                return;
            }
            catch (Exception exception) {
                this.logger.warn("Unexpected exception in response listener " + sendActionCallback.getClass().getName(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(ManagerEvent managerEvent) {
        Object object;
        if (managerEvent == null) {
            this.logger.error("Unable to dispatch null event. This should never happen. Please file a bug.");
            return;
        }
        this.logger.debug("Dispatching event:\n" + managerEvent.toString());
        if (managerEvent instanceof ResponseEvent && (object = ((ResponseEvent)managerEvent).getInternalActionId()) != null) {
            Map<String, ManagerEventListener> map = this.responseEventListeners;
            synchronized (map) {
                object = this.responseEventListeners.get(object);
                if (object != null) {
                    try {
                        object.onManagerEvent(managerEvent);
                    }
                    catch (Exception exception) {
                        this.logger.warn("Unexpected exception in response event listener " + object.getClass().getName(), exception);
                    }
                }
            }
        }
        if (managerEvent instanceof DisconnectEvent) {
            if (this.state == ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.RECONNECTING;
                this.cleanup();
                object = new Thread(new ManagerConnectionImpl$1(this));
                ((Thread)object).setName("Asterisk-Java ManagerConnection-" + this.id + "-Reconnect-" + this.reconnectThreadCounter.getAndIncrement());
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
            } else {
                return;
            }
        }
        if (managerEvent instanceof ProtocolIdentifierReceivedEvent) {
            object = ((ProtocolIdentifierReceivedEvent)managerEvent).getProtocolIdentifier();
            this.setProtocolIdentifier((String)object);
            return;
        }
        this.fireEvent(managerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ManagerEvent managerEvent) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            for (ManagerEventListener managerEventListener : this.eventListeners) {
                try {
                    managerEventListener.onManagerEvent(managerEvent);
                }
                catch (RuntimeException runtimeException) {
                    this.logger.warn("Unexpected exception in eventHandler " + managerEventListener.getClass().getName(), runtimeException);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProtocolIdentifier(String string) {
        this.logger.info("Connected via ".concat(String.valueOf(string)));
        if (!("Asterisk Call Manager/1.0".equals(string) || "Asterisk Call Manager/1.1".equals(string) || "Asterisk Call Manager/1.2".equals(string) || "Asterisk Call Manager/1.3".equals(string) || "OpenPBX Call Manager/1.0".equals(string) || "CallWeaver Call Manager/1.0".equals(string) || string != null && string.startsWith("Asterisk Call Manager Proxy/"))) {
            this.logger.warn("Unsupported protocol version '" + string + "'. Use at your own risk.");
        }
        ManagerConnectionImpl$ProtocolIdentifierWrapper managerConnectionImpl$ProtocolIdentifierWrapper = this.protocolIdentifier;
        synchronized (managerConnectionImpl$ProtocolIdentifierWrapper) {
            this.protocolIdentifier.value = string;
            this.protocolIdentifier.notifyAll();
            return;
        }
    }

    private void reconnect() {
        int n2 = 0;
        while (this.state == ManagerConnectionState.RECONNECTING) {
            try {
                if (n2 < 10) {
                    Thread.sleep(50L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                this.connect();
                try {
                    ManagerConnectionImpl managerConnectionImpl = this;
                    managerConnectionImpl.doLogin(managerConnectionImpl.defaultResponseTimeout, this.eventMask);
                    this.logger.info("Successfully reconnected.");
                    return;
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    if (this.keepAliveAfterAuthenticationFailure) {
                        this.logger.error("Unable to log in after reconnect: " + authenticationFailedException.getMessage());
                    } else {
                        this.logger.error("Unable to log in after reconnect: " + authenticationFailedException.getMessage() + ". Giving up.");
                        this.state = ManagerConnectionState.DISCONNECTED;
                    }
                }
                catch (TimeoutException timeoutException) {
                    this.logger.error("TimeoutException while trying to log in after reconnect.");
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                String string = iOException.getClass().getSimpleName();
                if (iOException2.getMessage() != null) {
                    string = iOException2.getMessage();
                }
                this.logger.warn("Exception while trying to reconnect: ".concat(String.valueOf(string)));
            }
            ++n2;
        }
    }

    private void cleanup() {
        this.disconnect();
        this.readerThread = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ManagerConnection[");
        stringBuffer.append("id='").append(this.id).append("',");
        stringBuffer.append("hostname='").append(this.hostname).append("',");
        stringBuffer.append("port=").append(this.port).append(",");
        stringBuffer.append("systemHashcode=").append(System.identityHashCode(this)).append("]");
        return stringBuffer.toString();
    }

    static /* synthetic */ void access$100(ManagerConnectionImpl managerConnectionImpl) {
        managerConnectionImpl.reconnect();
    }
}

