/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.tools;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asteriskjava.live.DefaultAsteriskServer;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.AbstractParkedCallEvent;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.HoldEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.tools.HtmlEventTracer$1;

public class HtmlEventTracer
implements ManagerEventListener {
    private String filename = "trace.html";
    private PrintWriter writer;
    private final List<String> uniqueIds = new ArrayList<String>();
    private final List<ManagerEvent> events = new ArrayList<ManagerEvent>();
    private final Map<Class<? extends ManagerEvent>, String> colors = new HashMap<Class<? extends ManagerEvent>, String>();

    public HtmlEventTracer() {
        this.colors.put(NewChannelEvent.class, "#7cd300");
        this.colors.put(NewStateEvent.class, "#a4b6c8");
        this.colors.put(NewExtenEvent.class, "#efefef");
        this.colors.put(RenameEvent.class, "#ddeeff");
        this.colors.put(DialEvent.class, "#feec30");
        this.colors.put(BridgeEvent.class, "#fff8ae");
        this.colors.put(HangupEvent.class, "#ff6c17");
        try {
            this.writer = new PrintWriter(this.filename);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public static void main(String[] object) {
        if (((String[])object).length != 3) {
            System.err.println("Usage: java org.asteriskjava.tools.HtmlEventTracer host username password");
            System.exit(1);
        }
        HtmlEventTracer htmlEventTracer = new HtmlEventTracer();
        object = new DefaultAsteriskServer(object[0], object[1], object[2]);
        ((DefaultAsteriskServer)object).initialize();
        ((DefaultAsteriskServer)object).getManagerConnection().addEventListener(htmlEventTracer);
        System.err.println("Event tracer successfully started. Press Ctrl-C to write trace file and exit.");
        Runtime.getRuntime().addShutdownHook(new HtmlEventTracer$1(htmlEventTracer, (DefaultAsteriskServer)object));
        while (true) {
            Thread.sleep(1000L);
        }
    }

    @Override
    public void onManagerEvent(ManagerEvent managerEvent) {
        this.events.add(managerEvent);
        System.out.println("> ".concat(String.valueOf(managerEvent)));
        String[] stringArray = new String[]{"uniqueId", "uniqueId1", "uniqueId2", "srcUniqueId", "destUniqueId"};
        for (int i2 = 0; i2 < 5; ++i2) {
            String string = stringArray[i2];
            if ((string = this.getProperty(managerEvent, string)) == null || this.uniqueIds.contains(string)) continue;
            this.uniqueIds.add(string);
        }
    }

    public void write() {
        this.writer.append("<table border='1'><tr><td> </td>");
        for (String object : this.uniqueIds) {
            this.writer.append("<td><font size='-2'>");
            this.writer.append(object.substring(0, object.lastIndexOf(46) + 1));
            this.writer.append("</font>");
            String string = object;
            this.writer.append(string.substring(string.lastIndexOf(46) + 1, object.length()));
            this.writer.append("</td>");
        }
        this.writer.append("</tr>");
        this.writer.println("");
        for (ManagerEvent managerEvent : this.events) {
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<tr><td>");
            stringBuilder.append(managerEvent.getClass().getSimpleName());
            stringBuilder.append("<br><font size='-2'>");
            stringBuilder.append(managerEvent.getDateReceived());
            stringBuilder.append("</font></td>");
            for (String string : this.uniqueIds) {
                if ((string = this.getText(string, managerEvent)) == null) {
                    stringBuilder.append("<td> </td>");
                    continue;
                }
                String string2 = this.getColor(managerEvent.getClass());
                stringBuilder.append("<td bgcolor='").append(string2).append("'><tt>").append(string).append("</tt></td>");
                bl2 = true;
            }
            stringBuilder.append("</tr>");
            if (!bl2) continue;
            this.writer.println(stringBuilder.toString());
        }
        this.writer.append("</table>");
        this.writer.close();
        System.err.println("Trace file successfully written to " + this.filename + ".");
    }

    private String getColor(Class<? extends ManagerEvent> clazz) {
        for (Map.Entry<Class<? extends ManagerEvent>, String> entry : this.colors.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return "#ffffff";
    }

    protected String getProperty(Object object, String string) {
        try {
            Object object2 = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            int n2 = ((PropertyDescriptor[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                PropertyDescriptor propertyDescriptor = object2[i2];
                if (!propertyDescriptor.getName().equals(string)) continue;
                object2 = propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
                if (object2 != null) {
                    return object2.toString();
                }
                return null;
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to read property '" + string + "' from object " + object + ": " + exception.getMessage());
            return null;
        }
        return null;
    }

    protected String getText(String stringArray, ManagerEvent managerEvent) {
        String string = null;
        String[] stringArray2 = null;
        if (stringArray.equals(this.getProperty(managerEvent, "uniqueId"))) {
            if (managerEvent instanceof NewChannelEvent) {
                string = "%s<br>%s";
                stringArray2 = new String[]{"channel", "state"};
            } else if (managerEvent instanceof NewStateEvent) {
                string = "%s<br>%s";
                stringArray2 = new String[]{"channel", "state"};
            } else if (managerEvent instanceof NewExtenEvent) {
                string = "%s,%s,%s<br>%s(%s)";
                stringArray2 = new String[]{"context", "extension", "priority", "application", "appData"};
            } else if (managerEvent instanceof RenameEvent) {
                string = "old: %s<br>new: %s";
                stringArray2 = new String[]{"oldname", "newname"};
            } else if (managerEvent instanceof HoldEvent) {
                string = "%s";
                stringArray2 = new String[]{"status"};
            } else if (managerEvent instanceof AbstractParkedCallEvent) {
                string = "exten: %s<br>from: %s";
                stringArray2 = new String[]{"exten", "from"};
            } else if (managerEvent instanceof HangupEvent) {
                string = "%s<br>%s (%s)";
                stringArray2 = new String[]{"channel", "cause", "causeTxt"};
            }
        }
        if (managerEvent instanceof BridgeEvent) {
            if (stringArray.equals(this.getProperty(managerEvent, "uniqueId1"))) {
                string = "%s<br>%s<br>%s";
                stringArray2 = new String[]{"uniqueId2", "channel2", "bridgeState"};
            } else if (stringArray.equals(this.getProperty(managerEvent, "uniqueId2"))) {
                string = "%s<br>%s<br>%s";
                stringArray2 = new String[]{"uniqueId1", "channel1", "bridgeState"};
            }
        }
        if (managerEvent instanceof DialEvent) {
            if (stringArray.equals(this.getProperty(managerEvent, "srcUniqueId"))) {
                string = "To: %s";
                stringArray2 = new String[]{"destination"};
            } else if (stringArray.equals(this.getProperty(managerEvent, "destUniqueId"))) {
                string = "From: %s";
                stringArray2 = new String[]{"src"};
            }
        }
        if (string != null && stringArray2 != null) {
            stringArray = new String[stringArray2.length];
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                String string2 = this.getProperty(managerEvent, stringArray2[i2]);
                stringArray[i2] = string2 == null ? "" : (string2 = string2.replace("<", "&lt;").replace(">", "&gt;"));
            }
            return String.format(string, stringArray);
        }
        return null;
    }
}

