/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.internal.Trace;

public class FileTrace
implements Trace {
    public static final String TRACE_DIRECTORY_PROPERTY = "org.asteriskjava.trace.directory";
    protected static final String FILE_PREFIX = "aj-trace";
    protected static final String FILE_SUFFIX = ".txt";
    private final Log logger = LogFactory.getLog(FileTrace.class);
    private final DateFormat df = new SimpleDateFormat("yyyyMMddHHmmsszzz");
    private Charset charset = Charset.forName("UTF-8");
    private FileChannel channel;
    private boolean exceptionLogged = false;
    private RandomAccessFile randomAccessFile;

    public FileTrace(Socket socket) {
        this.randomAccessFile = new RandomAccessFile(this.getFile(socket), "rw");
        this.channel = this.randomAccessFile.getChannel();
        FileTrace fileTrace = this;
        fileTrace.print(fileTrace.getHeader(socket));
    }

    private String getHeader(Socket socket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Local:  ");
        stringBuilder.append(socket.getLocalAddress());
        stringBuilder.append(":");
        stringBuilder.append(socket.getLocalPort());
        stringBuilder.append("\n");
        stringBuilder.append("Remote: ");
        stringBuilder.append(socket.getInetAddress());
        stringBuilder.append(":");
        stringBuilder.append(socket.getPort());
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private File getFile(Socket object) {
        String string = System.getProperty(TRACE_DIRECTORY_PROPERTY, System.getProperty("java.io.tmpdir"));
        object = this.getFileName((Socket)object);
        this.logger.info("Writing trace to " + string + File.separator + (String)object);
        return new File(string, (String)object);
    }

    private String getFileName(Socket socket) {
        StringBuilder stringBuilder = new StringBuilder(FILE_PREFIX);
        stringBuilder.append("_");
        stringBuilder.append(this.df.format(new Date()));
        stringBuilder.append("_");
        stringBuilder.append(socket.getLocalAddress().getHostAddress());
        stringBuilder.append("_");
        stringBuilder.append(socket.getLocalPort());
        stringBuilder.append("_");
        stringBuilder.append(socket.getInetAddress().getHostAddress());
        stringBuilder.append("_");
        stringBuilder.append(socket.getPort());
        stringBuilder.append(FILE_SUFFIX);
        return stringBuilder.toString();
    }

    @Override
    public synchronized void received(String string) {
        try {
            FileTrace fileTrace = this;
            fileTrace.print(fileTrace.format("<<< ", string));
            return;
        }
        catch (IOException iOException) {
            this.logException(iOException);
            return;
        }
    }

    @Override
    public synchronized void sent(String string) {
        try {
            FileTrace fileTrace = this;
            fileTrace.print(fileTrace.format(">>> ", string));
            return;
        }
        catch (IOException iOException) {
            this.logException(iOException);
            return;
        }
    }

    private void logException(IOException iOException) {
        if (this.exceptionLogged) {
            return;
        }
        this.logger.warn("Unable to write trace to disk", iOException);
        this.exceptionLogged = true;
    }

    protected String format(String string, String stringArray) {
        StringBuilder stringBuilder = new StringBuilder(this.df.format(new Date()));
        String string2 = String.format("%" + stringBuilder.length() + "s", "");
        stringArray = stringArray.split("\n");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(" ");
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i2]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected void print(String string) {
        CharBuffer charBuffer = CharBuffer.allocate(string.length());
        charBuffer.put(string);
        charBuffer.flip();
        FileTrace fileTrace = this;
        fileTrace.print(fileTrace.charset.encode(charBuffer));
    }

    private void print(ByteBuffer byteBuffer) {
        int n2 = 0;
        while (n2 < byteBuffer.remaining()) {
            n2 = this.channel.write(byteBuffer);
            if (n2 != 0) continue;
            throw new IOException("Unable to write trace to channel. Media may be full.");
        }
    }

    @Override
    public void close() {
        try {
            this.randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            this.logException(iOException);
            return;
        }
    }
}

