/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.tigris.gef.util.Localizer;
import org.tigris.gef.util.ResourceLoader;

public abstract class Cmd
extends AbstractAction
implements Serializable {
    protected Hashtable _args;
    protected String _resource;
    private static Vector _registeredCmds = new Vector();

    public Cmd(Hashtable hashtable, String string, String object) {
        super(Localizer.localize(string, (String)object));
        String string2 = object;
        object = ResourceLoader.lookupIconResource(string2, string2);
        if (object != null) {
            this.putValue("SmallIcon", object);
        }
        this._args = hashtable;
        this._resource = string;
    }

    public Cmd(String string, String string2) {
        this(null, string, string2);
    }

    public Cmd(Hashtable hashtable, String string, String string2, ImageIcon imageIcon) {
        super(Localizer.localize(string, string2), imageIcon);
        this._args = hashtable;
        this._resource = string;
    }

    protected Cmd(String string) {
        this(null, "GefBase", string);
    }

    protected Cmd(Hashtable hashtable, String string, ImageIcon imageIcon) {
        this(hashtable, "GefBase", string, imageIcon);
    }

    protected Cmd(Hashtable hashtable, String string) {
        this(hashtable, "GefBase", string);
    }

    public void updateEnabled() {
        Cmd cmd = this;
        cmd.setEnabled(cmd.shouldBeEnabled());
    }

    public boolean shouldBeEnabled() {
        return true;
    }

    public void setResource(String string) {
        this._resource = string;
    }

    public String getResource() {
        return this._resource;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setName(String string) {
        this.putValue("Name", Localizer.localize(this._resource, string));
    }

    protected Object getArg(String string) {
        if (this._args == null) {
            return null;
        }
        return this._args.get(string);
    }

    protected Object getArg(String string, Object object) {
        if (this._args == null) {
            return object;
        }
        if ((string = this._args.get(string)) == null) {
            return object;
        }
        return string;
    }

    protected void setArg(String string, Object object) {
        if (this._args == null) {
            this._args = new Hashtable();
        }
        this._args.put(string, object);
    }

    protected boolean containsArg(String string) {
        return this._args != null && this._args.containsKey(string);
    }

    public String about() {
        return "http://gef.tigris.org" + this.getClass().getName();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.doIt();
    }

    public abstract void doIt();

    public abstract void undoIt();

    public static Enumeration registeredCmds() {
        return _registeredCmds.elements();
    }

    public static void register(Cmd cmd) {
        _registeredCmds.addElement(cmd);
    }

    public static Cmd cmdAtIndex(int n2) {
        return (Cmd)_registeredCmds.elementAt(n2);
    }
}

