/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdDistribute
extends Cmd {
    private static final long serialVersionUID = 196913544124639762L;
    public static final int H_SPACING = 0;
    public static final int H_CENTERS = 1;
    public static final int H_PACK = 2;
    public static final int V_SPACING = 4;
    public static final int V_CENTERS = 5;
    public static final int V_PACK = 6;
    protected int _request;
    protected Rectangle _bbox = null;

    public CmdDistribute(int n2) {
        super("Distribute" + CmdDistribute.wordFor(n2));
        this._request = n2;
    }

    protected static String wordFor(int n2) {
        switch (n2) {
            case 0: {
                return "HorizontalSpacing";
            }
            case 1: {
                return "HorizontalCenters";
            }
            case 2: {
                return "Leftward";
            }
            case 4: {
                return "VerticalSpacing";
            }
            case 5: {
                return "VerticalCenters";
            }
            case 6: {
                return "Upward";
            }
        }
        return "";
    }

    @Override
    public void doIt() {
        int n2;
        KeyListener keyListener = Globals.curEditor();
        Vector<Fig> vector = (Vector<Fig>)this.getArg("figs");
        Integer n3 = (Integer)this.getArg("gap");
        int n4 = 8;
        if (n3 != null) {
            n4 = n3;
        }
        this._bbox = (Rectangle)this.getArg("bbox");
        if (vector == null) {
            if (((SelectionManager)(keyListener = ((Editor)keyListener).getSelectionManager())).getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            vector = ((SelectionManager)keyListener).getFigs();
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = vector.size();
        if (n9 == 0) {
            return;
        }
        Fig fig = vector.elementAt(0);
        if (this._bbox == null) {
            this._bbox = fig.getBounds();
            n5 = this._bbox.x + this._bbox.width / 2;
            n6 = this._bbox.x + this._bbox.width / 2;
            n7 = this._bbox.y + this._bbox.height / 2;
            n8 = this._bbox.y + this._bbox.height / 2;
            for (n2 = 1; n2 < n9; ++n2) {
                Rectangle rectangle = vector.elementAt(n2).getBounds();
                this._bbox.add(rectangle);
                n5 = Math.min(n5, rectangle.x + rectangle.width / 2);
                n6 = Math.max(n6, rectangle.x + rectangle.width / 2);
                n7 = Math.min(n7, rectangle.y + rectangle.height / 2);
                n8 = Math.max(n8, rectangle.y + rectangle.height / 2);
            }
        }
        n2 = 0;
        int n10 = 0;
        for (int i2 = 0; i2 < n9; ++i2) {
            fig = vector.elementAt(i2);
            n2 += fig.getWidth();
            n10 += fig.getHeight();
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this._request) {
            case 0: {
                f4 = this._bbox.x;
                f2 = (this._bbox.width - n2) / Math.max(n9 - 1, 1);
                break;
            }
            case 1: {
                f4 = n5;
                f3 = (n6 - n5) / Math.max(n9 - 1, 1);
                break;
            }
            case 2: {
                f4 = this._bbox.x;
                f2 = n4;
                break;
            }
            case 4: {
                f5 = this._bbox.y;
                f2 = (this._bbox.height - n10) / Math.max(n9 - 1, 1);
                break;
            }
            case 5: {
                f5 = n7;
                f3 = (n8 - n7) / Math.max(n9 - 1, 1);
                break;
            }
            case 6: {
                f5 = this._bbox.y;
                f2 = n4;
            }
        }
        for (n5 = 0; n5 < n9; ++n5) {
            for (n6 = n5 + 1; n6 < n9; ++n6) {
                Fig fig2 = vector.elementAt(n5);
                Fig fig3 = vector.elementAt(n6);
                if (this._request == 0 || this._request == 1 || this._request == 2) {
                    if (fig2.getX() <= fig3.getX()) continue;
                    this.swap(vector, n5, n6);
                    continue;
                }
                if (fig2.getY() <= fig3.getY()) continue;
                this.swap(vector, n5, n6);
            }
        }
        for (n5 = 0; n5 < n9; ++n5) {
            fig = vector.elementAt(n5);
            switch (this._request) {
                case 0: 
                case 2: {
                    fig.setLocation((int)f4, fig.getY());
                    f4 += (float)fig.getWidth() + f2;
                    break;
                }
                case 1: {
                    fig.setLocation((int)f4 - fig.getWidth() / 2, fig.getY());
                    f4 += f3;
                    break;
                }
                case 4: 
                case 6: {
                    Fig fig4 = fig;
                    fig4.setLocation(fig4.getX(), (int)f5);
                    f5 += (float)fig.getHeight() + f2;
                    break;
                }
                case 5: {
                    Fig fig5 = fig;
                    fig5.setLocation(fig5.getX(), (int)f5 - fig.getHeight() / 2);
                    f5 += f3;
                }
            }
            fig.endTrans();
        }
    }

    @Override
    public void undoIt() {
    }

    protected void swap(Vector vector, int n2, int n3) {
        Object e2 = vector.elementAt(n2);
        Vector vector2 = vector;
        vector2.setElementAt(vector2.elementAt(n3), n2);
        vector.setElementAt(e2, n3);
    }

    public Rectangle getLastBBox() {
        return this._bbox;
    }
}

