/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

public class CmdPrint
extends Cmd
implements Printable {
    private static final long serialVersionUID = 5930094057682454011L;
    PrinterJob printerJob;
    PageFormat pageFormat;
    int maxPageIndex = 1;
    boolean fitDiagramToPage = true;
    boolean isFirstPrintCall = true;
    double scale;
    int nCol;
    double pageX;
    double pageY;
    double pageWidth;
    double pageHeight;
    double diagramX;
    double diagramY;
    double diagramWidth;
    double diagramHeight;

    public CmdPrint() {
        super("Print");
    }

    public CmdPrint(String string) {
        this();
        this.setDiagramName(string);
    }

    public void setDiagramName(String string) {
        this.setArg("diagramName", string);
    }

    public void setPrintPageNumbers(boolean bl2) {
        this.setArg("printPageNumbers", bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void doIt() {
        PrinterJob printerJob = this.getPrinterJob();
        printerJob.setPrintable(new CmdPrint(), this.getPageFormat());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Globals.showStatus("Error got a Printer exception");
            }
        }
        Globals.showStatus("Printing finished");
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdPrint");
    }

    private boolean isFirstPrintCall() {
        return this.isFirstPrintCall;
    }

    private void setFirstPrintCall(boolean bl2) {
        this.isFirstPrintCall = bl2;
    }

    private boolean fitDiagramToPage() {
        return this.fitDiagramToPage;
    }

    private void setFitDiagramToPage(boolean bl2) {
        this.fitDiagramToPage = bl2;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n2) {
        if (n2 >= this.maxPageIndex) {
            return 1;
        }
        Editor editor = Globals.curEditor();
        graphics = (Graphics2D)graphics;
        Rectangle rectangle = null;
        Object object = editor.getSelectionManager().getFigs();
        if (((Vector)object).size() > 0) {
            object = ((Vector)object).iterator();
        } else {
            object = editor.getFigs().iterator();
            rectangle = new Rectangle();
        }
        while (object.hasNext()) {
            Rectangle rectangle2 = object.next().getBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(rectangle2);
            }
            rectangle.add(rectangle2);
        }
        if (rectangle == null || rectangle.width == 0 || rectangle.height == 0) {
            return 1;
        }
        boolean bl2 = editor.getGridHidden();
        editor.setGridHidden(true);
        if (this.isFirstPrintCall()) {
            this.setFirstPrintCall(false);
            this.pageWidth = pageFormat.getImageableWidth();
            this.pageHeight = pageFormat.getImageableHeight();
            this.pageX = pageFormat.getImageableX();
            this.pageY = pageFormat.getImageableY();
            this.diagramWidth = rectangle.width;
            this.diagramHeight = rectangle.height;
            this.diagramX = rectangle.x;
            this.diagramY = rectangle.y;
            this.scale = Math.min(this.pageWidth / (double)(rectangle.width + 1), this.pageHeight / (double)(rectangle.height + 1));
            if (this.scale < 1.0 && !this.promptFitToPage()) {
                editor.setGridHidden(bl2);
                return 1;
            }
            if (this.fitDiagramToPage()) {
                this.maxPageIndex = 1;
            } else {
                this.nCol = Math.max((int)Math.ceil(this.diagramWidth / this.pageWidth), 1);
                int n3 = Math.max((int)Math.ceil(this.diagramHeight / this.pageHeight), 1);
                this.maxPageIndex = this.nCol * n3;
            }
        }
        if (this.fitDiagramToPage()) {
            if (this.scale < 1.0) {
                ((Graphics2D)graphics).scale(this.scale, this.scale);
                ((Graphics2D)graphics).translate(this.pageX / this.scale - this.diagramX + 1.0, this.pageY / this.scale - this.diagramY + 1.0);
            } else {
                ((Graphics2D)graphics).translate(this.pageX - this.diagramX + 1.0, this.pageY - this.diagramY + 1.0);
            }
        } else {
            double d2 = n2 % this.nCol;
            double d3 = n2 / this.nCol;
            double d4 = d2 * this.pageWidth;
            double d5 = d3 * this.pageHeight;
            ((Graphics2D)graphics).translate(this.pageX - d4 + 1.0, this.pageY - d5 + 1.0);
        }
        graphics.setClip(rectangle);
        editor.print(graphics);
        editor.setGridHidden(bl2);
        return 0;
    }

    PrinterJob getPrinterJob() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        return this.printerJob;
    }

    PageFormat getPageFormat() {
        PrinterJob printerJob;
        if (this.pageFormat == null && (printerJob = this.getPrinterJob()) != null) {
            this.pageFormat = printerJob.defaultPage();
        }
        return this.pageFormat;
    }

    void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public void doPageSetup() {
        CmdPrint cmdPrint = this;
        cmdPrint.setPageFormat(cmdPrint.getPrinterJob().pageDialog(this.getPageFormat()));
    }

    private boolean promptFitToPage() {
        Object[] objectArray = new Object[]{"Fit to page", "Multiple Pages", "Cancel"};
        int n2 = JOptionPane.showOptionDialog(null, "The diagram exceeds the current page size. Select option?", "Print", 1, 3, null, objectArray, objectArray[0]);
        if (n2 == 2) {
            return false;
        }
        if (n2 == 1) {
            this.setFitDiagramToPage(false);
        } else {
            this.setFitDiagramToPage(true);
        }
        return true;
    }
}

