/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerDiagram;

public abstract class CmdSaveGraphics
extends Cmd {
    private static Log LOG = LogFactory.getLog(LayerDiagram.class);
    protected int scale = 1;

    protected abstract void saveGraphics(OutputStream var1, Editor var2, Rectangle var3);

    protected CmdSaveGraphics(String string) {
        super(string);
    }

    public void setStream(OutputStream outputStream) {
        this.setArg("outputStream", outputStream);
    }

    public void setScale(int n2) {
        this.scale = n2;
    }

    @Override
    public void doIt() {
        Editor editor = Globals.curEditor();
        OutputStream outputStream = (OutputStream)this.getArg("outputStream");
        Rectangle rectangle = editor.getLayerManager().getActiveLayer().calcDrawingArea();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Bounding box: ".concat(String.valueOf(rectangle)));
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Graphics generation aborted.");
            }
            return;
        }
        boolean bl2 = editor.getGridHidden();
        editor.setGridHidden(true);
        try {
            this.saveGraphics(outputStream, editor, rectangle);
        }
        catch (IOException iOException) {
            LOG.error((Object)"Error while exporting Graphics:", (Throwable)iOException);
        }
        editor.setGridHidden(bl2);
    }

    @Override
    public void undoIt() {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"Undo does not make sense for CmdSavePS");
        }
    }
}

