/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.graph.GraphController;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.ui.PaletteFig;
import org.tigris.gef.ui.ToolBar;

public class Diagram
implements Serializable,
GraphListener {
    private static final long serialVersionUID = 4847606736320428403L;
    @Deprecated
    protected String _name = "no title set";
    @Deprecated
    protected String _comments = "(no comments given)";
    private LayerPerspective layer;
    @Deprecated
    protected transient ToolBar _toolBar;
    private transient Vector<VetoableChangeListener> vetoListeners;
    private transient PropertyChangeSupport changeSupport;
    private Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();
    public static final String SCALE_KEY = "scale";
    public static final String NAME_KEY = "name";

    public Diagram() {
        this("untitled");
    }

    public Diagram(String string) {
        this(string, new DefaultGraphModel());
    }

    public Diagram(String string, GraphModel graphModel) {
        this(string, graphModel, new LayerPerspective(string, graphModel));
        this.getLayer().setDiagram(this);
    }

    public Diagram(String string, GraphModel graphModel, LayerPerspective layerPerspective) {
        this.changeSupport = new PropertyChangeSupport(this);
        this._name = string;
        this.layer = layerPerspective;
        this.layer.setDiagram(this);
        this.setGraphModel(graphModel);
    }

    protected void initToolBar() {
        this._toolBar = new PaletteFig();
    }

    public void initialize(Object object) {
    }

    public ToolBar getToolBar() {
        if (this._toolBar == null) {
            this.initToolBar();
        }
        return this._toolBar;
    }

    public void setToolBar(ToolBar toolBar) {
        this._toolBar = toolBar;
    }

    public String getComments() {
        return this._comments;
    }

    public void setComments(String string) {
        this.fireVetoableChange("comments", this._comments, string);
        this._comments = string;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this.fireVetoableChange(NAME_KEY, this._name, string);
        String string2 = this._name;
        this._name = string;
        this.changeSupport.firePropertyChange(NAME_KEY, string2, string);
    }

    public void setShowSingleMultiplicity(boolean bl2) {
    }

    public boolean getShowSingleMultiplicity() {
        return false;
    }

    public double getScale() {
        return this.getLayer().getScale();
    }

    public void setScale(double d2) {
        double d3 = this.getScale();
        this.getLayer().setScale(d2);
        this.firePropertyChange(SCALE_KEY, d3, d2);
    }

    public String getClassAndModelID() {
        return this.getClass().getName();
    }

    public GraphModel getGraphModel() {
        return this.getLayer().getGraphModel();
    }

    public void setGraphModel(GraphModel graphModel) {
        GraphModel graphModel2 = this.getLayer().getGraphModel();
        if (graphModel2 != null) {
            graphModel2.removeGraphEventListener(this);
        }
        this.getLayer().setGraphModel(graphModel);
        graphModel.addGraphEventListener(this);
    }

    public GraphController getGraphController() {
        return this.getLayer().getGraphController();
    }

    public LayerPerspective getLayer() {
        return this.layer;
    }

    protected void setLayer(LayerPerspective layerPerspective) {
        if (layerPerspective != null) {
            layerPerspective.setDiagram(this);
        } else if (this.layer != null) {
            this.layer.setDiagram(null);
        }
        this.layer = layerPerspective;
    }

    public int countContained(List list) {
        int n2 = 0;
        int n3 = list.size();
        for (Object object : this.getNodes()) {
            for (int i4 = 0; i4 < n3; ++i4) {
                if (object != list.get(i4)) continue;
                ++n2;
            }
        }
        for (Object e2 : this.getEdges()) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (e2 != list.get(i3)) continue;
                ++n2;
            }
        }
        for (Object object : this.getLayer().getContents()) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (object != list.get(i2)) continue;
                ++n2;
            }
        }
        return n2;
    }

    public List getNodes() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Fig fig : this.getLayer().getContents()) {
            if (!(fig instanceof FigNode)) continue;
            arrayList.add(fig.getOwner());
        }
        return arrayList;
    }

    public List getEdges() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Fig fig : this.getLayer().getContents()) {
            if (!(fig instanceof FigEdge) || fig.getOwner() == null) continue;
            arrayList.add(fig.getOwner());
        }
        return arrayList;
    }

    public void add(Fig fig) {
        this.layer.add(fig);
    }

    public void remove(Fig fig) {
        this.layer.remove(fig);
    }

    public void removeAll(Fig fig) {
        this.layer.removeAll();
    }

    public Enumeration elements() {
        return this.layer.elements();
    }

    public Fig hit(Rectangle rectangle) {
        return this.layer.hit(rectangle);
    }

    public Enumeration elementsIn(Rectangle rectangle) {
        return this.layer.elementsIn(rectangle);
    }

    public Fig presentationFor(Object object) {
        return this.layer.presentationFor(object);
    }

    public List presentationsFor(Object object) {
        return this.layer.presentationsFor(object);
    }

    public void sendToBack(Fig fig) {
        this.layer.sendToBack(fig);
    }

    public void bringForward(Fig fig) {
        this.layer.bringForward(fig);
    }

    public void sendBackward(Fig fig) {
        this.layer.sendBackward(fig);
    }

    public void bringToFront(Fig fig) {
        this.layer.bringToFront(fig);
    }

    public void reorder(Fig fig, int n2) {
        this.layer.reorder(fig, n2);
    }

    @Override
    public void nodeAdded(GraphEvent graphEvent) {
        try {
            this.fireVetoableChange("nodeAdded", null, null);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    @Override
    public void edgeAdded(GraphEvent graphEvent) {
        try {
            this.fireVetoableChange("edgeAdded", null, null);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    @Override
    public void nodeRemoved(GraphEvent graphEvent) {
        try {
            this.fireVetoableChange("nodeRemoved", null, null);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    @Override
    public void edgeRemoved(GraphEvent graphEvent) {
        try {
            this.fireVetoableChange("edgeRemoved", null, null);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    @Override
    public void graphChanged(GraphEvent graphEvent) {
        try {
            this.fireVetoableChange("graphChanged", null, null);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void preSave() {
        this.layer.preSave();
    }

    public void postSave() {
        this.layer.postSave();
    }

    public void postLoad() {
        this.layer.postLoad();
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoListeners == null) {
            this.vetoListeners = new Vector();
        }
        this.vetoListeners.removeElement(vetoableChangeListener);
        this.vetoListeners.addElement(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoListeners == null) {
            return;
        }
        this.vetoListeners.removeElement(vetoableChangeListener);
    }

    public void fireVetoableChange(String string, boolean bl2, boolean bl3) {
        this.fireVetoableChange(string, (Object)bl2, (Object)bl3);
    }

    public void fireVetoableChange(String string, int n2, int n3) {
        this.fireVetoableChange(string, (Object)n2, (Object)n3);
    }

    public void fireVetoableChange(String string, Object object, Object object2) {
        if (this.vetoListeners == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        try {
            for (int i2 = 0; i2 < this.vetoListeners.size(); ++i2) {
                this.vetoListeners.elementAt(i2).vetoableChange(propertyChangeEvent);
            }
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyChangeEvent = new PropertyChangeEvent(this, string, object2, object);
            for (int i3 = 0; i3 < this.vetoListeners.size(); ++i3) {
                try {
                    this.vetoListeners.elementAt(i3).vetoableChange(propertyChangeEvent);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            throw propertyVetoException;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.removePropertyChangeListenerInt(propertyChangeListener);
        this.propertyChangeListeners.remove(propertyChangeListener);
    }

    private void removePropertyChangeListenerInt(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
        this.propertyChangeListeners.remove(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public void remove() {
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
            this.removePropertyChangeListenerInt(propertyChangeListener);
        }
        if (this.vetoListeners != null) {
            this.vetoListeners.clear();
        }
    }
}

