/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.ModeDragScrollFactory;
import org.tigris.gef.base.ModeFactory;
import org.tigris.gef.base.ModePopupFactory;
import org.tigris.gef.base.ModeSelectFactory;
import org.tigris.gef.base.Prefs;
import org.tigris.gef.ui.IStatusBar;

public class Globals {
    public static final String REMOVE = "remove";
    protected static Applet _applet;
    protected static MediaTracker _tracker;
    public static String defaultStatus;
    private static Log LOG;
    public static List clipBoard;
    public static boolean pastable;
    private static String LastDirectory;
    public static boolean ShowFigTips;
    public static IStatusBar _StatusBar;
    protected static Prefs _prefs;
    protected static boolean _sticky;
    private static ModeFactory defaultModeFactory;
    private static List<ModeFactory> defaultModeFactories;
    protected static Mode _mode;
    protected static Editor _curEditor;
    protected static Hashtable _pcListeners;
    protected static PropertyChangeListener universalListener;
    public static int MAX_LISTENERS;

    public static void setApplet(Applet applet) {
        _applet = applet;
        Globals.clearStatus();
        _tracker = new MediaTracker(applet);
    }

    public static AppletContext getAppletContext() {
        try {
            return _applet.getAppletContext();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Applet getApplet() {
        return _applet;
    }

    public static String getLastDirectory() {
        if (LastDirectory == null) {
            LastDirectory = System.getProperty("user.home");
        }
        return LastDirectory;
    }

    public static void setLastDirectory(String string) {
        LastDirectory = string;
    }

    public static boolean getShowFigTips() {
        return ShowFigTips;
    }

    public static void setShowFigTips(boolean bl2) {
        ShowFigTips = bl2;
    }

    public static void setStatusBar(IStatusBar iStatusBar) {
        _StatusBar = iStatusBar;
    }

    public static void showStatus(String string) {
        if (_StatusBar != null) {
            _StatusBar.showStatus(string);
            return;
        }
        if (Globals.getAppletContext() != null) {
            _applet.getAppletContext().showStatus(string);
        }
    }

    public static void clearStatus() {
        Globals.showStatus(defaultStatus);
    }

    public static void showDocument(URL uRL) {
        if (Globals.getAppletContext() != null) {
            _applet.getAppletContext().showDocument(uRL);
        }
    }

    public static void showDocument(URL uRL, String string) {
        if (Globals.getAppletContext() != null) {
            _applet.getAppletContext().showDocument(uRL, string);
        }
    }

    public static void showDocument(String string) {
        try {
            Globals.showDocument(new URL(string));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    public static Image getImage(URL uRL) {
        Image image = null;
        if (Globals.getAppletContext() != null) {
            image = Globals.getAppletContext().getImage(uRL);
        }
        if (_tracker != null && image != null) {
            _tracker.addImage(image, 1);
        }
        return image;
    }

    public static Image getImage(String string) {
        try {
            Image image = null;
            if (Globals.getAppletContext() != null) {
                image = Globals.getAppletContext().getImage(new URL(string));
            }
            if (_tracker != null && image != null) {
                _tracker.addImage(image, 1);
            }
            return image;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void waitForImages() {
        if (_tracker == null) {
            return;
        }
        try {
            _tracker.waitForAll();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static void quit() {
        Globals.showStatus("Quiting");
        if (_applet.getAppletContext() != null) {
            _applet.destroy();
        }
        System.exit(0);
    }

    public static Prefs getPrefs() {
        return _prefs;
    }

    public static void startPropertySheet() {
    }

    public static Frame someFrame() {
        Serializable serializable = Globals.curEditor();
        if (serializable == null) {
            return null;
        }
        for (serializable = ((Editor)serializable).getJComponent(); serializable != null && !(serializable instanceof Frame); serializable = ((Component)serializable).getParent()) {
        }
        return (Frame)serializable;
    }

    public static void setSticky(boolean bl2) {
        _sticky = bl2;
    }

    public static boolean getSticky() {
        return _sticky;
    }

    public static void setDefaultModeFactory(ModeFactory modeFactory) {
        defaultModeFactory = modeFactory;
    }

    public static void setDefaultModeFactories(List<ModeFactory> list) {
        defaultModeFactories = list;
    }

    public static List<ModeFactory> getDefaultModeFactories() {
        return defaultModeFactories;
    }

    protected static Mode defaultMode() {
        return defaultModeFactory.createMode();
    }

    public static void mode(Mode mode) {
        _mode = mode;
    }

    public static void mode(Mode mode, boolean bl2) {
        _mode = mode;
        _sticky = bl2;
    }

    public static Mode mode() {
        if (_mode == null) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static Mode nextMode() {
        if (!_sticky) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static void curEditor(Editor editor) {
        _curEditor = editor;
    }

    public static Editor curEditor() {
        return _curEditor;
    }

    public static void addPropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])_pcListeners.get(object);
        if (propertyChangeListenerArray == null) {
            propertyChangeListenerArray = new PropertyChangeListener[MAX_LISTENERS];
            _pcListeners.put(object, propertyChangeListenerArray);
        }
        if (LOG.isDebugEnabled() && _pcListeners.size() > 100) {
            LOG.debug((Object)("_pcListeners size = " + _pcListeners.size()));
        }
        for (int i2 = 0; i2 < MAX_LISTENERS; ++i2) {
            if (propertyChangeListenerArray[i2] != null) continue;
            propertyChangeListenerArray[i2] = propertyChangeListener;
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ran out of listeners!");
        }
    }

    public static void addUniversalPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        universalListener = propertyChangeListener;
    }

    public static void removeUniversalPropertyChangeListener() {
        universalListener = null;
    }

    public static void removePropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        int n2;
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])_pcListeners.get(object);
        boolean bl2 = false;
        if (propertyChangeListenerArray == null) {
            return;
        }
        for (n2 = 0; n2 < MAX_LISTENERS; ++n2) {
            if (propertyChangeListenerArray[n2] != propertyChangeListener) continue;
            propertyChangeListenerArray[n2] = null;
            bl2 = true;
        }
        if (LOG.isDebugEnabled() && !bl2) {
            LOG.debug((Object)"listener not found!");
        }
        for (n2 = 0; n2 < MAX_LISTENERS; ++n2) {
            if (propertyChangeListenerArray[n2] == null) continue;
            return;
        }
        _pcListeners.remove(object);
    }

    public static void firePropChange(Object object, String string, boolean bl2, boolean bl3) {
        Globals.firePropChange(object, string, (Object)bl2, (Object)bl3);
    }

    public static void firePropChange(Object object, String string, int n2, int n3) {
        Globals.firePropChange(object, string, (Object)n2, (Object)n3);
    }

    public static void firePropChange(Object object, String string, Object object2, Object object3) {
        if (object2 != null && object2.equals(object3)) {
            return;
        }
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])_pcListeners.get(object);
        if (propertyChangeListenerArray == null && universalListener == null) {
            return;
        }
        object = new PropertyChangeEvent(object, string, object2, object3);
        if (propertyChangeListenerArray != null) {
            for (int i2 = 0; i2 < MAX_LISTENERS; ++i2) {
                if (propertyChangeListenerArray[i2] == null) continue;
                propertyChangeListenerArray[i2].propertyChange((PropertyChangeEvent)object);
            }
        }
        if (universalListener != null) {
            universalListener.propertyChange((PropertyChangeEvent)object);
        }
    }

    static {
        defaultStatus = "  ";
        LOG = LogFactory.getLog(Globals.class);
        pastable = false;
        LastDirectory = null;
        ShowFigTips = true;
        _StatusBar = null;
        _prefs = new Prefs();
        _sticky = false;
        defaultModeFactory = new ModeSelectFactory();
        defaultModeFactories = new ArrayList<ModeFactory>();
        defaultModeFactories.add(new ModeSelectFactory());
        defaultModeFactories.add(new ModePopupFactory());
        defaultModeFactories.add(new ModeDragScrollFactory());
        _pcListeners = new Hashtable();
        universalListener = null;
        MAX_LISTENERS = 4;
    }
}

