/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPainter;

public class LayerDiagram
extends Layer {
    private static final long serialVersionUID = 6193765162314431069L;
    private List<Fig> contents = new ArrayList<Fig>();
    private static int nextLayerNumbered = 1;
    private static final Log LOG = LogFactory.getLog(LayerDiagram.class);

    public LayerDiagram() {
        this("Layer" + LayerDiagram.numberWordFor(nextLayerNumbered++));
    }

    public LayerDiagram(String string) {
        super(string);
        this.setOnMenu(true);
    }

    @Override
    public Enumeration elements() {
        return Collections.enumeration(this.contents);
    }

    protected static String numberWordFor(int n2) {
        switch (n2) {
            case 1: {
                return "One";
            }
            case 2: {
                return "Two";
            }
            case 3: {
                return "Three";
            }
            case 4: {
                return "Four";
            }
            case 5: {
                return "Five";
            }
            case 6: {
                return "Six";
            }
            case 7: {
                return "Seven";
            }
            case 8: {
                return "Eight";
            }
            case 9: {
                return "Nine";
            }
        }
        return "Layer ".concat(String.valueOf(n2));
    }

    @Override
    public void add(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("Attempted to add a null fig to a LayerDiagram");
        }
        this.contents.remove(fig);
        this.contents.add(fig);
        fig.setLayer(this);
        fig.endTrans();
    }

    public void insertAt(Fig fig, int n2) {
        if (fig == null) {
            throw new IllegalArgumentException("Attempted to insert a null fig to a LayerDiagram");
        }
        this.contents.remove(fig);
        this.contents.add(n2, fig);
        fig.setLayer(this);
        fig.endTrans();
    }

    public int indexOf(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("Attempted to find the index of a null fig in a LayerDiagram");
        }
        return this.contents.indexOf(fig);
    }

    @Override
    public void remove(Fig fig) {
        this.contents.remove(fig);
        fig.endTrans();
        fig.setLayer(null);
    }

    public boolean contains(Fig fig) {
        return this.contents.contains(fig);
    }

    @Override
    public List<Fig> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    @Override
    public List<? extends Fig> getContents(Class<? extends Fig> clazz) {
        ArrayList<Fig> arrayList = new ArrayList<Fig>(this.contents.size());
        for (Fig fig : this.contents) {
            if (!fig.getClass().isAssignableFrom(clazz)) continue;
            arrayList.add(fig);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Fig hit(Rectangle rectangle) {
        for (int i2 = this.contents.size() - 1; i2 >= 0; --i2) {
            Fig fig = this.contents.get(i2);
            if (!fig.hit(rectangle)) continue;
            return fig;
        }
        return null;
    }

    @Override
    public void removeAll() {
        for (int i2 = this.contents.size() - 1; i2 >= 0; --i2) {
            this.contents.get(i2).setLayer(null);
        }
        this.contents.clear();
    }

    public FigNode getPortFig(Object object) {
        for (Fig fig : this.getContents()) {
            if (!(fig instanceof FigNode) || ((FigNode)(fig = (FigNode)fig)).getPortFig(object) == null) continue;
            return fig;
        }
        return null;
    }

    @Override
    public Fig presentationFor(Object object) {
        int n2 = this.contents.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.contents.get(i2);
            if (fig.getOwner() != object) continue;
            return fig;
        }
        return null;
    }

    public List presentationsFor(Object object) {
        ArrayList<Fig> arrayList = new ArrayList<Fig>();
        int n2 = this.contents.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this.contents.get(i2);
            if (fig.getOwner() != object) continue;
            arrayList.add(fig);
        }
        return arrayList;
    }

    public int presentationCountFor(Object object) {
        int n2 = 0;
        int n3 = this.contents.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.contents.get(i2).getOwner() != object) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public void paintContents(Graphics graphics) {
        this.paintContents(graphics, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintContents(Graphics graphics, FigPainter figPainter) {
        Iterator<Fig> iterator;
        Rectangle rectangle = graphics.getClipBounds();
        Object object = this.contents;
        synchronized (object) {
            iterator = new ArrayList<Fig>(this.contents).iterator();
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            if (rectangle != null && !((Fig)object).intersects(rectangle)) continue;
            if (figPainter == null) {
                ((Fig)object).paint(graphics);
                continue;
            }
            figPainter.paint(graphics, (Fig)object);
        }
    }

    @Override
    public void sendToBack(Fig fig) {
        this.contents.remove(fig);
        this.contents.add(0, fig);
    }

    @Override
    public void bringToFront(Fig fig) {
        this.contents.remove(fig);
        this.contents.add(fig);
    }

    @Override
    public void sendBackward(Fig fig) {
        int n2 = this.contents.indexOf(fig);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        Fig fig2 = this.contents.get(n2 - 1);
        this.contents.set(n2, fig2);
        this.contents.set(n2 - 1, fig);
    }

    @Override
    public void bringForward(Fig fig) {
        int n2 = this.contents.indexOf(fig);
        if (n2 == -1 || n2 == this.contents.size() - 1) {
            return;
        }
        Fig fig2 = this.contents.get(n2 + 1);
        this.contents.set(n2, fig2);
        this.contents.set(n2 + 1, fig);
    }

    @Override
    public void bringInFrontOf(Fig fig, Fig fig2) {
        int n2 = this.contents.indexOf(fig);
        int n3 = this.contents.indexOf(fig2);
        if (n2 == -1) {
            return;
        }
        if (n3 == -1) {
            return;
        }
        if (n2 >= n3) {
            return;
        }
        this.contents.remove(fig);
        this.contents.add(n3, fig);
    }

    @Override
    public void reorder(Fig fig, int n2) {
        switch (n2) {
            case 1: {
                this.sendToBack(fig);
                return;
            }
            case 2: {
                this.bringToFront(fig);
                return;
            }
            case 3: {
                this.sendBackward(fig);
                return;
            }
            case 4: {
                this.bringForward(fig);
            }
        }
    }

    @Override
    public void preSave() {
        this.validate();
        for (int i2 = 0; i2 < this.contents.size(); ++i2) {
            this.contents.get(i2).preSave();
        }
    }

    private boolean validate() {
        for (int i2 = this.contents.size() - 1; i2 >= 0; --i2) {
            Fig fig = this.contents.get(i2);
            if (fig.isRemoveStarted()) {
                LOG.error((Object)("A fig has been found that should have been removed " + fig.toString()));
                this.contents.remove(i2);
                return false;
            }
            if (fig.getLayer() == this) continue;
            LOG.error((Object)("A fig has been found that doesn't refer back to the correct layer " + fig.toString() + " - " + fig.getLayer()));
            fig.setLayer(this);
            return false;
        }
        return true;
    }

    @Override
    public void postSave() {
        for (int i2 = 0; i2 < this.contents.size(); ++i2) {
            this.contents.get(i2).postSave();
        }
    }

    @Override
    public void postLoad() {
        for (int i2 = 0; i2 < this.contents.size(); ++i2) {
            this.contents.get(i2).postLoad();
        }
    }
}

