/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.UIManager;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerGrid
extends Layer {
    private static final long serialVersionUID = 4363123625161512763L;
    private int _spacing = 16;
    private boolean _paintLines = false;
    private boolean _paintDots = true;
    private transient Image _stamp = null;
    private int _stampWidth = 128;
    private int _stampHeight = 128;
    protected Color _color = new Color(180, 180, 180);
    protected Color _bgColor = Color.lightGray;
    protected boolean _paintBackground = true;
    protected int _dotSize = 2;
    private int _style = 2;
    private final int NUM_STYLES = 5;

    public LayerGrid() {
        super("Grid");
        this._bgColor = UIManager.getColor("Panel.background");
        if (this._bgColor == null) {
            this._bgColor = Color.lightGray;
        }
        this._color = new Color((int)((float)this._bgColor.getRed() * 0.9f), (int)((float)this._bgColor.getGreen() * 0.9f), (int)((float)this._bgColor.getBlue() * 0.9f));
    }

    public LayerGrid(Color color, Color color2, int n2, boolean bl2) {
        super("Grid");
        this._color = color;
        this._bgColor = color2;
        this._spacing = n2;
        this._paintLines = bl2;
    }

    @Override
    public List<Fig> getContents() {
        return Collections.emptyList();
    }

    @Override
    public Fig presentationFor(Object object) {
        return null;
    }

    @Override
    public synchronized void paintContents(Graphics graphics) {
        Serializable serializable;
        if (graphics instanceof PrintGraphics) {
            if (!Globals.getPrefs().getPrintGrid()) {
                return;
            }
            if (this._paintLines) {
                this.paintLines(graphics, Globals.getPrefs().getPrintBackground());
                return;
            }
            this.paintDots(graphics, Globals.getPrefs().getPrintBackground());
            return;
        }
        if (this._stamp == null) {
            if (this._spacing > this._stampHeight) {
                LayerGrid layerGrid = this;
                layerGrid._stampHeight = layerGrid._stampWidth = this._spacing;
            }
            if (Globals.curEditor() == null) {
                System.out.println("no editor");
                serializable = new Frame();
                ((Window)serializable).setVisible(true);
                this._stamp = ((Component)serializable).createImage(this._stampWidth, this._stampHeight);
                ((Window)serializable).dispose();
            } else {
                this._stamp = Globals.curEditor().createImage(this._stampWidth, this._stampHeight);
            }
            if (this._stamp != null) {
                if (this._paintLines) {
                    LayerGrid layerGrid = this;
                    layerGrid.paintLines(layerGrid._stamp, this._paintBackground);
                } else if (this._paintDots) {
                    LayerGrid layerGrid = this;
                    layerGrid.paintDots(layerGrid._stamp, this._paintBackground);
                }
            }
        }
        if ((serializable = graphics.getClipBounds()) != null) {
            int cfr_ignored_0 = ((Rectangle)serializable).y;
            int n2 = ((Rectangle)serializable).y + ((Rectangle)serializable).height;
            int n3 = ((Rectangle)serializable).x + ((Rectangle)serializable).width;
            if (this._stamp != null) {
                for (int i2 = ((Rectangle)serializable).x / this._spacing * this._spacing; i2 <= n3; i2 += this._stampWidth) {
                    for (int i3 = ((Rectangle)serializable).y / this._spacing * this._spacing; i3 <= n2; i3 += this._stampHeight) {
                        graphics.drawImage(this._stamp, i2, i3, null);
                    }
                }
            }
        }
    }

    private void paintLines(Image image, boolean bl2) {
        Graphics graphics = image.getGraphics();
        graphics.clipRect(0, 0, image.getWidth(null), image.getHeight(null));
        this.paintLines(graphics, bl2);
    }

    private void paintDots(Image image, boolean bl2) {
        Graphics graphics = image.getGraphics();
        graphics.clipRect(0, 0, image.getWidth(null), image.getHeight(null));
        this.paintDots(graphics, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private void paintLines(Graphics graphics, boolean bl2) {
        Rectangle rectangle = graphics.getClipBounds();
        if (bl2) {
            graphics.setColor(this._bgColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n2 = rectangle.x / this._spacing * this._spacing - this._spacing;
        int n3 = rectangle.y / this._spacing * this._spacing - this._spacing;
        int n4 = rectangle.height / this._spacing + 2;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y + rectangle.height;
        graphics.setColor(this._color);
        for (int i2 = rectangle.width / this._spacing + 2; i2 > 0; --i2) {
            void var2_4;
            graphics.drawLine((int)var2_4, 0, (int)var2_4, n6);
            var2_4 += this._spacing;
        }
        while (n4 > 0) {
            graphics.drawLine(0, n3, n5, n3);
            n3 += this._spacing;
            --n4;
        }
    }

    protected void paintDots(Graphics graphics, boolean n2) {
        Rectangle rectangle = graphics.getClipBounds();
        if (n2 != 0) {
            graphics.setColor(this._bgColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int cfr_ignored_0 = rectangle.y;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        graphics.setColor(this._color);
        for (n2 = rectangle.x / this._spacing * this._spacing - this._spacing; n2 <= n3; n2 += this._spacing) {
            for (int i2 = 0; i2 <= n4; i2 += this._spacing) {
                graphics.fillRect(n2, i2, this._dotSize, this._dotSize);
            }
        }
    }

    @Override
    public void adjust() {
        this._style = (this._style + 1) % 5;
        this._stamp = null;
        this.setHidden(false);
        switch (this._style) {
            case 0: {
                this._paintLines = true;
                this._paintDots = true;
                this._spacing = 16;
                break;
            }
            case 1: {
                this._paintLines = true;
                this._paintDots = true;
                this._spacing = 8;
                break;
            }
            case 2: {
                this._paintLines = false;
                this._paintDots = true;
                this._spacing = 16;
                break;
            }
            case 3: {
                this._paintLines = false;
                this._paintDots = true;
                this._spacing = 32;
                break;
            }
            case 4: {
                this._paintLines = false;
                this._paintDots = false;
            }
        }
        this.refreshEditors();
    }

    @Override
    public void adjust(HashMap hashMap) {
        super.adjust(hashMap);
        this._stamp = null;
        this.setHidden(false);
        Object v2 = hashMap.get("spacing");
        if (v2 instanceof Integer) {
            this._spacing = (Integer)v2;
        }
        if ((v2 = hashMap.get("paintLines")) instanceof Boolean) {
            this._paintLines = (Boolean)v2;
        }
        if ((v2 = hashMap.get("paintDots")) instanceof Boolean) {
            this._paintDots = (Boolean)v2;
        }
        this.refreshEditors();
    }
}

