/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerPolar
extends Layer {
    private static final long serialVersionUID = -7584346767965616421L;
    private int _originX = 0;
    private int _originY = 0;
    private int _spacing = 32;
    private int _style = 0;
    private int NUM_STYLES = 5;
    protected Color _lineColor = new Color(55, 55, 255);
    protected Color _bgColor = null;

    public LayerPolar() {
        super("Grid");
    }

    public LayerPolar(int n2, int n3, int n4) {
        super("Grid");
        this.origin(n2, n3);
        this.spacing(n4);
    }

    public void origin(int n2, int n3) {
        this._originX = n2;
        this._originY = n3;
    }

    public void spacing(int n2) {
        this._spacing = n2;
    }

    public int dist(int n2, int n3) {
        return (int)Math.round(Math.sqrt((this._originX - n2) * (this._originX - n2) + (this._originY - n3) * (this._originY - n3)));
    }

    public void lineColor(Color color) {
        this._lineColor = color;
    }

    public Color lineColor() {
        return this._lineColor;
    }

    public void bgColor(Color color) {
        this._bgColor = color;
    }

    public Color bgColor() {
        return this._bgColor;
    }

    @Override
    public List<Fig> getContents() {
        return Collections.emptyList();
    }

    @Override
    public Fig presentationFor(Object object) {
        return null;
    }

    @Override
    public void paintContents(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.x + rectangle.width;
        if (this._bgColor != null) {
            graphics.setColor(this._bgColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n4 = this.dist(rectangle.x, rectangle.y);
        int n5 = this.dist(rectangle.x, n2);
        int n6 = this.dist(n3, rectangle.y);
        n2 = this.dist(n3, n2);
        n6 = Math.max(Math.max(n4, n5), Math.max(n6, n2)) / this._spacing * this._spacing + 1;
        graphics.setColor(this._lineColor);
        n2 = this._originX;
        n3 = this._originY;
        n4 = 0;
        n6 = 2 * n6;
        while (n4 <= n6) {
            int n7 = n4;
            graphics.drawOval(n2, n3, n7, n7);
            n2 -= this._spacing;
            n3 -= this._spacing;
            n4 = n4 + this._spacing + this._spacing;
        }
    }

    @Override
    public void adjust() {
        this._style = (this._style + 1) % this.NUM_STYLES;
        switch (this._style) {
            case 0: {
                this.setHidden(false);
                this.origin(0, 0);
                this.spacing(32);
                return;
            }
            case 1: {
                this.setHidden(false);
                this.origin(0, 0);
                this.spacing(16);
                return;
            }
            case 2: {
                this.setHidden(false);
                this.origin(50, 50);
                this.spacing(16);
                return;
            }
            case 3: {
                this.setHidden(false);
                Serializable serializable = Globals.curEditor();
                if (serializable != null) {
                    serializable = serializable.getJComponent().getSize();
                    this.origin(((Dimension)serializable).width / 2, ((Dimension)serializable).height / 2);
                } else {
                    this.origin(100, 100);
                }
                this.spacing(16);
                return;
            }
            case 4: {
                this.setHidden(true);
            }
        }
    }
}

