/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.tigris.gef.base.AlignAction;
import org.tigris.gef.base.DistributeAction;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.util.Localizer;

public class ModeBroom
extends FigModifyingModeImpl {
    private static final long serialVersionUID = -6846688672699867345L;
    private static final String resource = "GefBase";
    private final int DIRECTION_UNDEFINED = 0;
    private final int DIRECTION_UPWARD = 1;
    private final int DIRECTION_DOWNWARD = 2;
    private final int DIRECTION_RIGHTWARD = 3;
    private final int DIRECTION_LEFTWARD = 4;
    private final int DEFINE_DIRECTION_TOLERANCE = 10;
    private final int BROOM_WIDTH_NORMAL = 200;
    private final int BROOM_WIDTH_SMALL = 30;
    private final int MAX_TOUCHED_FIGS = 1000;
    private final int DISTRIBUTE_EVEN_SPACE = 0;
    private final int DISTRIBUTE_PACK = 1;
    private final int DISTRIBUTE_SPREAD = 2;
    private final int DISTRIBUTE_ORIG = 3;
    private final Font HINT_FONT = new Font("Dialog", 0, 9);
    private Point _start = new Point(0, 0);
    private Vector<Fig> _LastTouched = new Vector();
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int _lastX1;
    private int _lastY1;
    private int _lastX2;
    private int _lastY2;
    private int _lastMX;
    private int _lastMY;
    private int _dir = 0;
    private boolean _magnetic = false;
    private boolean _movable = true;
    private boolean _draw = false;
    private Fig[] _touched = new Fig[1000];
    private int[] _origX = new int[1000];
    private int[] _origY = new int[1000];
    private int[] _offX = new int[1000];
    private int[] _offY = new int[1000];
    private int _nTouched = 0;
    private int _broomMargin = 0;
    private int _distributeMode = 0;
    private Rectangle _addRect = new Rectangle();
    private Rectangle _selectRect = new Rectangle();
    private Rectangle _bigDamageRect = new Rectangle(0, 0, 400, 400);
    private Rectangle _origBBox = null;
    private String _hint = null;

    public ModeBroom(Editor editor) {
        super(editor);
    }

    public ModeBroom() {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this._touched = new Fig[1000];
        this._origX = new int[1000];
        this._origY = new int[1000];
        this._offX = new int[1000];
        this._offY = new int[1000];
        this._nTouched = 0;
        this._dir = 0;
        this._magnetic = false;
        this._draw = true;
        ModeBroom modeBroom = this;
        modeBroom.x2 = this._start.x = mouseEvent.getX();
        modeBroom.x1 = this._start.x;
        ModeBroom modeBroom2 = this;
        modeBroom2.y2 = this._start.y = mouseEvent.getY();
        modeBroom2.y1 = this._start.y;
        this._lastX1 = this.x1;
        this._lastY1 = this.y1;
        this._lastX2 = this.x2;
        this._lastY2 = this.y2;
        this._selectRect.setBounds(this.x1 - 14, this.y1 - 14, this.x2 - this.x1 + 28, this.y2 - this.y1 + 28);
        this.editor.damaged(this._selectRect);
        mouseEvent.consume();
        this._hint = null;
        this.start();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        this.editor.getSelectionManager().deselectAll();
        Point point = mouseEvent.getPoint();
        mouseEvent.getPoint().x = Math.max(0, point.x);
        point.y = Math.max(0, point.y);
        this._lastMX = point.x;
        this._lastMY = point.y;
        this.editor.snap(point);
        int n2 = point.x;
        int n3 = point.y;
        this._selectRect.setBounds(this.x1 - 4, this.y1 - 4, this.x2 - this.x1 + 8, this.y2 - this.y1 + 8);
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this.editor.damaged(this._bigDamageRect);
        this.editor.damaged(this._selectRect);
        if (this._dir == 0) {
            this._broomMargin = mouseEvent.isShiftDown() ? 30 : 200;
            int n4 = mouseEvent.getX() - this._start.x;
            int n5 = mouseEvent.getY() - this._start.y;
            if (Math.abs(n4) < 10 && Math.abs(n5) < 10) {
                return;
            }
            if (Math.abs(n4) > Math.abs(n5)) {
                this._dir = n4 > 0 ? 3 : 4;
                ModeBroom modeBroom = this;
                modeBroom.x1 = modeBroom.x2 = n2;
                this.y1 = n3 - this._broomMargin / 2;
                this.y2 = n3 + this._broomMargin / 2;
                if (mouseEvent.isShiftDown()) {
                    this.y1 = n3 - this._broomMargin / 2;
                    this.y2 = n3 + this._broomMargin / 2;
                }
            } else {
                this._dir = n5 > 0 ? 2 : 1;
                ModeBroom modeBroom = this;
                modeBroom.y1 = modeBroom.y2 = n3;
                this.x1 = n2 - this._broomMargin / 2;
                this.x2 = n2 + this._broomMargin / 2;
                if (mouseEvent.isShiftDown()) {
                    this.x1 = n2 - this._broomMargin / 2;
                    this.x2 = n2 + this._broomMargin / 2;
                }
            }
        }
        if (!this._magnetic) {
            this.addNewItems();
        }
        this._lastX1 = this.x1;
        this._lastY1 = this.y1;
        this._lastX2 = this.x2;
        this._lastY2 = this.y2;
        switch (this._dir) {
            case 1: {
                if (this._movable) {
                    ModeBroom modeBroom = this;
                    modeBroom.y1 = modeBroom.y2 = Math.min(n3, this._start.y);
                    if (this._magnetic) {
                        ModeBroom modeBroom2 = this;
                        modeBroom2.y1 = modeBroom2.y2 = n3;
                    }
                }
                this.x1 = Math.min(this.x1, this._lastMX - this._broomMargin / 2);
                this.x2 = Math.max(this.x2, this._lastMX + this._broomMargin / 2);
                break;
            }
            case 2: {
                if (this._movable) {
                    ModeBroom modeBroom = this;
                    modeBroom.y1 = modeBroom.y2 = Math.max(n3, this._start.y);
                    if (this._magnetic) {
                        ModeBroom modeBroom3 = this;
                        modeBroom3.y1 = modeBroom3.y2 = n3;
                    }
                }
                this.x1 = Math.min(this.x1, this._lastMX - this._broomMargin / 2);
                this.x2 = Math.max(this.x2, this._lastMX + this._broomMargin / 2);
                break;
            }
            case 3: {
                if (this._movable) {
                    ModeBroom modeBroom = this;
                    modeBroom.x1 = modeBroom.x2 = Math.max(n2, this._start.x);
                    if (this._magnetic) {
                        ModeBroom modeBroom4 = this;
                        modeBroom4.x1 = modeBroom4.x2 = n2;
                    }
                }
                this.y1 = Math.min(this.y1, this._lastMY - this._broomMargin / 2);
                this.y2 = Math.max(this.y2, this._lastMY + this._broomMargin / 2);
                break;
            }
            case 4: {
                if (this._movable) {
                    ModeBroom modeBroom = this;
                    modeBroom.x1 = modeBroom.x2 = Math.min(n2, this._start.x);
                    if (this._magnetic) {
                        ModeBroom modeBroom5 = this;
                        modeBroom5.x1 = modeBroom5.x2 = n2;
                    }
                }
                this.y1 = Math.min(this.y1, this._lastMY - this._broomMargin / 2);
                this.y2 = Math.max(this.y2, this._lastMY + this._broomMargin / 2);
            }
        }
        if (this._movable) {
            Fig fig;
            int n6;
            Vector<FigEdge> vector = new Vector<FigEdge>();
            Vector<FigEdge> vector2 = new Vector<FigEdge>();
            for (n6 = 0; n6 < this._nTouched; ++n6) {
                fig = this._touched[n6];
                int n7 = n2;
                int n8 = n3;
                int n9 = fig.getX();
                int n10 = fig.getY();
                int n11 = 0;
                int n12 = 0;
                switch (this._dir) {
                    case 1: {
                        if (!this._magnetic) {
                            n8 = Math.min(n3, this._origY[n6] + this._offY[n6]);
                        }
                        n12 = Math.max(-n10, n8 - n10 - this._offY[n6]);
                        break;
                    }
                    case 2: {
                        if (!this._magnetic) {
                            n8 = Math.max(n3, this._origY[n6] + this._offY[n6]);
                        }
                        n12 = n8 - n10 - this._offY[n6];
                        break;
                    }
                    case 3: {
                        if (!this._magnetic) {
                            n7 = Math.max(n2, this._origX[n6] + this._offX[n6]);
                        }
                        n11 = n7 - n9 - this._offX[n6];
                        break;
                    }
                    case 4: {
                        if (!this._magnetic) {
                            n7 = Math.min(n2, this._origX[n6] + this._offX[n6]);
                        }
                        n11 = Math.max(-n9, n7 - n9 - this._offX[n6]);
                    }
                }
                if (fig instanceof FigNode) {
                    FigNode figNode = (FigNode)fig;
                    figNode.superTranslate(n11, n12);
                    for (FigEdge figEdge : figNode.getFigEdges(null)) {
                        if (vector.contains(figEdge) && !vector2.contains(figEdge)) {
                            vector2.addElement(figEdge);
                            figEdge.translateEdge(n11, n12);
                            continue;
                        }
                        vector.addElement(figEdge);
                    }
                } else {
                    fig.translate(n11, n12);
                }
                if (!(n11 <= 0 && n12 <= 0 || fig instanceof FigEdge)) {
                    MutableGraphSupport.enableSaveAction();
                }
                fig.endTrans();
            }
            for (n6 = 0; n6 < this._nTouched; ++n6) {
                fig = this._touched[n6];
                if (!(fig instanceof FigNode)) continue;
                ((FigNode)fig).updateEdges();
            }
        }
        this._selectRect.setBounds(this.x1 - 4, this.y1 - 4, this.x2 - this.x1 + 8, this.y2 - this.y1 + 8);
        this.editor.damaged(this._selectRect);
        this._hint = null;
        this.touching();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this._selectRect.setBounds(this.x1 - 1, this.y1 - 1, this.x2 - this.x1 + 2, this.y2 - this.y1 + 20);
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this.editor.damaged(this._bigDamageRect);
        this.editor.damaged(this._selectRect);
        if (this._LastTouched.size() > 0) {
            this.editor.getSelectionManager().selectFigs(this._LastTouched);
        }
        this._draw = false;
        this.done();
        mouseEvent.consume();
        this._hint = null;
    }

    public void addNewItems() {
        if (this._nTouched >= 1000) {
            return;
        }
        this._addRect.setBounds(this._lastX1, this._lastY1, this._lastX2 - this._lastX1, this._lastY2 - this._lastY1);
        this._addRect.add(this._selectRect);
        block0: for (Fig fig : this.editor.getFigs()) {
            Rectangle rectangle = fig.getBounds();
            if (!this._addRect.intersects(rectangle) || this._dir == 4 && rectangle.x + rectangle.width > this._addRect.x + this._addRect.width || this._dir == 3 && rectangle.x < this._addRect.x || this._dir == 1 && rectangle.y + rectangle.height > this._addRect.y + this._addRect.height || this._dir == 2 && rectangle.y < this._addRect.y) continue;
            for (int i2 = 0; i2 < this._nTouched; ++i2) {
                if (this._touched[i2] == fig) continue block0;
            }
            this._touched[this._nTouched] = fig;
            this._origX[this._nTouched] = fig.getX();
            this._origY[this._nTouched] = fig.getY();
            this._offX[this._nTouched] = this._dir == 4 ? fig.getWidth() : 0;
            this._offY[this._nTouched] = this._dir == 1 ? fig.getHeight() : 0;
            ++this._nTouched;
            this._origBBox = null;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if ('\n' == keyEvent.getKeyChar() || '\t' == keyEvent.getKeyChar()) {
            this._magnetic = !this._magnetic;
        } else if (' ' == keyEvent.getKeyChar()) {
            this.doDistibute(false, keyEvent.isShiftDown());
            keyEvent.consume();
        } else {
            return;
        }
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this.editor.damaged(this._bigDamageRect);
        this.editor.damaged(this._selectRect);
    }

    public void doDistibute(boolean bl2, boolean bl3) {
        this._movable = false;
        Vector<Fig> vector = this._LastTouched;
        if (vector == null) {
            vector = this.touching();
        }
        int n2 = 0;
        int n3 = vector.size();
        if (this._distributeMode == 0 || this._distributeMode == 2) {
            n2 = 4;
            if (this._dir == 1 || this._dir == 2) {
                n2 = 0;
            }
        } else if (this._distributeMode == 1) {
            n2 = 6;
            if (this._dir == 1 || this._dir == 2) {
                n2 = 2;
            }
        }
        if (this._distributeMode == 3) {
            for (n2 = 0; n2 < n3; ++n2) {
                Fig fig = vector.elementAt(n2);
                if (this._dir == 1 || this._dir == 2) {
                    fig.setLocation(this._origX[n2], fig.getY());
                } else {
                    Fig fig2 = fig;
                    fig2.setLocation(fig2.getX(), this._origY[n2]);
                }
                fig.endTrans();
            }
        } else {
            DistributeAction distributeAction = new DistributeAction(n2, vector);
            if (this._distributeMode == 2) {
                distributeAction.setBoundingBox(this._selectRect);
            } else if (this._distributeMode == 0 && this._origBBox != null) {
                distributeAction.setBoundingBox(this._origBBox);
            }
            distributeAction.actionPerformed(null);
            if (bl3) {
                int n4 = 5;
                if (this._dir == 1 || this._dir == 2) {
                    n4 = 6;
                }
                new AlignAction(n4, vector).actionPerformed(null);
            }
            if (bl2) {
                new AlignAction(7, vector).actionPerformed(null);
            }
            if (this._distributeMode == 0 && this._origBBox == null) {
                this._origBBox = distributeAction.getBoundingBox();
            }
        }
        this._hint = this._distributeMode == 0 ? "BroomSpaceEvenly" : (this._distributeMode == 1 ? "BroomPackTightly" : (this._distributeMode == 2 ? "BroomSpreadOut" : (this._distributeMode == 3 ? "BroomOriginal" : "(internal prog error)")));
        if (bl3) {
            this._hint = this._hint + "Center";
        }
        if (bl2) {
            this._hint = this._hint + "Snap";
        }
        this._hint = Localizer.localize(resource, this._hint);
        this._distributeMode = (this._distributeMode + 1) % 4;
    }

    public Vector<Fig> touching() {
        Vector<Fig> vector = new Vector<Fig>(this._nTouched);
        for (int i2 = 0; i2 < this._nTouched; ++i2) {
            if (!this._touched[i2].getBounds().intersects(this._selectRect) || this._touched[i2] instanceof FigEdge) continue;
            vector.addElement(this._touched[i2]);
        }
        this._LastTouched = vector;
        return vector;
    }

    @Override
    public String instructions() {
        return Localizer.localize(resource, "BroomInstructions");
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this._draw) {
            return;
        }
        Color color = Globals.getPrefs().getRubberbandColor();
        if (this._magnetic) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(color);
        }
        if (this._hint != null) {
            graphics.setFont(this.HINT_FONT);
        }
        int n2 = this._broomMargin / 2;
        switch (this._dir) {
            case 0: {
                graphics.fillRect(this.x1 - 10, (this.y1 + this.y2) / 2 - 2, 20, 4);
                graphics.fillRect((this.x1 + this.x2) / 2 - 2, this.y1 - 10, 4, 20);
                return;
            }
            case 1: {
                graphics.fillRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1 + 4);
                graphics.drawLine(this._lastMX - n2, this.y2 + 4, this._lastMX - n2, this.y2 + 8);
                graphics.drawLine(this._lastMX + n2 - 1, this.y2 + 4, this._lastMX + n2 - 1, this.y2 + 8);
                if (this._movable) {
                    graphics.fillRect((this.x1 + this.x2) / 2 - 2, this.y1, 4, 14);
                }
                if (this._hint == null) break;
                graphics.drawString(this._hint, (this.x1 + this.x2) / 2 + 5, this.y1 + 15);
                return;
            }
            case 2: {
                graphics.fillRect(this.x1, this.y1 - 4, this.x2 - this.x1, this.y2 - this.y1 + 4);
                if (this._movable) {
                    graphics.fillRect((this.x1 + this.x2) / 2 - 2, this.y1 - 14, 4, 14);
                }
                graphics.drawLine(this._lastMX - n2, this.y1 - 4, this._lastMX - n2, this.y1 - 8);
                graphics.drawLine(this._lastMX + n2 - 1, this.y1 - 4, this._lastMX + n2 - 1, this.y1 - 8);
                if (this._hint == null) break;
                graphics.drawString(this._hint, (this.x1 + this.x2) / 2 + 5, this.y1 - 8);
                return;
            }
            case 3: {
                graphics.fillRect(this.x1 - 4, this.y1, this.x2 - this.x1 + 4, this.y2 - this.y1);
                graphics.drawLine(this.x1 - 4, this._lastMY - n2, this.x1 - 8, this._lastMY - n2);
                graphics.drawLine(this.x1 - 4, this._lastMY + n2 - 1, this.x1 - 8, this._lastMY + n2 - 1);
                if (this._movable) {
                    graphics.fillRect(this.x1 - 14, (this.y1 + this.y2) / 2 - 2, 14, 4);
                }
                if (this._hint == null) break;
                graphics.drawString(this._hint, this.x1 - 70, (this.y1 + this.y2) / 2 - 10);
                return;
            }
            case 4: {
                graphics.fillRect(this.x1, this.y1, this.x2 - this.x1 + 4, this.y2 - this.y1);
                graphics.drawLine(this.x2 + 4, this._lastMY - n2, this.x2 + 8, this._lastMY - n2);
                graphics.drawLine(this.x2 + 4, this._lastMY + n2 - 1, this.x2 + 8, this._lastMY + n2 - 1);
                if (this._movable) {
                    graphics.fillRect(this.x1, (this.y1 + this.y2) / 2 - 2, 14, 4);
                }
                if (this._hint == null) break;
                graphics.drawString(this._hint, this.x2 + 5, (this.y1 + this.y2) / 2 - 10);
            }
        }
    }
}

