/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.di.GraphElement;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Fig;

public abstract class ModeCreate
extends FigModifyingModeImpl {
    protected int _defaultWidth = 32;
    protected int _defaultHeight = 32;
    protected int anchorX;
    protected int anchorY;
    public Fig _newItem;
    private static Log LOG = LogFactory.getLog(ModeCreate.class);
    private Point snapPt = new Point(0, 0);

    public ModeCreate(Editor editor) {
        super(editor);
    }

    public ModeCreate() {
    }

    @Override
    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.createFig(mouseEvent);
        if (!(this._newItem instanceof GraphElement) && this.editor.getGraphModel() instanceof MutableGraphSupport) {
            ((MutableGraphSupport)this.editor.getGraphModel()).fireGraphChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFig(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this.start();
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.editor.snap(this.snapPt);
            this.anchorX = this.snapPt.x;
            this.anchorY = this.snapPt.y;
        }
        this._newItem = this.createNewItem(mouseEvent, this.anchorX, this.anchorY);
        mouseEvent.consume();
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._newItem != null) {
            this.editor.damageAll();
            this.creationDrag(mouseEvent.getX(), mouseEvent.getY());
            this.editor.damageAll();
        }
        this.editor.scrollToShow(mouseEvent.getX(), mouseEvent.getY());
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._newItem != null) {
            this.editor.damageAll();
            this.creationDrag(mouseEvent.getX(), mouseEvent.getY());
            this.editor.add(this._newItem);
            this.editor.getSelectionManager().select(this._newItem);
            this._newItem = null;
        }
        this.done();
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            LOG.debug((Object)"ESC pressed");
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void creationDrag(int n2, int n3) {
        int n4;
        int n5;
        if (this._newItem == null) {
            return;
        }
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(n2, n3);
            this.editor.snap(this.snapPt);
            n5 = this.snapPt.x;
            n4 = this.snapPt.y;
        }
        if (this.anchorX == n5 && this.anchorY == n4) {
            this._newItem.createDrag(this.anchorX, this.anchorY, n2 + this._defaultWidth, n3 + this._defaultHeight, n5 + this._defaultWidth, n4 + this._defaultHeight);
            return;
        }
        this._newItem.createDrag(this.anchorX, this.anchorY, n2, n3, n5, n4);
        this._defaultWidth = n5 - this.anchorX;
        this._defaultHeight = n4 - this.anchorY;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._newItem != null) {
            this._newItem.paint(graphics);
        }
    }

    public abstract Fig createNewItem(MouseEvent var1, int var2, int var3);
}

