/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeCreateEdge;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.Localizer;

public class ModeCreatePolyEdge
extends ModeCreateEdge {
    private static final long serialVersionUID = 1991680308906935894L;
    private Object startPort;
    private Fig startPortFig;
    private FigNode sourceFigNode;
    private Object newEdge;
    protected int _npoints = 0;
    protected int _lastX;
    protected int _lastY;
    protected int _startX;
    protected int _startY;
    protected Handle _handle = new Handle(-1);
    private static Log LOG = LogFactory.getLog(ModeCreatePolyEdge.class);

    public ModeCreatePolyEdge() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreatePolyEdge");
        }
    }

    public ModeCreatePolyEdge(Editor editor) {
        super(editor);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreatePolyEdge for Editor");
        }
    }

    @Override
    public String instructions() {
        return Localizer.localize("GefBase", "ModeCreatePolyEdgeInstructions");
    }

    @Override
    public Fig createNewItem(MouseEvent serializable, int n2, int n3) {
        serializable = new FigPoly(n2, n3);
        ((Fig)serializable).setLineColor(Globals.getPrefs().getRubberbandColor());
        ((Fig)serializable).setFillColor(null);
        ((FigPoly)serializable).addPoint(n2, n3);
        ModeCreatePolyEdge modeCreatePolyEdge = this;
        modeCreatePolyEdge._startX = modeCreatePolyEdge._lastX = n2;
        ModeCreatePolyEdge modeCreatePolyEdge2 = this;
        modeCreatePolyEdge2._startY = modeCreatePolyEdge2._lastY = n3;
        this._npoints = 2;
        return serializable;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but rejected as already consumed");
            }
            return;
        }
        UndoManager.getInstance().addMementoLock(this);
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Fig fig = this.editor.hit(n2, n3);
        if (fig == null) {
            fig = this.editor.hit(n2 - 16, n3 - 16, 32, 32);
        }
        if (fig == null && this._npoints == 0) {
            this.done();
            mouseEvent.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but nothing under mouse - consumed anyway");
            }
            return;
        }
        if (!(fig instanceof FigNode) && this._npoints == 0) {
            this.done();
            mouseEvent.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but not on a FigNode - consumed anyway");
            }
            return;
        }
        if (this.sourceFigNode == null) {
            this.sourceFigNode = (FigNode)fig;
            this.startPort = this.sourceFigNode.deepHitPort(n2, n3);
        }
        if (this.startPort == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but not on a port - consumed anyway");
            }
            this.done();
            mouseEvent.consume();
            return;
        }
        this.startPortFig = this.sourceFigNode.getPortFig(this.startPort);
        if (this._npoints == 0) {
            this.createFig(mouseEvent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MousePressed detected and processed by ancestor - consumed");
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        GraphModel graphModel;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this.sourceFigNode == null) {
            this.done();
            mouseEvent.consume();
            return;
        }
        UndoManager.getInstance().startChain();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Cloneable cloneable = this.editor.hit(n2, n3);
        if (cloneable == null) {
            cloneable = this.editor.hit(n2 - 16, n3 - 16, 32, 32);
        }
        if (!((graphModel = this.editor.getGraphModel()) instanceof MutableGraphModel)) {
            cloneable = null;
        }
        graphModel = (MutableGraphModel)graphModel;
        if (cloneable instanceof FigNode) {
            Object object = ((FigNode)(cloneable = (FigNode)cloneable)).deepHitPort(n2, n3);
            if (object == this.startPort && this._npoints < 4) {
                this.done();
                mouseEvent.consume();
                return;
            }
            if (object != null) {
                Fig fig = ((FigNode)cloneable).getPortFig(object);
                Serializable serializable = (FigPoly)this._newItem;
                if (object == this.startPort && this._npoints >= 4) {
                    ((FigPoly)serializable).setSelfLoop(true);
                }
                this.editor.damageAll();
                ((FigPoly)serializable).setComplete(true);
                serializable = (Class)this.getArg("edgeClass");
                this.newEdge = serializable != null ? graphModel.connect(this.startPort, object, (Class)serializable) : graphModel.connect(this.startPort, object);
                if (this.newEdge == null) {
                    LOG.warn((Object)"MutableGraphModel connect() returned null");
                } else {
                    this.sourceFigNode.damage();
                    ((Fig)cloneable).damage();
                    serializable = (FigEdge)this.editor.getLayerManager().getActiveLayer().presentationFor(this.newEdge);
                    this._newItem.setLineColor(Color.black);
                    ((FigEdge)serializable).setFig(this._newItem);
                    ((FigEdge)serializable).setSourcePortFig(this.startPortFig);
                    ((FigEdge)serializable).setSourceFigNode(this.sourceFigNode);
                    ((FigEdge)serializable).setDestPortFig(fig);
                    ((FigEdge)serializable).setDestFigNode((FigNode)cloneable);
                    if (serializable != null) {
                        this.editor.getSelectionManager().select((Fig)serializable);
                    }
                    this.editor.damageAll();
                    if (serializable instanceof MouseListener) {
                        ((MouseListener)((Object)serializable)).mouseReleased(mouseEvent);
                    }
                    if (this.sourceFigNode != null) {
                        this.sourceFigNode.updateEdges();
                    }
                    if (cloneable != null) {
                        ((FigNode)cloneable).updateEdges();
                    }
                    this.endAttached((FigEdge)serializable);
                }
                this.done();
                mouseEvent.consume();
                return;
            }
        }
        if (!this.nearLast(n2, n3)) {
            this.editor.damageAll();
            cloneable = new Point(n2, n3);
            this.editor.snap((Point)cloneable);
            ((FigPoly)this._newItem).addPoint(((Point)cloneable).x, ((Point)cloneable).y);
            ++this._npoints;
            this.editor.damageAll();
        }
        this._lastX = n2;
        this._lastY = n3;
        UndoManager.getInstance().removeMementoLock(this);
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this._npoints == 0) {
            mouseEvent.consume();
            return;
        }
        if (this._newItem == null) {
            mouseEvent.consume();
            return;
        }
        FigPoly figPoly = (FigPoly)this._newItem;
        this.editor.damageAll();
        Point point = new Point(n2, n3);
        this.editor.snap(point);
        this._handle.index = figPoly.getNumPoints() - 1;
        figPoly.moveVertex(this._handle, point.x, point.y, true);
        this.editor.damageAll();
        mouseEvent.consume();
    }

    protected boolean nearLast(int n2, int n3) {
        return n2 > this._lastX - 8 && n2 < this._lastX + 8 && n3 > this._lastY - 8 && n3 < this._lastY + 8;
    }

    @Override
    public void done() {
        super.done();
        if (this._newItem != null) {
            this.editor.damageAll();
        }
        this._newItem = null;
        this._npoints = 0;
        this.sourceFigNode = null;
        this.startPort = null;
        this.startPortFig = null;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            LOG.debug((Object)"Esc pressed");
            this.done();
            keyEvent.consume();
        }
    }

    protected FigNode getSourceFigNode() {
        return this.sourceFigNode;
    }

    protected void setSourceFigNode(FigNode figNode) {
        this.sourceFigNode = figNode;
    }

    @Override
    protected Object getStartPort() {
        return this.startPort;
    }

    protected void setStartPort(Object object) {
        this.startPort = object;
    }

    protected Fig getStartPortFig() {
        return this.startPortFig;
    }

    protected void setStartPortFig(Fig fig) {
        this.startPortFig = fig;
    }

    protected Object getNewEdge() {
        return this.newEdge;
    }

    protected void setNewEdge(Object object) {
        this.newEdge = object;
    }
}

