/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.ModeCreateEdge;
import org.tigris.gef.base.ModeImpl;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;

public class ModeManager
implements KeyListener,
MouseListener,
MouseMotionListener,
Serializable {
    private static final long serialVersionUID = 3180158274454415153L;
    private Vector<FigModifyingMode> modes = new Vector();
    public Editor editor;
    private EventListenerList _listeners = new EventListenerList();
    private static Log LOG = LogFactory.getLog(ModeManager.class);

    public ModeManager(Editor editor) {
        this.editor = editor;
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public FigModifyingMode top() {
        if (this.modes.isEmpty()) {
            return null;
        }
        return this.modes.lastElement();
    }

    public void push(FigModifyingMode figModifyingMode) {
        if (figModifyingMode == null) {
            throw new IllegalArgumentException("You cannot push a null mode.");
        }
        if (!this.includes(figModifyingMode.getClass())) {
            this.modes.addElement(figModifyingMode);
            this.fireModeChanged();
        }
    }

    public FigModifyingMode pop() {
        if (this.modes.isEmpty()) {
            return null;
        }
        FigModifyingMode figModifyingMode = this.top();
        if (figModifyingMode.canExit()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Removing mode ".concat(String.valueOf(figModifyingMode)));
            }
            this.modes.removeElement(figModifyingMode);
            this.fireModeChanged();
        }
        return figModifyingMode;
    }

    public void popAll() {
        while (!this.modes.isEmpty() && this.top().canExit()) {
            this.modes.removeElement(this.top());
        }
        this.fireModeChanged();
    }

    public boolean includes(Class<? extends FigModifyingMode> clazz) {
        Iterator<FigModifyingMode> iterator = this.modes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public void leaveAll() {
        for (int i2 = this.modes.size() - 1; i2 >= 0; --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).leave();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.checkModeTransitions(keyEvent);
        for (int i2 = this.modes.size() - 1; i2 >= 0 && !keyEvent.isConsumed(); --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).keyTyped(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        for (int i2 = this.modes.size() - 1; i2 >= 0 && !keyEvent.isConsumed(); --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).keyReleased(keyEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Vector vector = (Vector)this.modes.clone();
        for (int i2 = vector.size() - 1; i2 >= 0 && !keyEvent.isConsumed(); --i2) {
            FigModifyingModeImpl figModifyingModeImpl = (FigModifyingModeImpl)vector.get(i2);
            if (!this.modes.contains(figModifyingModeImpl)) continue;
            figModifyingModeImpl.keyPressed(keyEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        for (int i2 = this.modes.size() - 1; i2 >= 0; --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        for (int i2 = this.modes.size() - 1; i2 >= 0; --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkModeTransitions(mouseEvent);
        for (int i2 = this.modes.size() - 1; i2 >= 0 && !mouseEvent.isConsumed(); --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkModeTransitions(mouseEvent);
        for (int i2 = this.modes.size() - 1; i2 >= 0; --i2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MousePressed testing mode " + this.modes.get(i2).getClass().getName()));
            }
            ((FigModifyingModeImpl)this.modes.get(i2)).mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkModeTransitions(mouseEvent);
        for (int i2 = this.modes.size() - 1; i2 >= 0; --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        for (int i2 = this.modes.size() - 1; i2 >= 0 && !mouseEvent.isConsumed(); --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        for (int i2 = this.modes.size() - 1; i2 >= 0 && !mouseEvent.isConsumed(); --i2) {
            ((FigModifyingModeImpl)this.modes.get(i2)).mouseExited(mouseEvent);
        }
    }

    public void checkModeTransitions(InputEvent inputEvent) {
        if (!this.top().canExit() && inputEvent.getID() == 501) {
            int n2;
            int n3 = ((MouseEvent)(inputEvent = (MouseEvent)inputEvent)).getX();
            Fig fig = this.editor.hit(n3, n2 = ((MouseEvent)inputEvent).getY());
            if (fig instanceof FigNode && ((FigNode)fig).isDragConnectable()) {
                if (((FigNode)fig).hitPort(n3, n2) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"ModeManager mousepressed detected on a draggable port");
                    }
                    ModeCreateEdge modeCreateEdge = new ModeCreateEdge(this.editor);
                    this.push(modeCreateEdge);
                    ((ModeImpl)modeCreateEdge).mousePressed((MouseEvent)inputEvent);
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ModeManager mousepressed detected but not on a port");
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ModeManager mousepressed detected but not on a port dragable node");
            }
        }
    }

    public void addModeChangeListener(ModeChangeListener modeChangeListener) {
        this._listeners.add(ModeChangeListener.class, modeChangeListener);
    }

    public void removeModeChangeListener(ModeChangeListener modeChangeListener) {
        this._listeners.remove(ModeChangeListener.class, modeChangeListener);
    }

    protected void fireModeChanged() {
        Object[] objectArray = this._listeners.getListenerList();
        ModeChangeEvent modeChangeEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ModeChangeListener.class) continue;
            if (modeChangeEvent == null) {
                modeChangeEvent = new ModeChangeEvent(this.editor, this.modes);
            }
            ((ModeChangeListener)objectArray[i2 + 1]).modeChange(modeChangeEvent);
        }
    }

    public void paint(Graphics graphics) {
        Iterator<FigModifyingMode> iterator = this.modes.iterator();
        while (iterator.hasNext()) {
            iterator.next().paint(graphics);
        }
    }

    public int count() {
        return this.modes.size();
    }
}

