/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.Localizer;

public class ModeModify
extends FigModifyingModeImpl {
    private static final long serialVersionUID = -914125238898272775L;
    private static final int MIN_DELTA = 4;
    private double degrees45 = 0.7853981633974483;
    private boolean _dragInProcess = false;
    private Point newMousePosition = new Point(0, 0);
    private Point dragStartMousePosition = new Point(0, 0);
    private Point dragStartSelectionPosition = null;
    private Handle _curHandle = new Handle(-1);
    private Rectangle _highlightTrap = null;
    private int _deltaMouseX;
    private int _deltaMouseY;
    private GraphModel graphModel;

    public ModeModify(Editor editor) {
        super(editor);
    }

    @Override
    public String instructions() {
        return Localizer.localize("GefBase", "ModeModifyInstructions");
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        Point point = mouseEvent.getPoint();
        this.getEditor().snap(point);
        this.newMousePosition.x = point.x;
        this.newMousePosition.y = point.y;
        this._deltaMouseX = point.x - this.dragStartMousePosition.x;
        this._deltaMouseY = point.y - this.dragStartMousePosition.y;
        if (!this._dragInProcess && Math.abs(this._deltaMouseX) < 4 && Math.abs(this._deltaMouseY) < 4) {
            return;
        }
        if (!this._dragInProcess) {
            this._dragInProcess = true;
            UndoManager.getInstance().startChain();
            this.graphModel = this.editor.getGraphModel();
            if (this.graphModel instanceof MutableGraphSupport) {
                ((MutableGraphSupport)this.graphModel).fireGraphChanged();
            }
        }
        boolean bl2 = mouseEvent.isControlDown();
        this.handleMouseDragged(bl2);
    }

    private void updateMouseDrag(KeyEvent keyEvent) {
        if (this._dragInProcess) {
            boolean bl2 = keyEvent.isControlDown();
            this.handleMouseDragged(bl2);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        this.updateMouseDrag(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
        this.updateMouseDrag(keyEvent);
    }

    private void handleMouseDragged(boolean bl2) {
        SelectionManager selectionManager;
        int n2 = this._deltaMouseX;
        int n3 = this._deltaMouseY;
        if (bl2 && n3 != 0) {
            double selectionManager2 = Math.atan2(n3, n2);
            selectionManager2 = this.degrees45 * (double)Math.round(selectionManager2 / this.degrees45);
            int n4 = n2;
            int n5 = n3;
            double point2 = Math.sqrt(n4 * n4 + n5 * n5);
            n2 = (int)(point2 * Math.cos(selectionManager2));
            n3 = (int)(point2 * Math.sin(selectionManager2));
        }
        if ((selectionManager = this.getEditor().getSelectionManager()).getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        if (this.dragStartSelectionPosition == null) {
            selectionManager.startDrag();
        }
        Point point = selectionManager.size() == 1 && (selectionManager.getFigs().get(0) instanceof FigEdge || this._curHandle.index > 0) ? new Point(this.dragStartMousePosition) : selectionManager.getDragLocation();
        if (this.dragStartSelectionPosition == null) {
            this.dragStartSelectionPosition = point;
        }
        Point point2 = new Point(this.dragStartSelectionPosition);
        point2.translate(n2, n3);
        this.getEditor().snap(point2);
        point2.x = Math.max(0, point2.x);
        point2.y = Math.max(0, point2.y);
        int n6 = point2.x - point.x;
        int n7 = point2.y - point.y;
        if (n6 != 0 || n7 != 0) {
            if (this._curHandle.index == -1) {
                this.setCursor(Cursor.getPredefinedCursor(13));
                if (this.legal(n6, n7, selectionManager)) {
                    selectionManager.drag(n6, n7);
                    return;
                }
            } else if (this._curHandle.index >= 0) {
                this.setCursor(Cursor.getPredefinedCursor(1));
                selectionManager.dragHandle(this.newMousePosition.x, this.newMousePosition.y, this.dragStartMousePosition.x, this.dragStartMousePosition.y, this._curHandle);
                selectionManager.endTrans();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.start();
        SelectionManager selectionManager = this.getEditor().getSelectionManager();
        if (selectionManager.size() == 0) {
            this.done();
        }
        if (selectionManager.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            mouseEvent.consume();
            return;
        }
        this.dragStartMousePosition = mouseEvent.getPoint();
        this.dragStartSelectionPosition = null;
        selectionManager.hitHandle(new Rectangle(n2 - 4, n3 - 4, 8, 8), this._curHandle);
        Globals.showStatus(this._curHandle.instructions);
        selectionManager.endTrans();
    }

    @Override
    public void mouseReleased(MouseEvent serializable) {
        this._dragInProcess = false;
        if (((InputEvent)serializable).isConsumed()) {
            return;
        }
        this.done();
        ((InputEvent)serializable).consume();
        serializable = this.editor.getSelectionManager();
        ((SelectionManager)serializable).stopDrag();
        serializable = ((SelectionManager)serializable).getFigs();
        int n2 = serializable.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = (Fig)serializable.get(i2);
            if (fig instanceof FigNode) {
                Rectangle rectangle = fig.getBounds();
                Object object = fig.getLayer().getContents();
                Fig fig2 = null;
                object = object.iterator();
                while (object.hasNext()) {
                    Rectangle rectangle2;
                    Fig fig3 = (Fig)object.next();
                    if (!(fig3 instanceof FigNode) || !fig3.getUseTrapRect() || (rectangle2 = fig3.getTrapRect()) == null || !rectangle2.contains(rectangle.x, rectangle.y) || !rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) continue;
                    fig2 = fig3;
                }
                fig.setEnclosingFig(fig2);
            } else if (fig instanceof FigEdge) {
                ((FigEdge)fig).computeRoute();
                fig.endTrans();
            }
            fig.endTrans();
        }
    }

    @Override
    public void done() {
        super.done();
        this.getEditor().getSelectionManager().cleanUp();
        if (this._highlightTrap != null) {
            this.editor.damaged(this._highlightTrap);
            this._highlightTrap = null;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._highlightTrap != null) {
            Color color = Globals.getPrefs().getRubberbandColor();
            graphics.setColor(color);
            graphics.drawRect(this._highlightTrap.x - 1, this._highlightTrap.y - 1, this._highlightTrap.width + 1, this._highlightTrap.height + 1);
            graphics.drawRect(this._highlightTrap.x - 2, this._highlightTrap.y - 2, this._highlightTrap.width + 3, this._highlightTrap.height + 3);
        }
    }

    private void damageHighlightTrap() {
        if (this._highlightTrap == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(this._highlightTrap);
        rectangle.x -= 2;
        rectangle.y -= 2;
        rectangle.width += 4;
        rectangle.height += 4;
        this.editor.damaged(rectangle);
    }

    private boolean legal(int n2, int n3, SelectionManager object) {
        this.damageHighlightTrap();
        this._highlightTrap = null;
        object = this.getNodes(((SelectionManager)((Object)object)).getDraggableFigs());
        int n4 = object.size();
        Rectangle rectangle = new Rectangle();
        boolean bl2 = true;
        Fig fig = null;
        for (int i2 = 0; i2 < n4; ++i2) {
            Fig fig2 = object.get(i2);
            fig2.getBounds(rectangle);
            rectangle.x += n2;
            rectangle.y += n3;
            Layer layer = fig2.getLayer();
            for (Fig fig3 : this.getNodes(layer.getContents())) {
                if (!fig2.getUseTrapRect() && !fig3.getUseTrapRect() || object.contains(fig3) || fig3.getEnclosingFig() == fig2 || !fig3.isVisible()) continue;
                for (Rectangle rectangle2 : fig3.getTrapRects(fig2)) {
                    if (rectangle2 == null || !rectangle2.intersects(rectangle)) continue;
                    if (rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) {
                        bl2 = false;
                        fig = fig3;
                        continue;
                    }
                    if (rectangle.contains(rectangle2.x, rectangle2.y) && rectangle.contains(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height)) continue;
                    this._highlightTrap = rectangle2;
                    this.damageHighlightTrap();
                    return false;
                }
            }
            if (!(bl2 ? !((MutableGraphSupport)this.graphModel).isEnclosable(((FigNode)fig2).getOwner(), null) : !((MutableGraphSupport)this.graphModel).isEnclosable(((FigNode)fig2).getOwner(), ((FigNode)fig).getOwner()))) continue;
            return false;
        }
        return true;
    }

    private List<FigNode> getNodes(List<Fig> object) {
        ArrayList<FigNode> arrayList = new ArrayList<FigNode>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Fig fig = (Fig)object.next();
            if (!(fig instanceof FigNode)) continue;
            arrayList.add((FigNode)fig);
        }
        return arrayList;
    }
}

